/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm.iterative;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.gui.additionalResults.AdditionalResults;
import es.unex.sextante.gui.algorithm.iterative.IterativeAlgorithmSingleUnit;
import es.unex.sextante.gui.algorithm.iterative.SingleFeatureVectorLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputNumericalValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class IterativeAlgorithmMonitorableTask
implements Runnable {
    private String m_sErrorMessage;
    private final GeoAlgorithm m_Algorithm;
    private ITaskMonitor m_ProgressMonitor = null;
    private final String m_sParameterToIterateOver;
    private final SingleFeatureVectorLayer m_SFVL;
    private final IFeatureIterator m_Iterator;
    private final int m_iShapesCount;
    private String m_sLayerName;
    private final ArrayList<ArrayList<OutputNumericalValue>> m_NumericalOutputs;

    public IterativeAlgorithmMonitorableTask(GeoAlgorithm algorithm, JDialog parent, String sParameterToIterateOver) throws GeoAlgorithmExecutionException {
        try {
            this.m_Algorithm = algorithm;
            this.m_NumericalOutputs = new ArrayList();
            this.m_sParameterToIterateOver = sParameterToIterateOver;
            this.m_ProgressMonitor = SextanteGUI.getOutputFactory().getTaskMonitor(algorithm.getName(), algorithm.isDeterminatedProcess(), parent);
            IVectorLayer layer = this.m_Algorithm.getParameters().getParameter(this.m_sParameterToIterateOver).getParameterValueAsVectorLayer();
            this.m_Iterator = layer.iterator();
            this.m_iShapesCount = layer.getShapesCount();
            this.m_SFVL = new SingleFeatureVectorLayer(layer);
            this.m_Algorithm.getParameters().getParameter(this.m_sParameterToIterateOver).setParameterValue((Object)this.m_SFVL);
            this.m_sLayerName = layer.getName();
        }
        catch (Exception e) {
            if (this.m_ProgressMonitor != null) {
                this.m_ProgressMonitor.close();
            }
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    @Override
    public void run() {
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        HashMap<String, String> filenames = new HashMap<String, String>();
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output output = ooset.getOutput(i);
            IOutputChannel channel = output.getOutputChannel();
            if (channel == null) continue;
            if (channel instanceof FileOutputChannel) {
                FileOutputChannel foc = (FileOutputChannel)channel;
                filenames.put(output.getName(), foc.getFilename());
                continue;
            }
            this.m_sErrorMessage = Sextante.getText((String)"Unsupported output channel:") + channel.toString();
            JOptionPane.showMessageDialog(null, this.m_sErrorMessage, Sextante.getText((String)"Error"), 0);
        }
        int iIteration = 1;
        while (this.m_Iterator.hasNext()) {
            try {
                IFeature feature = this.m_Iterator.next();
                this.m_SFVL.setFeature(feature.getGeometry(), feature.getRecord().getValues());
                this.m_SFVL.setName(this.m_sLayerName + "[" + Integer.toString(iIteration) + "]");
                this.m_SFVL.setID(iIteration);
                Set names = filenames.keySet();
                for (String sName : names) {
                    String sFilename = (String)filenames.get(sName);
                    if (sFilename == null) {
                        ooset.getOutput(sName).setOutputChannel((IOutputChannel)new FileOutputChannel(null));
                        continue;
                    }
                    sFilename = sFilename + "_" + Integer.toString(iIteration);
                    ooset.getOutput(sName).setOutputChannel((IOutputChannel)new FileOutputChannel(sFilename));
                }
                this.m_ProgressMonitor.setDescriptionPrefix("[" + Integer.toString(iIteration) + "/" + Integer.toString(this.m_iShapesCount) + "] ");
                GeoAlgorithm alg = this.m_Algorithm.getNewInstance();
                IterativeAlgorithmSingleUnit unit = new IterativeAlgorithmSingleUnit(alg, this.m_ProgressMonitor, Integer.toString(iIteration), this.m_NumericalOutputs);
                ExecutorService pool = Executors.newFixedThreadPool(2);
                Future<Boolean> future = pool.submit(unit);
                Boolean success = null;
                success = future.get();
                if (!success.booleanValue() || this.m_ProgressMonitor.isCanceled()) break;
                ++iIteration;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
                this.m_sErrorMessage = e.getMessage();
                break;
            }
        }
        this.m_ProgressMonitor.close();
        if (this.m_sErrorMessage != null) {
            JOptionPane.showMessageDialog(null, this.m_sErrorMessage, Sextante.getText((String)"Error"), 0);
        }
        JScrollPane table = this.createNumericalOutputsTable();
        SextanteGUI.getInputFactory().clearDataObjects();
        SextanteGUI.getInputFactory().createDataObjects();
        if (table != null) {
            AdditionalResults.addComponent(new ObjectAndDescription(this.m_Algorithm.getName() + "[" + this.m_sLayerName + "]", (Object)table));
        }
    }

    private JScrollPane createNumericalOutputsTable() {
        if (this.m_NumericalOutputs.size() == 0) {
            return null;
        }
        JScrollPane jScrollPane = new JScrollPane();
        JTable jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        int iRecordsCount = this.m_NumericalOutputs.size();
        int iFieldsCount = this.m_NumericalOutputs.get(0).size();
        Object[] fields = new String[iFieldsCount];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.m_NumericalOutputs.get(0).get(i).getDescription();
        }
        Object[][] data2 = new String[iRecordsCount][fields.length];
        for (int i = 0; i < iRecordsCount; ++i) {
            for (int j = 0; j < iFieldsCount; ++j) {
                data2[i][j] = this.m_NumericalOutputs.get(i).get(j).getOutputObject().toString();
            }
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setDataVector(data2, fields);
        jTable.setModel(model);
        jTable.setEnabled(false);
        return jScrollPane;
    }
}

