/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm.iterative;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ProcessTask;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputNumericalValue;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class IterativeAlgorithmSingleUnit
implements Callable<Boolean> {
    private final GeoAlgorithm m_Algorithm;
    private StringBuffer m_sLog;
    private final ITaskMonitor m_TaskMonitor;
    private final String m_sUnitName;
    private final ArrayList<ArrayList<OutputNumericalValue>> m_NumericalOutputs;

    public IterativeAlgorithmSingleUnit(GeoAlgorithm alg, ITaskMonitor monitor, String sUnitName, ArrayList<ArrayList<OutputNumericalValue>> numericalOutputs) {
        this.m_Algorithm = alg;
        this.m_TaskMonitor = monitor;
        this.m_sUnitName = sUnitName;
        this.m_NumericalOutputs = numericalOutputs;
    }

    @Override
    public Boolean call() throws GeoAlgorithmExecutionException {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        Future p = pool.submit(new ProcessTask(this.m_Algorithm, SextanteGUI.getOutputFactory(), this.m_TaskMonitor));
        try {
            Boolean success = (Boolean)p.get();
            if (success != null && success.booleanValue()) {
                this.changeOutputDescriptions();
                this.collectIndividualNumericalOutputs();
                Runnable postProcess = SextanteGUI.getPostProcessTask(this.m_Algorithm, false);
                if (postProcess != null) {
                    postProcess.run();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    private void collectIndividualNumericalOutputs() {
        ArrayList<OutputNumericalValue> numericalOutputs = new ArrayList<OutputNumericalValue>();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output out = ooset.getOutput(i);
            if (!(out instanceof OutputNumericalValue)) continue;
            numericalOutputs.add((OutputNumericalValue)out);
        }
        this.m_NumericalOutputs.add(numericalOutputs);
    }

    private void changeOutputDescriptions() {
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output out = ooset.getOutput(i);
            if (out instanceof OutputNumericalValue) continue;
            out.setDescription(out.getDescription() + " <" + this.m_sUnitName + ">");
        }
    }

    public String getLog() {
        return this.m_sLog.toString();
    }
}

