/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.gui.exceptions.TooLargeGridExtentException;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AnalysisExtentPanel
extends JPanel {
    protected static final int BIG_SIZE = 5000000;
    private JTextField jTextFieldCols;
    private JTextField jTextFieldRows;
    protected JTextField jTextFieldCellSize;
    protected JTextField jTextFieldXMax;
    protected JTextField jTextFieldXMin;
    protected JTextField jTextFieldYMax;
    protected JTextField jTextFieldYMin;
    private JLabel jLabelRowsCols;
    private JLabel jLabelCellSize;
    private JLabel jLabelRangeY;
    private JLabel jLabelRangeX;
    protected JPanel jPanelAnalysisExtentValues;
    private JPanel jPanelAnalysisExtentOptions;
    private JRadioButton jRadioButtonAdjustToInputDataExtent;
    private JRadioButton jRadioButtonUserDefinedExtent;
    private ButtonGroup jButtonGroup;
    protected final GeoAlgorithm m_Algorithm;
    protected AnalysisExtent m_AnalysisExtent;

    public AnalysisExtentPanel(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        TableLayout jPanelAnalysisExtentLayout = new TableLayout((double[][])new double[][]{{1.0, -1.0, 1.0}, {1.0, -3.0, -1.0, 1.0}});
        jPanelAnalysisExtentLayout.setHGap(5);
        jPanelAnalysisExtentLayout.setVGap(5);
        this.setLayout((LayoutManager)jPanelAnalysisExtentLayout);
        this.add((Component)this.getJPanelAnalysisExtentOptions(), "1, 1");
        this.add((Component)this.getJPanelAnalysisExtentValues(), "1, 2");
        if (this.m_Algorithm.canDefineOutputExtentFromInput()) {
            this.getJPanelAnalysisExtentValues().setVisible(false);
        } else {
            this.getJPanelAnalysisExtentValues().setVisible(true);
        }
    }

    public void adjustExtent() throws TooLargeGridExtentException, WrongAnalysisExtentException {
        this.m_Algorithm.setAnalysisExtent((AnalysisExtent)null);
        this.m_AnalysisExtent = null;
        if (!this.getJRadioButtonAdjustToInputDataExtent().isSelected()) {
            this.m_AnalysisExtent = new AnalysisExtent();
            try {
                this.m_AnalysisExtent.setCellSize(Double.parseDouble(this.jTextFieldCellSize.getText()));
                this.m_AnalysisExtent.setXRange(Double.parseDouble(this.jTextFieldXMin.getText()), Double.parseDouble(this.jTextFieldXMax.getText()), true);
                this.m_AnalysisExtent.setYRange(Double.parseDouble(this.jTextFieldYMin.getText()), Double.parseDouble(this.jTextFieldYMax.getText()), true);
            }
            catch (NumberFormatException e) {
                throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_region"));
            }
        }
    }

    private ButtonGroup getJButtonGroup() {
        if (this.jButtonGroup == null) {
            this.jButtonGroup = new ButtonGroup();
        }
        return this.jButtonGroup;
    }

    protected JRadioButton getJRadioButtonUserDefinedExtent() {
        if (this.jRadioButtonUserDefinedExtent == null) {
            this.jRadioButtonUserDefinedExtent = new JRadioButton();
            this.jRadioButtonUserDefinedExtent.setText(Sextante.getText((String)"User_defined"));
            this.jRadioButtonUserDefinedExtent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalysisExtentPanel.this.setTextFieldsEnabled(true);
                    AnalysisExtentPanel.this.extentHasChanged();
                }
            });
        }
        return this.jRadioButtonUserDefinedExtent;
    }

    protected JRadioButton getJRadioButtonAdjustToInputDataExtent() {
        if (this.jRadioButtonAdjustToInputDataExtent == null) {
            this.jRadioButtonAdjustToInputDataExtent = new JRadioButton();
            this.jRadioButtonAdjustToInputDataExtent.setText(Sextante.getText((String)"Fit_to_input_layers"));
            this.jRadioButtonAdjustToInputDataExtent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalysisExtentPanel.this.getJPanelAnalysisExtentValues().setVisible(false);
                }
            });
        }
        return this.jRadioButtonAdjustToInputDataExtent;
    }

    private JPanel getJPanelAnalysisExtentOptions() {
        if (this.jPanelAnalysisExtentOptions == null) {
            this.jPanelAnalysisExtentOptions = new JPanel();
            TableLayout jPanelRasterExtentOptionsLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0}, {-1.0, -1.0, -1.0, -1.0}});
            jPanelRasterExtentOptionsLayout.setHGap(5);
            jPanelRasterExtentOptionsLayout.setVGap(5);
            this.jPanelAnalysisExtentOptions.setLayout((LayoutManager)jPanelRasterExtentOptionsLayout);
            this.jPanelAnalysisExtentOptions.setPreferredSize(new Dimension(660, 150));
            this.jPanelAnalysisExtentOptions.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Extent_from")));
            this.jPanelAnalysisExtentOptions.add((Component)this.getJRadioButtonUserDefinedExtent(), "1, 2");
            this.getJButtonGroup().add(this.getJRadioButtonUserDefinedExtent());
            if (this.m_Algorithm.canDefineOutputExtentFromInput()) {
                this.jPanelAnalysisExtentOptions.add((Component)this.getJRadioButtonAdjustToInputDataExtent(), "1, 1");
                this.getJButtonGroup().add(this.getJRadioButtonAdjustToInputDataExtent());
                this.getJRadioButtonAdjustToInputDataExtent().setSelected(true);
            } else {
                this.getJRadioButtonUserDefinedExtent().setSelected(true);
            }
        }
        return this.jPanelAnalysisExtentOptions;
    }

    protected JPanel getJPanelAnalysisExtentValues() {
        if (this.jPanelAnalysisExtentValues == null) {
            this.jPanelAnalysisExtentValues = new JPanel();
            TableLayout jPanelRasterExtentValuesLayout = new TableLayout((double[][])new double[][]{{255.0, -1.0, -1.0}, {-3.0, -3.0, -3.0, -3.0, -1.0}});
            jPanelRasterExtentValuesLayout.setHGap(5);
            jPanelRasterExtentValuesLayout.setVGap(5);
            this.jPanelAnalysisExtentValues.setLayout((LayoutManager)jPanelRasterExtentValuesLayout);
            this.jPanelAnalysisExtentValues.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Extent__values")));
            this.jPanelAnalysisExtentValues.setPreferredSize(new Dimension(660, 145));
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeX(), "0, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelCellSize(), "0, 2");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCellSize(), "1, 2");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldXMin(), "1, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldXMax(), "2, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldYMin(), "1, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldYMax(), "2, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeY(), "0, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRowsCols(), "0, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldRows(), "1, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCols(), "2, 3");
        }
        return this.jPanelAnalysisExtentValues;
    }

    protected JLabel getJLabelRangeX() {
        if (this.jLabelRangeX == null) {
            this.jLabelRangeX = new JLabel();
            this.jLabelRangeX.setText(Sextante.getText((String)"Range_X"));
        }
        return this.jLabelRangeX;
    }

    protected JTextField getNewJTextField() {
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        double d = Double.parseDouble(content);
                        AnalysisExtentPanel.this.extentHasChanged();
                    }
                    catch (NumberFormatException nfe) {
                        AnalysisExtentPanel.this.getToolkit().beep();
                        textField.requestFocus();
                    }
                }
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                AnalysisExtentPanel.this.validateKeyTyping(event);
            }
        });
        return jTextField;
    }

    protected JTextField getJTextFieldXMin() {
        if (this.jTextFieldXMin == null) {
            this.jTextFieldXMin = this.getNewJTextField();
        }
        return this.jTextFieldXMin;
    }

    protected JTextField getJTextFieldXMax() {
        if (this.jTextFieldXMax == null) {
            this.jTextFieldXMax = this.getNewJTextField();
        }
        return this.jTextFieldXMax;
    }

    protected JTextField getJTextFieldYMin() {
        if (this.jTextFieldYMin == null) {
            this.jTextFieldYMin = this.getNewJTextField();
        }
        return this.jTextFieldYMin;
    }

    protected JTextField getJTextFieldYMax() {
        if (this.jTextFieldYMax == null) {
            this.jTextFieldYMax = this.getNewJTextField();
        }
        return this.jTextFieldYMax;
    }

    protected JLabel getJLabelRangeY() {
        if (this.jLabelRangeY == null) {
            this.jLabelRangeY = new JLabel();
            this.jLabelRangeY.setText(Sextante.getText((String)"Range_Y"));
        }
        return this.jLabelRangeY;
    }

    protected JLabel getJLabelCellSize() {
        if (this.jLabelCellSize == null) {
            this.jLabelCellSize = new JLabel();
            this.jLabelCellSize.setText(Sextante.getText((String)"Cell_size"));
        }
        return this.jLabelCellSize;
    }

    protected JTextField getJTextFieldCellSize() {
        if (this.jTextFieldCellSize == null) {
            this.jTextFieldCellSize = new JTextField();
            this.jTextFieldCellSize.setText("1");
            this.jTextFieldCellSize.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    String content = textField.getText();
                    if (content.length() != 0) {
                        try {
                            double d = Double.parseDouble(content);
                            if (d <= 0.0) {
                                throw new NumberFormatException();
                            }
                            AnalysisExtentPanel.this.extentHasChanged();
                        }
                        catch (NumberFormatException nfe) {
                            AnalysisExtentPanel.this.getToolkit().beep();
                            textField.requestFocus();
                        }
                    }
                }
            });
            this.jTextFieldCellSize.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent event) {
                    AnalysisExtentPanel.this.validateKeyTyping(event);
                }
            });
        }
        return this.jTextFieldCellSize;
    }

    protected JLabel getJLabelRowsCols() {
        if (this.jLabelRowsCols == null) {
            this.jLabelRowsCols = new JLabel();
            this.jLabelRowsCols.setText(Sextante.getText((String)"Number_of_rows-cols"));
        }
        return this.jLabelRowsCols;
    }

    protected JTextField getJTextFieldRows() {
        if (this.jTextFieldRows == null) {
            this.jTextFieldRows = new JTextField();
            this.jTextFieldRows.setEnabled(false);
        }
        return this.jTextFieldRows;
    }

    protected JTextField getJTextFieldCols() {
        if (this.jTextFieldCols == null) {
            this.jTextFieldCols = new JTextField();
            this.jTextFieldCols.setEnabled(false);
        }
        return this.jTextFieldCols;
    }

    protected void validateKeyTyping(KeyEvent event) {
        String text = ((JTextField)event.getSource()).getText();
        switch (event.getKeyChar()) {
            case '\n': {
                this.extentHasChanged();
                break;
            }
            default: {
                text = text + event.getKeyChar();
            }
        }
    }

    protected void setTextFieldsEnabled(boolean bEnabled) {
        this.getJPanelAnalysisExtentValues().setVisible(true);
        this.getJTextFieldXMin().setEnabled(bEnabled);
        this.getJTextFieldXMax().setEnabled(bEnabled);
        this.getJTextFieldYMin().setEnabled(bEnabled);
        this.getJTextFieldYMax().setEnabled(bEnabled);
    }

    protected void extentHasChanged() {
        try {
            double dRangeX = Math.abs(Double.parseDouble(this.getJTextFieldXMax().getText()) - Double.parseDouble(this.getJTextFieldXMin().getText()));
            double dRangeY = Math.abs(Double.parseDouble(this.getJTextFieldYMax().getText()) - Double.parseDouble(this.getJTextFieldYMin().getText()));
            double dCellSize = Double.parseDouble(this.getJTextFieldCellSize().getText());
            int iRows = (int)Math.floor(dRangeY / dCellSize);
            int iCols = (int)Math.floor(dRangeX / dCellSize);
            this.getJTextFieldRows().setText(Integer.toString(iRows));
            this.getJTextFieldCols().setText(Integer.toString(iCols));
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public AnalysisExtent getExtent() {
        return this.m_AnalysisExtent;
    }
}

