/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch;

import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputNumericalValue;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;

public class BatchProcessSingleUnit
implements Callable<Boolean> {
    private final HashMap m_Parameters;
    private final GeoAlgorithm m_Algorithm;
    private final HashMap m_DataObjects;
    private final HashMap m_OutputSettings;
    private StringBuffer m_sLog;
    private final AnalysisExtent m_AnalysisExtent;
    private final ITaskMonitor m_TaskMonitor;
    private final ArrayList<ArrayList<OutputNumericalValue>> m_NumericalOutputs;

    public BatchProcessSingleUnit(GeoAlgorithm alg, HashMap parameters, HashMap output, AnalysisExtent analysisExtent, ITaskMonitor monitor, ArrayList<ArrayList<OutputNumericalValue>> numericalOutputs) {
        this.m_Algorithm = alg;
        this.m_Parameters = parameters;
        this.m_OutputSettings = output;
        this.m_DataObjects = new HashMap();
        this.m_AnalysisExtent = analysisExtent;
        this.m_TaskMonitor = monitor;
        this.m_NumericalOutputs = numericalOutputs;
    }

    @Override
    public Boolean call() throws GeoAlgorithmExecutionException {
        this.m_sLog = new StringBuffer();
        if (this.assignParameters() && this.assignOutputSettings() && this.assignExtent()) {
            boolean bReturn = this.m_Algorithm.execute(this.m_TaskMonitor, SextanteGUI.getOutputFactory());
            this.collectIndividualNumericalOutputs();
            this.m_DataObjects.clear();
            return bReturn;
        }
        this.m_DataObjects.clear();
        return false;
    }

    private void collectIndividualNumericalOutputs() {
        ArrayList<OutputNumericalValue> numericalOutputs = new ArrayList<OutputNumericalValue>();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output out = ooset.getOutput(i);
            if (!(out instanceof OutputNumericalValue)) continue;
            numericalOutputs.add((OutputNumericalValue)out);
        }
        this.m_NumericalOutputs.add(numericalOutputs);
    }

    private boolean assignExtent() {
        if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
            this.m_Algorithm.setAnalysisExtent(this.m_AnalysisExtent);
            return this.m_Algorithm.adjustOutputExtent();
        }
        return true;
    }

    public String getLog() {
        return this.m_sLog.toString();
    }

    private boolean assignOutputSettings() {
        Set set = this.m_OutputSettings.keySet();
        Iterator iter = set.iterator();
        try {
            while (iter.hasNext()) {
                String sOutputID = (String)iter.next();
                String sValue = (String)this.m_OutputSettings.get(sOutputID);
                Output out = this.m_Algorithm.getOutputObjects().getOutput(sOutputID);
                if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable) && !(out instanceof Output3DRasterLayer)) continue;
                this.m_sLog.append(out.getDescription() + ":");
                this.m_sLog.append(sValue + "\n");
                out.setOutputChannel((IOutputChannel)new FileOutputChannel(sValue));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean assignParameters() {
        Parameter parameter;
        String sValue;
        Set set = this.m_Parameters.keySet();
        for (String sParamID : set) {
            sValue = (String)this.m_Parameters.get(sParamID);
            try {
                parameter = this.m_Algorithm.getParameters().getParameter(sParamID);
            }
            catch (WrongParameterIDException e) {
                return false;
            }
            if (!(parameter instanceof ParameterDataObject)) continue;
            if (!this.setValueFromString(sValue, parameter)) {
                this.m_sLog.append("[error]\n");
                return false;
            }
            this.m_sLog.append("[ok]\n");
        }
        for (String sParamID : set) {
            sValue = (String)this.m_Parameters.get(sParamID);
            try {
                parameter = this.m_Algorithm.getParameters().getParameter(sParamID);
            }
            catch (WrongParameterIDException e) {
                return false;
            }
            if (parameter instanceof ParameterDataObject) continue;
            if (!this.setValueFromString(sValue, parameter)) {
                this.m_sLog.append("[error]\n");
                return false;
            }
            this.m_sLog.append("[ok]\n");
        }
        return true;
    }

    private boolean setValueFromString(String sValue, Parameter parameter) {
        this.m_sLog.append(parameter.getParameterDescription());
        this.m_sLog.append(":");
        this.m_sLog.append(sValue);
        if (parameter instanceof ParameterNumericalValue) {
            return this.assignNumericalValue(sValue, (ParameterNumericalValue)parameter);
        }
        if (parameter instanceof ParameterString) {
            return this.assignString(sValue, (ParameterString)parameter);
        }
        if (parameter instanceof ParameterSelection) {
            return this.assignSelection(sValue, (ParameterSelection)parameter);
        }
        if (parameter instanceof ParameterFixedTable) {
            return this.assignFixedTable(sValue, (ParameterFixedTable)parameter);
        }
        if (parameter instanceof ParameterPoint) {
            return this.assignPoint(sValue, (ParameterPoint)parameter);
        }
        if (parameter instanceof ParameterBoolean) {
            return this.assignBoolean(sValue, parameter);
        }
        if (parameter instanceof ParameterFilepath) {
            return this.assignFilepath(sValue, (ParameterFilepath)parameter);
        }
        if (parameter instanceof ParameterTableField) {
            return this.assignTableField(sValue, (ParameterTableField)parameter);
        }
        if (parameter instanceof ParameterBand) {
            return this.assignBand(sValue, (ParameterBand)parameter);
        }
        if (parameter instanceof ParameterMultipleInput) {
            return this.assignMultipleInput(sValue, (ParameterMultipleInput)parameter);
        }
        if (parameter instanceof ParameterDataObject) {
            return this.assignDataObject(sValue, (ParameterDataObject)parameter);
        }
        return false;
    }

    private boolean assignMultipleInput(String sValue, ParameterMultipleInput parameter) {
        boolean bLastTokenIsFile = false;
        ArrayList<Object> array = new ArrayList<Object>();
        String sFile = null;
        try {
            AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            String[] sTokens = sValue.split(",");
            if (ai.getDataType() == 7) {
                for (int i = 0; i < sTokens.length; ++i) {
                    if (this.isPositiveInteger(sTokens[i])) {
                        if (sFile == null) {
                            return false;
                        }
                        IRasterLayer layer = (IRasterLayer)this.getDataObject(sFile);
                        if (layer == null) {
                            return false;
                        }
                        array.add(new RasterLayerAndBand(layer, Integer.parseInt(sTokens[i])));
                        bLastTokenIsFile = false;
                        continue;
                    }
                    if (bLastTokenIsFile) {
                        return false;
                    }
                    File f = new File(sTokens[i].trim());
                    if (!f.exists()) {
                        return false;
                    }
                    sFile = sTokens[i];
                    bLastTokenIsFile = true;
                }
            } else {
                for (int i = 0; i < sTokens.length; ++i) {
                    File f = new File(sTokens[i].trim());
                    if (!f.exists()) {
                        return false;
                    }
                    array.add(this.getDataObject(sTokens[i].trim()));
                }
            }
            parameter.setParameterValue(array);
            return (array.size() > 0 || !ai.getIsMandatory()) && !bLastTokenIsFile;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean assignDataObject(String sValue, ParameterDataObject parameter) {
        Object obj = this.getDataObject(sValue);
        if (obj != null) {
            if (parameter instanceof ParameterRasterLayer) {
                return parameter.setParameterValue(obj);
            }
            if (parameter instanceof Parameter3DRasterLayer) {
                return parameter.setParameterValue(obj);
            }
            if (parameter instanceof ParameterVectorLayer) {
                return parameter.setParameterValue(obj);
            }
            if (parameter instanceof ParameterTable) {
                return parameter.setParameterValue(obj);
            }
            return false;
        }
        return false;
    }

    private Object getDataObject(String sKey) {
        Object obj = this.m_DataObjects.get(sKey);
        if (obj == null && (obj = SextanteGUI.getInputFactory().openDataObjectFromFile(sKey)) != null) {
            this.m_DataObjects.put(sKey, obj);
        }
        return obj;
    }

    private boolean assignBand(String sValue, ParameterBand parameter) {
        try {
            Integer value = new Integer(Integer.parseInt(sValue) - 1);
            parameter.setParameterValue((Object)value);
            return true;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    private boolean assignTableField(String sValue, ParameterTableField parameter) {
        try {
            AdditionalInfoTableField aivl = (AdditionalInfoTableField)parameter.getParameterAdditionalInfo();
            ParametersSet ps = this.m_Algorithm.getParameters();
            String sParent = aivl.getParentParameterName();
            Parameter parentParam = ps.getParameter(sParent);
            if (parentParam instanceof ParameterVectorLayer) {
                IVectorLayer layer = ps.getParameterValueAsVectorLayer(sParent);
                String[] sNames = layer.getFieldNames();
                for (int i = 0; i < sNames.length; ++i) {
                    if (!layer.getFieldName(i).equals(sValue)) continue;
                    parameter.setParameterValue((Object)new Integer(i));
                    return true;
                }
                return false;
            }
            ITable table = ps.getParameterValueAsTable(sParent);
            String[] sNames = table.getFieldNames();
            for (int i = 0; i < sNames.length; ++i) {
                if (!table.getFieldName(i).equals(sValue)) continue;
                parameter.setParameterValue((Object)new Integer(i));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    private boolean assignFixedTable(String sValue, ParameterFixedTable parameter) {
        int iToken = 0;
        StringTokenizer st = new StringTokenizer(sValue, ",");
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iRows = ai.getRowsCount();
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            FixedTableModel tableModel = new FixedTableModel(ai.getCols(), iCols, bIsNumberOfRowsFixed);
            if (bIsNumberOfRowsFixed ? st.countTokens() != iCols * iRows : st.countTokens() % iCols != 0) {
                return false;
            }
            while (st.hasMoreTokens()) {
                int iRow = (int)Math.floor((double)iToken / (double)iCols);
                int iCol = iToken % iCols;
                String sToken = st.nextToken().trim();
                tableModel.setValueAt((Object)sToken, iRow, iCol);
                ++iToken;
            }
            parameter.setParameterValue((Object)tableModel);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean assignFilepath(String sValue, ParameterFilepath parameter) {
        parameter.setParameterValue((Object)sValue);
        return true;
    }

    private boolean assignPoint(String sValue, ParameterPoint parameter) {
        try {
            String[] sCoords = sValue.split(",");
            double dX = Double.parseDouble(sCoords[0]);
            double dY = Double.parseDouble(sCoords[1]);
            Point2D.Double pt = new Point2D.Double(dX, dY);
            parameter.setParameterValue((Object)pt);
            return true;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    private boolean assignNumericalValue(String sValue, ParameterNumericalValue parameter) {
        try {
            Double value = new Double(Double.parseDouble(sValue));
            parameter.setParameterValue((Object)value);
            return true;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    private boolean assignSelection(String sValue, ParameterSelection parameter) {
        try {
            AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
            String[] sValues = ai.getValues();
            for (int i = 0; i < sValues.length; ++i) {
                if (!sValue.equals(sValues[i])) continue;
                parameter.setParameterValue((Object)new Integer(i));
                return true;
            }
        }
        catch (NullParameterAdditionalInfoException e) {
            return false;
        }
        return false;
    }

    private boolean assignBoolean(String sValue, Parameter parameter) {
        if (sValue.toLowerCase().equals("true")) {
            parameter.setParameterValue((Object)new Boolean(true));
        } else {
            parameter.setParameterValue((Object)new Boolean(false));
        }
        return true;
    }

    private boolean assignString(String sValue, ParameterString parameter) {
        parameter.setParameterValue((Object)sValue);
        return true;
    }

    private boolean isPositiveInteger(String s) {
        try {
            int i = Integer.parseInt(s);
            return i > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

