/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.additionalResults.AdditionalResults;
import es.unex.sextante.gui.batch.nonFileBased.BatchProcessSingleUnit;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.OutputNumericalValue;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public class BatchProcessMonitorableTask
implements Runnable {
    private StringBuffer m_sLog;
    private final ArrayList m_Parameters;
    private final ArrayList m_Outputs;
    private final AnalysisExtent m_AnalysisExtent;
    private final GeoAlgorithm m_Algorithm;
    private final ITaskMonitor m_ProgressMonitor;
    private final ArrayList<ArrayList<OutputNumericalValue>> m_NumericalOutputs;

    public BatchProcessMonitorableTask(GeoAlgorithm algorithm, ArrayList parameters, ArrayList outputs, AnalysisExtent analysisExtent, JDialog parent) {
        this.m_Parameters = parameters;
        this.m_Outputs = outputs;
        this.m_NumericalOutputs = new ArrayList();
        this.m_AnalysisExtent = analysisExtent;
        this.m_Algorithm = algorithm;
        this.m_ProgressMonitor = SextanteGUI.getOutputFactory().getTaskMonitor(algorithm.getName(), algorithm.isDeterminatedProcess(), parent);
    }

    @Override
    public void run() {
        JScrollPane table;
        String LINE = "----------------------------------------\n";
        BatchProcessSingleUnit unit = null;
        this.m_sLog = new StringBuffer();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            this.m_sLog.append(Sextante.getText((String)"Process") + " " + Integer.toString(i + 1) + "\n");
            this.m_sLog.append("----------------------------------------\n");
            this.m_ProgressMonitor.setDescriptionPrefix("[" + Integer.toString(i + 1) + "/" + Integer.toString(this.m_Parameters.size()) + "]");
            try {
                HashMap param = (HashMap)this.m_Parameters.get(i);
                HashMap output = (HashMap)this.m_Outputs.get(i);
                GeoAlgorithm alg = this.m_Algorithm.getNewInstance();
                unit = new BatchProcessSingleUnit(alg, param, output, this.m_AnalysisExtent, this.m_ProgressMonitor, this.m_NumericalOutputs);
                ExecutorService pool = Executors.newFixedThreadPool(2);
                Future<Boolean> future = pool.submit(unit);
                Boolean success = null;
                success = future.get();
                if (!success.booleanValue() || this.m_ProgressMonitor.isCanceled()) {
                    this.m_sLog.append(unit.getLog());
                    this.m_sLog.append(Sextante.getText((String)"Error_or_process_canceled_by_user") + "\n");
                    break;
                }
                this.m_sLog.append(unit.getLog().toString());
                this.m_sLog.append("OK!\n");
            }
            catch (InterruptedException e) {
                this.m_sLog.append(unit.getLog().toString());
            }
            catch (ExecutionException e) {
                this.m_sLog.append(unit.getLog().toString());
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            this.m_sLog.append("----------------------------------------\n\n");
            SextanteGUI.getInputFactory().clearDataObjects();
            SextanteGUI.getInputFactory().createDataObjects();
        }
        if ((table = this.createNumericalOutputsTable()) != null) {
            AdditionalResults.addComponent(new ObjectAndDescription(this.m_Algorithm.getName() + "[" + Sextante.getText((String)"Batch_processing") + "]", (Object)table));
        }
        this.m_ProgressMonitor.close();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(this.m_sLog.toString());
        jTextArea.setFont(new Font("Courier", 0, 11));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(600, 400));
        scrollPane.setViewportView(jTextArea);
        scrollPane.setHorizontalScrollBarPolicy(32);
        jTextArea.setBorder(BorderFactory.createEtchedBorder(1));
        SextanteGUI.getGUIFactory().showGenericInfoDialog(scrollPane, Sextante.getText((String)"Batch_processing"));
    }

    private JScrollPane createNumericalOutputsTable() {
        if (this.m_NumericalOutputs.size() == 0) {
            return null;
        }
        JScrollPane jScrollPane = new JScrollPane();
        JTable jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        int iRecordsCount = this.m_NumericalOutputs.size();
        int iFieldsCount = this.m_NumericalOutputs.get(0).size();
        Object[] fields = new String[iFieldsCount];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.m_NumericalOutputs.get(0).get(i).getDescription();
        }
        Object[][] data2 = new String[iRecordsCount][fields.length];
        for (int i = 0; i < iRecordsCount; ++i) {
            for (int j = 0; j < iFieldsCount; ++j) {
                data2[i][j] = this.m_NumericalOutputs.get(i).get(j).getOutputObject().toString();
            }
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setDataVector(data2, fields);
        jTable.setModel(model);
        jTable.setEnabled(false);
        return jScrollPane;
    }
}

