/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterSelection;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ParameterCellPanelRenderer
extends DefaultTableCellRenderer {
    private final Object m_Object;
    private Object m_Value;

    public ParameterCellPanelRenderer(Object obj) {
        this.m_Object = obj;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, colIndex);
        this.m_Value = table.getModel().getValueAt(rowIndex, colIndex);
        this.setText(this.m_Value.toString());
        if (this.isValueOK()) {
            this.setForeground(Color.BLACK);
        } else {
            this.setForeground(Color.RED);
        }
        return this;
    }

    public boolean isValueOK() {
        if (this.m_Object instanceof ParameterPoint) {
            return this.isPointOK();
        }
        if (this.m_Object instanceof ParameterDataObject) {
            return true;
        }
        if (this.m_Object instanceof ParameterFixedTable) {
            return this.isFixedTableOK();
        }
        if (this.m_Object instanceof ParameterSelection) {
            return this.isSelectionOK();
        }
        if (this.m_Object instanceof ParameterNumericalValue) {
            return this.isNumericalValueOK();
        }
        if (this.m_Object instanceof ParameterMultipleInput) {
            return this.isMultipleInputOK();
        }
        if (this.m_Object instanceof Output) {
            return this.isOutputOK();
        }
        return true;
    }

    private boolean isOutputOK() {
        return !((String)this.m_Value).trim().equals("");
    }

    private boolean isMultipleInputOK() {
        AdditionalInfoMultipleInput ai;
        try {
            ai = (AdditionalInfoMultipleInput)((ParameterMultipleInput)this.m_Object).getParameterAdditionalInfo();
        }
        catch (NullParameterAdditionalInfoException e) {
            return false;
        }
        if (this.m_Value instanceof ArrayList) {
            ArrayList list = (ArrayList)this.m_Value;
            int iCount = list.size();
            return !ai.getIsMandatory() || iCount > 0;
        }
        return !ai.getIsMandatory();
    }

    private boolean isFixedTableOK() {
        StringTokenizer st = new StringTokenizer((String)this.m_Value, ",");
        ParameterFixedTable parameter = (ParameterFixedTable)this.m_Object;
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iRows = ai.getRowsCount();
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            if (bIsNumberOfRowsFixed ? st.countTokens() != iCols * iRows : st.countTokens() % iCols != 0) {
                return false;
            }
            while (st.hasMoreTokens()) {
                Double.parseDouble(st.nextToken().trim());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSelectionOK() {
        try {
            String[] sValues;
            ParameterSelection parameter = (ParameterSelection)this.m_Object;
            AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
            for (String element : sValues = ai.getValues()) {
                if (!((String)this.m_Value).equals(element)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isNumericalValueOK() {
        try {
            ParameterNumericalValue parameter = (ParameterNumericalValue)this.m_Object;
            AdditionalInfoNumericalValue ai = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
            double dMin = ai.getMinValue();
            double dMax = ai.getMaxValue();
            double dVal = Double.parseDouble((String)this.m_Value);
            return !(dVal < dMin) && !(dMax < dVal);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isPointOK() {
        String[] s = ((String)this.m_Value).split(",");
        if (s.length != 2) {
            return false;
        }
        try {
            Double.parseDouble(s[0]);
            Double.parseDouble(s[1]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

