/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.batch.nonFileBased.ParameterCellPanelEditor;
import es.unex.sextante.gui.batch.nonFileBased.ParameterCellPanelRenderer;
import es.unex.sextante.gui.batch.nonFileBased.ParametersTableModel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ParametersPanel
extends JPanel {
    private final GeoAlgorithm m_Algorithm;
    private JPanel jPanelAddRemoveRows;
    private JScrollPane jScrollPane;
    private JButton jButtonRemoveRow;
    private JButton jButtonAddRow;
    private JTable jTable;
    private ParametersTableModel m_TableModel;
    private JPopupMenu popupMenu;
    private JMenuItem menuItemCopy;
    private String[][] m_sClipboard;
    private JMenuItem menuItemPaste;

    public ParametersPanel(GeoAlgorithm alg) {
        this.m_Algorithm = alg;
        this.defineTableModel();
        this.initGUI();
    }

    private void defineTableModel() {
        this.m_TableModel = new ParametersTableModel(this.m_Algorithm.getParameters(), this.m_Algorithm.getOutputObjects());
    }

    private void initGUI() {
        ParametersSet ps = this.m_Algorithm.getParameters();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0, 120.0, 5.0}, {5.0, -1.0, -1.0, 5.0, 25.0, 5.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.setPreferredSize(new Dimension(580, 350));
        this.setSize(new Dimension(580, 350));
        this.jScrollPane = new JScrollPane();
        this.add((Component)this.jScrollPane, "1,1,1,2");
        this.jScrollPane.setMinimumSize(new Dimension(432, 256));
        this.jTable = new JTable();
        this.jScrollPane.setViewportView(this.jTable);
        this.initTable();
        int iDataObjectOutputs = 0;
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output out = ooset.getOutput(i);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof Output3DRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
            TableColumn col = this.jTable.getColumnModel().getColumn(iDataObjectOutputs + ps.getNumberOfParameters());
            col.setCellEditor(new ParameterCellPanelEditor(out, this.jTable));
            col.setCellRenderer(new ParameterCellPanelRenderer(out));
            this.jTable.getColumnModel().getColumn(iDataObjectOutputs + ps.getNumberOfParameters()).setPreferredWidth(200);
            ++iDataObjectOutputs;
        }
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ParametersPanel.this.showPopupMenu(e);
                }
            }
        };
        this.jTable.addMouseListener(ml);
        this.popupMenu = new JPopupMenu("Menu");
        this.menuItemCopy = new JMenuItem(Sextante.getText((String)"Copy"));
        this.menuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.copyCells();
            }
        });
        this.popupMenu.add(this.menuItemCopy);
        this.menuItemPaste = new JMenuItem(Sextante.getText((String)"Paste"));
        this.menuItemPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.pasteCells();
            }
        });
        this.popupMenu.add(this.menuItemPaste);
        this.jPanelAddRemoveRows = new JPanel();
        TableLayout jPanelAddRemoveRowsLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0}, {5.0, 25.0, 30.0, -1.0}});
        jPanelAddRemoveRowsLayout.setHGap(5);
        jPanelAddRemoveRowsLayout.setVGap(5);
        this.jPanelAddRemoveRows.setLayout((LayoutManager)jPanelAddRemoveRowsLayout);
        this.add((Component)this.jPanelAddRemoveRows, "3,1,4,1");
        this.jButtonRemoveRow = new JButton();
        this.jPanelAddRemoveRows.add((Component)this.jButtonRemoveRow, "1, 2");
        this.jButtonRemoveRow.setText(Sextante.getText((String)"Delete_row"));
        this.jButtonRemoveRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.btnRemoveRowActionPerformed(evt);
            }
        });
        this.jButtonAddRow = new JButton();
        this.jPanelAddRemoveRows.add((Component)this.jButtonAddRow, "1,  1");
        this.jButtonAddRow.setText(Sextante.getText((String)"Add_row"));
        this.jButtonAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.btnAddRowActionPerformed(evt);
            }
        });
    }

    protected void showPopupMenu(MouseEvent e) {
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void copyCells() {
        int[] cols = this.jTable.getSelectedColumns();
        int[] rows = this.jTable.getSelectedRows();
        this.m_sClipboard = new String[rows.length][cols.length];
        for (int j = 0; j < rows.length; ++j) {
            for (int i = 0; i < cols.length; ++i) {
                this.m_sClipboard[j][i] = (String)this.jTable.getValueAt(rows[j], cols[i]);
            }
        }
    }

    protected void pasteCells() {
        int[] rows;
        if (this.m_sClipboard == null) {
            return;
        }
        int[] cols = this.jTable.getSelectedColumns();
        for (int element : rows = this.jTable.getSelectedRows()) {
            for (int element2 : cols) {
                int iRow = (element - rows[0]) % this.m_sClipboard.length;
                int iCol = (element2 - cols[0]) % this.m_sClipboard[0].length;
                this.jTable.setValueAt(this.m_sClipboard[iRow][iCol], element, element2);
            }
        }
    }

    private void btnAddRowActionPerformed(ActionEvent evt) {
        this.m_TableModel.addRow();
    }

    private void btnRemoveRowActionPerformed(ActionEvent evt) {
        int iRow = this.jTable.getSelectedRow();
        if (iRow != -1) {
            this.m_TableModel.removeRow(iRow);
        }
    }

    public boolean assignParameters(ArrayList param, ArrayList output) {
        ParametersSet ps = this.m_Algorithm.getParameters();
        OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
        for (int i = 0; i < this.m_TableModel.getRowCount(); ++i) {
            int j;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (j = 0; j < ps.getNumberOfParameters(); ++j) {
                ParameterCellPanelRenderer rend = (ParameterCellPanelRenderer)this.jTable.getCellRenderer(i, j);
                if (!rend.isValueOK()) {
                    return false;
                }
                paramMap.put(ps.getParameter(j).getParameterName(), this.m_TableModel.getValueAt(i, j));
            }
            HashMap<String, String> outputMap = new HashMap<String, String>();
            for (j = 0; j < ooSet.getOutputDataObjectsCount(); ++j) {
                Output out = ooSet.getOutput(j);
                if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
                String sOut = this.m_TableModel.getValueAt(i, j + ps.getNumberOfParameters()).toString();
                if (sOut.equals(Sextante.getText((String)"[Save_to_temporary_file]"))) {
                    outputMap.put(out.getName(), null);
                    continue;
                }
                outputMap.put(out.getName(), sOut);
            }
            param.add(paramMap);
            output.add(outputMap);
        }
        return true;
    }

    public ParametersTableModel getTableModel() {
        return this.m_TableModel;
    }

    public void setTableModel(ParametersTableModel table) {
        this.m_TableModel = table;
        this.initTable();
        this.updateUI();
    }

    private void initTable() {
        ParametersSet ps = this.m_Algorithm.getParameters();
        this.jTable.setModel(this.m_TableModel);
        this.jTable.setAutoResizeMode(0);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.setColumnSelectionAllowed(true);
        this.jTable.setRowSelectionAllowed(true);
        for (int i = 0; i < ps.getNumberOfParameters(); ++i) {
            Parameter param = ps.getParameter(i);
            TableColumn col = this.jTable.getColumnModel().getColumn(i);
            col.setCellEditor(new ParameterCellPanelEditor(param, this.jTable));
            col.setCellRenderer(new ParameterCellPanelRenderer(param));
            this.jTable.getColumnModel().getColumn(i).setPreferredWidth(200);
        }
    }
}

