/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.cmd;

import bsh.EvalError;
import bsh.Interpreter;
import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoTable;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.WrongScriptException;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

public class ScriptAlgorithm
extends GeoAlgorithm {
    private static Interpreter m_Interpreter;
    private String m_sDescriptionFile;

    public void initialize(String sDescriptionFile) throws WrongScriptException {
        String sFolder = SextanteGUI.getSettingParameterValue("ScriptsFolder");
        this.m_sDescriptionFile = sFolder + File.separator + sDescriptionFile;
        this.setName(sDescriptionFile.substring(0, sDescriptionFile.indexOf(".")));
        this.setGroup("Scripts");
        this.setIsDeterminatedProcess(false);
        this.setUserCanDefineAnalysisExtent(true);
        this.defineCharacteristicsFromDescriptionFile();
        try {
            FileReader reader = new FileReader(this.m_sDescriptionFile);
            m_Interpreter.eval((Reader)reader);
        }
        catch (Exception e) {
            throw new WrongScriptException(e.getMessage());
        }
    }

    private void defineCharacteristicsFromDescriptionFile() throws WrongScriptException {
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.m_sDescriptionFile));
            String sLine = input.readLine().trim();
            while (sLine != null) {
                if (sLine.startsWith("//")) {
                    this.processParameterLine(sLine);
                }
                sLine = input.readLine();
            }
            input.close();
        }
        catch (Exception e) {
            throw new WrongScriptException(e.getMessage());
        }
    }

    private void processParameterLine(String sLine) throws WrongScriptException {
        ParameterRasterLayer param = null;
        OutputRasterLayer out = null;
        AdditionalInfoRasterLayer additionalInfo = null;
        String[] sTokens = (sLine = sLine.replace("/", "")).split("=");
        if (sTokens[1].toLowerCase().equals("raster")) {
            param = new ParameterRasterLayer();
            additionalInfo = new AdditionalInfoRasterLayer(true);
        } else if (sTokens[1].toLowerCase().equals("vector")) {
            param = new ParameterVectorLayer();
            additionalInfo = new AdditionalInfoVectorLayer(-1, true);
        } else if (sTokens[1].toLowerCase().equals("table")) {
            param = new ParameterTable();
            additionalInfo = new AdditionalInfoTable(true);
        } else if (sTokens[1].toLowerCase().equals("multiple raster")) {
            param = new ParameterMultipleInput();
            additionalInfo = new AdditionalInfoMultipleInput(1, true);
        } else if (sTokens[1].toLowerCase().equals("multiple vector")) {
            param = new ParameterMultipleInput();
            additionalInfo = new AdditionalInfoMultipleInput(5, true);
        } else if (sTokens[1].toLowerCase().equals("boolean")) {
            param = new ParameterBoolean();
            additionalInfo = new AdditionalInfoBoolean(true);
        } else if (sTokens[1].toLowerCase().equals("number")) {
            param = new ParameterNumericalValue();
            additionalInfo = new AdditionalInfoNumericalValue(2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        } else if (sTokens[1].toLowerCase().equals("string")) {
            param = new ParameterString();
            additionalInfo = new AdditionalInfoString();
        } else if (sTokens[1].toLowerCase().equals("output raster")) {
            out = new OutputRasterLayer();
        } else if (sTokens[1].toLowerCase().equals("output vector")) {
            out = new OutputVectorLayer();
        } else if (sTokens[1].toLowerCase().equals("output table")) {
            out = new OutputTable();
        }
        if (param != null) {
            param.setParameterName(sTokens[0]);
            param.setParameterDescription(sTokens[0]);
            param.setParameterAdditionalInfo((AdditionalInfo)additionalInfo);
            try {
                this.m_Parameters.addParameter((Parameter)param);
            }
            catch (RepeatedParameterNameException e) {
                throw new WrongScriptException(e.getMessage());
            }
        } else if (out != null) {
            out.setDescription(sTokens[0]);
            out.setName(sTokens[0]);
            this.m_OutputObjects.add(out);
        } else {
            throw new WrongScriptException();
        }
    }

    public void defineCharacteristics() {
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        StringBuffer sb = new StringBuffer(this.getName() + "(");
        for (int i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            Parameter param = this.m_Parameters.getParameter(i);
            sb.append(param.getCommandLineParameter() + ", ");
        }
        for (int j = 0; j < this.m_OutputObjects.getOutputObjectsCount(); ++j) {
            Output out = this.m_OutputObjects.getOutput(j);
            sb.append(out.getCommandLineParameter() + ", ");
        }
        String sCommand = sb.substring(0, sb.length() - 2) + ")";
        try {
            m_Interpreter.eval(sCommand);
        }
        catch (EvalError e) {
            e.printStackTrace();
            throw new GeoAlgorithmExecutionException(e.getErrorText());
        }
        return false;
    }

    public String getCommandLineName() {
        return this.getName();
    }

    public static void resetInterpreter() {
        m_Interpreter = new Interpreter();
        m_Interpreter.getNameSpace().importCommands("es.unex.sextante.gui.cmd.bshcommands");
    }

    public String getDescriptionFile() {
        return this.m_sDescriptionFile;
    }

    public String getFilename() {
        return this.m_sDescriptionFile;
    }
}

