/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.cmd;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.cmd.CreateScriptToolboxAction;
import es.unex.sextante.gui.cmd.DeleteScriptAction;
import es.unex.sextante.gui.cmd.EditScriptAction;
import es.unex.sextante.gui.cmd.OpenCommandLineInterfaceAction;
import es.unex.sextante.gui.cmd.ScriptAlgorithm;
import es.unex.sextante.gui.cmd.ScriptsIO;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.gui.settings.SextanteScriptsSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class ScriptAlgorithmProvider
implements IAlgorithmProvider {
    private HashMap<String, GeoAlgorithm> m_Algs;
    private static final ImageIcon SCRIPT_ICON = new ImageIcon(ScriptAlgorithmProvider.class.getClassLoader().getResource("images/terminal.png"));

    @Override
    public HashMap<String, GeoAlgorithm> getAlgorithms() {
        return this.m_Algs;
    }

    @Override
    public HashMap<String, Class> getCustomModelerParameterPanels() {
        return new HashMap<String, Class>();
    }

    @Override
    public HashMap<String, Class> getCustomParameterPanels() {
        return new HashMap<String, Class>();
    }

    @Override
    public ImageIcon getIcon() {
        return SCRIPT_ICON;
    }

    @Override
    public String getName() {
        return Sextante.getText((String)"Scripts");
    }

    @Override
    public void initialize() {
        this.m_Algs = new HashMap();
        String sFolder = SextanteGUI.getSettingParameterValue("ScriptsFolder");
        ScriptAlgorithm.resetInterpreter();
        GeoAlgorithm[] algs2 = ScriptsIO.loadScriptsAsAlgorithms(sFolder);
        for (int i = 0; i < algs2.length; ++i) {
            this.m_Algs.put(algs2[i].getCommandLineName(), algs2[i]);
        }
    }

    @Override
    public Setting getSettings() {
        return new SextanteScriptsSettings();
    }

    @Override
    public void update() {
        this.initialize();
    }

    @Override
    public String getAlgorithmHelp(GeoAlgorithm alg) {
        String sScriptFilename = ((ScriptAlgorithm)alg).getFilename();
        String sFilename = sScriptFilename.substring(sScriptFilename.lastIndexOf(File.separator));
        sFilename = sFilename + ".xml";
        String sPath = SextanteGUI.getSettingParameterValue("ScriptsFolder");
        String sFullPath = sPath + File.separator + sFilename;
        return HelpIO.getHelpAsHTMLCode(alg, sFullPath);
    }

    @Override
    public String getAlgorithmHelpFilename(GeoAlgorithm alg, boolean bForceCurrentLocale) {
        String sScriptFilename = ((ScriptAlgorithm)alg).getFilename();
        String sFilename = sScriptFilename.substring(sScriptFilename.lastIndexOf(File.separator));
        sFilename = sFilename + ".xml";
        String sPath = SextanteGUI.getSettingParameterValue("ScriptsFolder");
        String sFullPath = sPath + File.separator + sFilename;
        return sFullPath;
    }

    @Override
    public boolean canEditHelp() {
        return true;
    }

    @Override
    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        HashMap<NameAndIcon, ArrayList<ToolboxAction>> map = new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
        NameAndIcon nai = new NameAndIcon(Sextante.getText((String)"Scripts"), SCRIPT_ICON);
        ArrayList<ToolboxAction> list = new ArrayList<ToolboxAction>();
        list.add(new CreateScriptToolboxAction());
        list.add(new OpenCommandLineInterfaceAction());
        map.put(nai, list);
        return map;
    }

    @Override
    public IToolboxRightButtonAction[] getToolboxRightButtonActions() {
        return new IToolboxRightButtonAction[]{new EditScriptAction(), new DeleteScriptAction()};
    }
}

