/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.cmd.bshcommands;

import bsh.CallStack;
import bsh.Interpreter;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.core.SextanteGUI;

public class describe {
    public static void invoke(Interpreter env, CallStack callstack, String sName) {
        SextanteGUI.getInputFactory().createDataObjects();
        IDataObject obj = SextanteGUI.getInputFactory().getInputFromName(sName.trim());
        if (obj == null) {
            env.println((Object)("Invalid object: " + sName.trim()));
        }
        if (obj instanceof ITable) {
            env.println((Object)describe.describeTable((ITable)obj));
        } else if (obj instanceof IRasterLayer) {
            env.println((Object)describe.describeRasterLayer((IRasterLayer)obj));
        } else if (obj instanceof IVectorLayer) {
            env.println((Object)describe.describeVectorLayer((IVectorLayer)obj));
        }
    }

    private static String describeTable(ITable table) {
        StringBuffer sb = new StringBuffer();
        String[] sFields = table.getFieldNames();
        sb.append("Type: Table\n");
        sb.append("Number of records: " + Long.toString(table.getRecordCount()) + "\n");
        sb.append("Table fields: | ");
        for (int i = 0; i < sFields.length; ++i) {
            sb.append(sFields[i] + " | ");
        }
        return sb.toString();
    }

    private static String describeVectorLayer(IVectorLayer vect) {
        StringBuffer sb = new StringBuffer();
        sb.append("Type: Vector layer - ");
        switch (vect.getShapeType()) {
            case 1: {
                sb.append("Line\n");
                break;
            }
            case 2: {
                sb.append("Polygon\n");
                break;
            }
            case 0: {
                sb.append("Point\n");
            }
        }
        sb.append("Number of entities: " + Integer.toString(vect.getShapesCount()) + "\n");
        sb.append("Table fields: | ");
        String[] sFields = vect.getFieldNames();
        for (int i = 0; i < sFields.length; ++i) {
            sb.append(sFields[i] + " | ");
        }
        return sb.toString();
    }

    private static String describeRasterLayer(IRasterLayer raster) {
        StringBuffer sb = new StringBuffer();
        AnalysisExtent extent2 = raster.getLayerGridExtent();
        sb.append("Type: Raster layer \n");
        sb.append("X min: " + Double.toString(extent2.getXMin()) + "\n");
        sb.append("X max: " + Double.toString(extent2.getXMax()) + "\n");
        sb.append("Y min: " + Double.toString(extent2.getYMin()) + "\n");
        sb.append("Y max: " + Double.toString(extent2.getYMax()) + "\n");
        sb.append("Cellsize X: " + Double.toString(extent2.getCellSize()) + "\n");
        sb.append("Rows: " + Integer.toString(extent2.getNY()) + "\n");
        sb.append("Cols: " + Integer.toString(extent2.getNX()));
        return sb.toString();
    }
}

