/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.gui.core.SextanteGUI;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GUIResources {
    private static ArrayList<Class> m_ParameterPanelClasses = new ArrayList();
    private static ArrayList<Class> m_ModelerParameterPanelClasses = new ArrayList();

    public static void addResourcesFromClasspath() {
        StringTokenizer localTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator, false);
        while (localTokenizer.hasMoreTokens()) {
            String classpathElement = localTokenizer.nextToken();
            File classpathFile = new File(classpathElement);
            String sFilename = classpathFile.getName();
            if (!classpathFile.exists() || !classpathFile.canRead() || !sFilename.toLowerCase().endsWith(".jar") || !sFilename.toLowerCase().startsWith(SextanteGUI.resourcePrefix)) continue;
            GUIResources.addResourcesFromJarFile(classpathElement);
        }
        ClassLoader classloader = GUIResources.class.getClassLoader();
        URL[] webappClasses = new URL[]{};
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            webappClasses = urlClassLoader.getURLs();
        }
        GUIResources.addResourcesFromURLs(webappClasses);
    }

    public static void addResourcesFromURLs(URL[] urls) {
        for (URL url : urls) {
            File classpathFile = new File(URLDecoder.decode(url.getFile()));
            String sFilename = classpathFile.getName();
            if (!classpathFile.exists() || !classpathFile.canRead() || !sFilename.toLowerCase().endsWith(".jar") || !sFilename.toLowerCase().startsWith(SextanteGUI.resourcePrefix)) continue;
            GUIResources.addResourcesFromJarFile(classpathFile.getAbsolutePath());
        }
    }

    public static void addResourcesFromFolder(String sFolder) {
        File folder = new File(sFolder);
        File[] directoryFiles = folder.listFiles();
        for (int i = 0; i < directoryFiles.length; ++i) {
            String sFilename;
            if (directoryFiles[i].isDirectory() || !(sFilename = directoryFiles[i].getName()).endsWith(".jar") || !sFilename.startsWith(SextanteGUI.resourcePrefix)) continue;
            GUIResources.addResourcesFromJarFile(directoryFiles[i].getAbsolutePath());
        }
    }

    private static void addResourcesFromJarFile(String sFilename) {
        try {
            File file = new File(sFilename);
            ZipFile zip = new ZipFile(sFilename);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                Class loadedClassFromFile;
                String sClassName;
                ZipEntry entry = entries.nextElement();
                String sName = entry.getName();
                if (entry.isDirectory()) continue;
                if (sName.toLowerCase().endsWith("modelerparameterspanel.class")) {
                    sClassName = sName.substring(0, sName.lastIndexOf(46)).replace('/', '.');
                    loadedClassFromFile = GUIResources.loadClassFromFile(file, sClassName);
                    if (loadedClassFromFile == null) continue;
                    m_ModelerParameterPanelClasses.add(loadedClassFromFile);
                    continue;
                }
                if (!sName.toLowerCase().endsWith("parameterspanel.class") || (loadedClassFromFile = GUIResources.loadClassFromFile(file, sClassName = sName.substring(0, sName.lastIndexOf(46)).replace('/', '.'))) == null) continue;
                m_ParameterPanelClasses.add(loadedClassFromFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Class loadClassFromFile(File jar, String className) {
        Class<?> cls = null;
        try {
            URL url = jar.toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cl = new URLClassLoader(urls, GUIResources.class.getClassLoader());
            cls = cl.loadClass(className);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cls;
    }

    public static String[] getParameterPanelClassNames() {
        String[] names = new String[m_ParameterPanelClasses.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = m_ParameterPanelClasses.get(i).getName();
        }
        return names;
    }

    public static Class[] getParameterPanelClasses() {
        return m_ParameterPanelClasses.toArray(new Class[0]);
    }

    public static String[] getModelerParameterPanelClassNames() {
        String[] names = new String[m_ModelerParameterPanelClasses.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = m_ModelerParameterPanelClasses.get(i).getName();
        }
        return names;
    }

    public static Class[] getModelerParameterPanelClasses() {
        return m_ModelerParameterPanelClasses.toArray(new Class[0]);
    }
}

