/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.grass.GrassUtils;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressMonitor
extends JDialog {
    private JLabel jTitle;
    private JButton jButtonCancel;
    private JProgressBar jProgressBar;
    private JLabel jProgressText;
    private boolean m_bCanceled;
    private String m_sPrefix = "";
    private String m_sDescription = "";

    public ProgressMonitor(String sText, boolean bDeterminate, JDialog parent) {
        super(parent, "", false);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.m_bCanceled = false;
        this.m_sDescription = sText;
        this.initGUI(bDeterminate);
    }

    public ProgressMonitor(String sText, boolean bDeterminate) {
        super(SextanteGUI.getMainFrame(), "", false);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.m_bCanceled = false;
        this.m_sDescription = sText;
        this.initGUI(bDeterminate);
    }

    private void initGUI(boolean bDeterminate) {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{6.0, -1.0, -1.0, 6.0}, {1.0, -1.0, -1.0, 1.0, 15.0, 1.0, 25.0, 1.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setPreferredSize(new Dimension(350, 150));
        this.setSize(new Dimension(350, 150));
        this.getContentPane().setLayout((LayoutManager)thisLayout);
        this.jTitle = new JLabel(this.m_sDescription);
        this.getContentPane().add((Component)this.jTitle, "1, 1, 2, 1");
        this.jButtonCancel = new JButton();
        this.getContentPane().add((Component)this.jButtonCancel, "2, 6");
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressMonitor.this.cancel();
            }
        });
        this.jProgressBar = new JProgressBar();
        this.jProgressBar.setIndeterminate(!bDeterminate);
        if (bDeterminate) {
            this.jProgressBar.setMinimum(0);
            this.jProgressBar.setMaximum(100);
            this.jProgressBar.setValue(0);
        }
        this.getContentPane().add((Component)this.jProgressBar, "1, 4, 2, 4");
        this.jProgressText = new JLabel();
        this.getContentPane().add((Component)this.jProgressText, "1, 2");
    }

    private void cancel() {
        GrassUtils.cancelProcess();
        this.m_bCanceled = true;
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void setProgressText(final String sText) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor.this.jProgressText.setText(sText);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDescription(String sDescription) {
        this.m_sDescription = sDescription;
        this.updateTitle();
    }

    private void updateTitle() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor.this.jTitle.setText(ProgressMonitor.this.m_sPrefix + ProgressMonitor.this.m_sDescription);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProgress(final int iValue) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor.this.jProgressBar.setValue(iValue);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDeterminate(final boolean bDeterminate) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor.this.jProgressBar.setIndeterminate(!bDeterminate);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDescriptionPrefix(String sPrefix) {
        this.m_sPrefix = sPrefix;
        this.updateTitle();
    }
}

