/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.IInputFactory;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.cmd.ScriptAlgorithmProvider;
import es.unex.sextante.gui.core.DefaultGUIFactory;
import es.unex.sextante.gui.core.GUIResources;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IDataRenderer;
import es.unex.sextante.gui.core.IGUIFactory;
import es.unex.sextante.gui.core.IPostProcessTaskFactory;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.modeler.ModelerAlgorithmProvider;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.gui.settings.SextanteGeneralSettings;
import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class SextanteGUI {
    public static String resourcePrefix = "org.gvsig.toolbox";
    public static final int HISTORY = 0;
    public static final int COMMANDLINE = 1;
    private static IInputFactory m_InputFactory;
    private static OutputFactory m_OutputFactory;
    private static IGUIFactory m_GUIFactory;
    private static IPostProcessTaskFactory m_PostProcessTaskFactory;
    private static JDialog m_LastCommandOriginParentPanel;
    private static int m_iLastCommandOrigin;
    private static Frame m_MainFrame;
    private static boolean m_bShowOnlyActiveAlgorithms;
    private static String m_sOutputFolder;
    private static HashMap<String, String> m_Settings;
    private static HashMap<String, String> m_DefaultSettings;
    private static IDataRenderer m_Renderer;
    private static String m_sSextanteHomePath;
    private static String m_sSextanteInstallPath;
    private static ArrayList<String> foldersWithResources;
    private static boolean initialized;
    private static final HashMap<String, Class> m_ParametersPanel;
    private static final HashMap<String, Class> m_ModelerParametersPanel;
    private static final ArrayList<IAlgorithmProvider> m_AlgorithmProviders;
    public static final ImageIcon SEXTANTE_ICON;
    public static final Color COLOR_WHITE;
    public static final Color COLOR_GREY;
    public static final Color COLOR_BLACK;
    public static final Color COLOR_RED;
    public static final Color COLOR_ORANGE;
    public static final Color COLOR_YELLOW;
    public static final Color COLOR_GREEN_LIGHT;
    public static final Color COLOR_GREEN_DARK;
    public static final Color COLOR_BLUE_LIGHT;
    public static final Color COLOR_BLUE_DARK;
    public static final Color COLOR_PINK;
    public static final Color COLOR_PURPLE;
    public static final Color COLOR_BROWN_LIGHT;
    public static final Color COLOR_BROWN_DARK;

    public static void setMainFrame(Frame frame) {
        m_MainFrame = frame;
    }

    public static Frame getMainFrame() {
        return m_MainFrame;
    }

    public static IInputFactory getInputFactory() {
        return m_InputFactory;
    }

    public static void setInputFactory(IInputFactory inputFactory) {
        m_InputFactory = inputFactory;
    }

    public static OutputFactory getOutputFactory() {
        return m_OutputFactory;
    }

    public static void setOutputFactory(OutputFactory outputFactory) {
        m_OutputFactory = outputFactory;
        m_OutputFactory.setDefaultNoDataValue(SextanteGUI.getDefaultNoDataValue().doubleValue());
    }

    public static IGUIFactory getGUIFactory() {
        return m_GUIFactory;
    }

    public static void setGUIFactory(IGUIFactory guiFactory) {
        m_GUIFactory = guiFactory;
    }

    public static Runnable getPostProcessTask(GeoAlgorithm alg, boolean bShowResultsDialog) {
        return m_PostProcessTaskFactory.getPostProcessTask(alg, bShowResultsDialog);
    }

    public static void setPostProcessTaskFactory(IPostProcessTaskFactory factory) {
        m_PostProcessTaskFactory = factory;
    }

    public static void addAlgorithmProvider(IAlgorithmProvider provider) {
        m_AlgorithmProviders.add(0, provider);
    }

    public static int checkDir(String dir, boolean read_only, String provider) {
        File f = new File(SextanteGUI.getSextanteHomePath() + File.separator + dir);
        if (f.exists()) {
            if (f.isFile()) {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_dir_error") + " " + f.getAbsolutePath() + ".\n" + Sextante.getText((String)"portable_dir_is_file") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
                return 3;
            }
            if (read_only && f.canRead()) {
                return 0;
            }
            if (f.canWrite()) {
                return 0;
            }
            if (read_only) {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_dir_error") + " " + f.getAbsolutePath() + Sextante.getText((String)"portable_dir_error_ro") + "\n" + ":" + Sextante.getText((String)"portable_dir_no_access") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
            } else {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_dir_error") + " " + f.getAbsolutePath() + Sextante.getText((String)"portable_dir_error_rw") + "\n" + ":" + Sextante.getText((String)"portable_dir_no_access") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
            }
            return 2;
        }
        if (!f.mkdir()) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_dir_error") + " " + f.getAbsolutePath() + ".\n" + Sextante.getText((String)"portable_dir_no_create") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
            return 1;
        }
        return 0;
    }

    public static int checkFile(String file, boolean read_only, String provider) {
        File f = new File(SextanteGUI.getSextanteHomePath() + File.separator + file);
        if (f.exists()) {
            if (f.isDirectory()) {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_file_error") + " " + f.getAbsolutePath() + ".\n" + Sextante.getText((String)"portable_file_is_dir") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
                return 3;
            }
            if (read_only && f.canRead()) {
                return 0;
            }
            if (f.canWrite()) {
                return 0;
            }
            if (read_only) {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_file_error") + " " + f.getAbsolutePath() + Sextante.getText((String)"portable_file_error_ro") + "\n" + ":" + Sextante.getText((String)"portable_file_no_access") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
            } else {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"portable_file_error") + " " + f.getAbsolutePath() + Sextante.getText((String)"portable_file_error_rw") + "\n" + ":" + Sextante.getText((String)"portable_file_no_access") + "\n" + Sextante.getText((String)"portable_provider_not_usable") + " <html></i>" + provider + "+</i>+</html>.", "Inane warning", 2);
            }
            return 2;
        }
        return 1;
    }

    public static void checkPortableFolders() {
        int result;
        String sPath = new String("");
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("RPortable"))) {
            result = SextanteGUI.checkDir(Sextante.PORTABLE_R_FOLDER, true, "R");
            sPath = SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_R_FOLDER;
            SextanteGUI.setSettingParameterValue("RFolder", sPath);
            result = SextanteGUI.checkDir(Sextante.PORTABLE_R_SCRIPTS_FOLDER, false, "R user scripts");
            sPath = SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_R_SCRIPTS_FOLDER;
            SextanteGUI.setSettingParameterValue("RScriptsFolder", sPath);
        }
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("GrassPortable"))) {
            result = SextanteGUI.checkDir(Sextante.PORTABLE_GRASS_FOLDER, true, "GRASS GIS");
            sPath = SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_GRASS_FOLDER;
            SextanteGUI.setSettingParameterValue("GrassBinariesFolder", sPath);
            if (Sextante.isWindows()) {
                result = SextanteGUI.checkFile(Sextante.PORTABLE_MSYS_FILE, true, "GRASS GIS shell scripts");
                sPath = SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_MSYS_FILE;
                SextanteGUI.setSettingParameterValue("GrassWinShell", sPath);
            }
        }
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("SagaPortable"))) {
            result = SextanteGUI.checkDir(Sextante.PORTABLE_SAGA_FOLDER, true, "SAGA GIS");
            sPath = SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_SAGA_FOLDER;
            SextanteGUI.setSettingParameterValue("SagaFolder", sPath);
        }
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("ScriptsPortable"))) {
            result = SextanteGUI.checkDir(Sextante.PORTABLE_SCRIPTS_FOLDER, true, "Toolbox user scripts");
            sPath = SextanteGUI.getSextanteHomePath() + File.separator + Sextante.PORTABLE_SCRIPTS_FOLDER;
            SextanteGUI.setSettingParameterValue("ScriptsFolder", sPath);
        }
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("ModelsPortable"))) {
            result = SextanteGUI.checkDir(Sextante.PORTABLE_MODELS_FOLDER, true, "Toolbox user models");
            sPath = SextanteGUI.getSextanteHomePath() + File.separator + Sextante.PORTABLE_MODELS_FOLDER;
            SextanteGUI.setSettingParameterValue("ModelsFolder", sPath);
        }
    }

    public static void initialize() {
        GUIResources.addResourcesFromClasspath();
        SextanteGUI._initialize();
    }

    public static void initialize(URL[] jars) {
        GUIResources.addResourcesFromURLs(jars);
        SextanteGUI._initialize();
    }

    public static void initialize(String sFolder) {
        GUIResources.addResourcesFromFolder(sFolder);
        SextanteGUI._initialize();
    }

    public static void addResourcesFromFolder(String sFolder) {
        if (initialized) {
            GUIResources.addResourcesFromFolder(sFolder);
            SextanteGUI.loadResources();
        } else {
            foldersWithResources.add(sFolder);
        }
    }

    private static void _initialize() {
        SextanteGUI.setDefaultSettings();
        SextanteGUI.readConfigFile();
        SextanteGUI.checkPortableFolders();
        for (String sFolder : foldersWithResources) {
            GUIResources.addResourcesFromFolder(sFolder);
        }
        SextanteGUI.loadResources();
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            IAlgorithmProvider provider = m_AlgorithmProviders.get(i);
            provider.initialize();
            if (provider.getAlgorithms().size() <= 0) continue;
            Sextante.addAlgorithmsFromProvider((String)provider.getName(), provider.getAlgorithms());
            SextanteGUI.addCustomModelerParametersPanel(provider.getCustomModelerParameterPanels());
            SextanteGUI.addCustomParametersPanel(provider.getCustomParameterPanels());
        }
        initialized = true;
    }

    private static void setDefaultSettings() {
        int i;
        Setting[] baseSettings = new Setting[]{new SextanteGeneralSettings()};
        ArrayList<IAlgorithmProvider> providers = SextanteGUI.getAlgorithmProviders();
        Setting[] settings = new Setting[baseSettings.length + providers.size()];
        System.arraycopy(baseSettings, 0, settings, 0, baseSettings.length);
        for (i = 0; i < providers.size(); ++i) {
            settings[i + baseSettings.length] = providers.get(i).getSettings();
        }
        for (i = 0; i < settings.length; ++i) {
            HashMap<String, String> map = settings[i].getInitValues();
            m_Settings.putAll(map);
        }
        if (m_DefaultSettings != null) {
            m_Settings.putAll(m_DefaultSettings);
        }
    }

    public static void setCustomDefaultSettings(HashMap<String, String> map) {
        m_DefaultSettings = map;
    }

    private static void loadResources() {
        Class[] sModelerPanelClass;
        Class[] sPanelClass;
        for (Class element : sPanelClass = GUIResources.getParameterPanelClasses()) {
            try {
                Class panelClass = element;
                String sAlgClassName = element.getName().substring(0, element.getName().indexOf("ParametersPanel")) + "Algorithm";
                Class<?> algClass = panelClass.getClassLoader().loadClass(sAlgClassName);
                GeoAlgorithm alg = (GeoAlgorithm)algClass.newInstance();
                m_ParametersPanel.put(alg.getCommandLineName(), panelClass);
            }
            catch (Exception panelClass) {
                // empty catch block
            }
        }
        for (Class element : sModelerPanelClass = GUIResources.getModelerParameterPanelClasses()) {
            try {
                Class panelClass = element;
                String sAlgClassName = element.getName().substring(0, element.getName().indexOf("ModelerParametersPanel")) + "Algorithm";
                Class<?> algClass = panelClass.getClassLoader().loadClass(sAlgClassName);
                GeoAlgorithm alg = (GeoAlgorithm)algClass.newInstance();
                m_ModelerParametersPanel.put(alg.getCommandLineName(), panelClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getHelpPath() {
        return SextanteGUI.getSextanteInstallPath() + File.separator + "help";
    }

    public static void setSextantePath(String sPath) {
        m_sSextanteInstallPath = sPath;
    }

    public static String getSextantePath() {
        return m_sSextanteInstallPath;
    }

    public static String getSextanteHomePath() {
        return m_sSextanteHomePath;
    }

    public static String getSextanteInstallPath() {
        return m_sSextanteInstallPath;
    }

    public static void setSextanteHomePath(String path) {
        m_sSextanteHomePath = path;
    }

    public static void setSextanteInstallPath(String path) {
        m_sSextanteInstallPath = path;
    }

    public static String getOutputFolder() {
        if (m_sOutputFolder == null || m_sOutputFolder.trim().equals("")) {
            return System.getProperty("user.home");
        }
        return m_sOutputFolder;
    }

    private static Double getDefaultNoDataValue() {
        try {
            double dNoDataValue = Double.parseDouble(SextanteGUI.getSettingParameterValue("NoDataValue"));
            return dNoDataValue;
        }
        catch (Exception e) {
            return new Double(-99999.0);
        }
    }

    private static void readConfigFile() {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(SextanteGUI.getConfigFile()));
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                String[] sTokens = sLine.split("=");
                if (sTokens.length != 2) continue;
                m_Settings.put(sTokens[0], sTokens[1]);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(SextanteGUI.getConfigFile()));
            Set<String> set = m_Settings.keySet();
            for (String sKey : set) {
                String sValue = m_Settings.get(sKey);
                output.write(sKey + "=" + sValue + "\n");
            }
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
        }
    }

    private static String getConfigFile() {
        String sPath = SextanteGUI.getUserFolder();
        return sPath + File.separator + "sextante.settings";
    }

    public static String getUserFolder() {
        File sextanteFolder;
        String sPath = SextanteGUI.getSextanteHomePath();
        String sConfDir = System.getProperty("SEXTANTE.confDir");
        if (sConfDir != null && (sConfDir = sConfDir.trim()).length() > 0) {
            sPath = sConfDir.endsWith(File.separator) ? sConfDir : sConfDir + File.separator;
        }
        if (!(sextanteFolder = new File(sPath)).exists()) {
            sextanteFolder.mkdir();
        }
        return sPath;
    }

    public static int getLastCommandOrigin() {
        return m_iLastCommandOrigin;
    }

    public static void setLastCommandOrigin(int iLast) {
        m_iLastCommandOrigin = iLast;
    }

    public static JDialog getLastCommandOriginParentDialog() {
        return m_LastCommandOriginParentPanel;
    }

    public static void setLastCommandOriginParentDialog(JDialog parent) {
        m_LastCommandOriginParentPanel = parent;
    }

    public static boolean getShowOnlyActiveAlgorithms() {
        return m_bShowOnlyActiveAlgorithms;
    }

    public static void setShowOnlyActiveAlgorithms(boolean showOnlyActiveAlgorithms) {
        m_bShowOnlyActiveAlgorithms = showOnlyActiveAlgorithms;
    }

    public static void setSettings(HashMap<String, String> settings) {
        m_Settings.putAll(settings);
    }

    public static String modifyResultName(String sName) {
        sName = sName.replaceAll("\\.", "_");
        sName = sName.replaceAll(" ", "_");
        sName = sName.replaceAll("\\[", "_");
        sName = sName.replaceAll("\\]", "_");
        sName = sName.replaceAll("\\(", "_");
        sName = sName.replaceAll("\\)", "_");
        sName = sName.replaceAll("\u00c3\u00a1", "a");
        sName = sName.replaceAll("\u00c3\u00a9", "e");
        sName = sName.replaceAll("\u00c3\u00ad", "i");
        sName = sName.replaceAll("\u00c3\u00b3", "o");
        sName = sName.replaceAll("\u00c3\u00ba", "u");
        sName = sName.replaceAll("\u00c3\u00b1", "n");
        return sName;
    }

    private static void addCustomParametersPanel(HashMap<String, Class> map) {
        m_ParametersPanel.putAll(map);
    }

    private static void addCustomModelerParametersPanel(HashMap<String, Class> map) {
        m_ModelerParametersPanel.putAll(map);
    }

    public static Class getModelerParametersPanel(String sName) {
        return m_ModelerParametersPanel.get(sName);
    }

    public static Class getParametersPanel(String sName) {
        return m_ParametersPanel.get(sName);
    }

    public static ImageIcon getAlgorithmIcon(GeoAlgorithm alg) {
        String sName = Sextante.getAlgorithmProviderName((GeoAlgorithm)alg);
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            if (!m_AlgorithmProviders.get(i).getName().equals(sName)) continue;
            return m_AlgorithmProviders.get(i).getIcon();
        }
        return SEXTANTE_ICON;
    }

    public static ArrayList<IAlgorithmProvider> getAlgorithmProviders() {
        return m_AlgorithmProviders;
    }

    public static String getSettingParameterValue(String sParameterName) {
        return m_Settings.get(sParameterName);
    }

    public static String setSettingParameterValue(String sParameterName, String sValue) {
        return m_Settings.put(sParameterName, sValue);
    }

    public static void updateAlgorithmProvider(Class providerClass) {
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            IAlgorithmProvider provider = m_AlgorithmProviders.get(i);
            if (!providerClass.isInstance(provider)) continue;
            provider.update();
            Sextante.addAlgorithmsFromProvider((String)provider.getName(), provider.getAlgorithms());
        }
    }

    public static Object getAlgorithmHelp(GeoAlgorithm alg) {
        try {
            File helpfile = alg.getHelpFile();
            if (helpfile != null) {
                return HelpIO.getHelpAsHTMLCode(alg, helpfile.getAbsolutePath());
            }
        }
        catch (Throwable helpfile) {
            // empty catch block
        }
        String sName = Sextante.getAlgorithmProviderName((GeoAlgorithm)alg);
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            if (!m_AlgorithmProviders.get(i).getName().equals(sName)) continue;
            return m_AlgorithmProviders.get(i).getAlgorithmHelp(alg);
        }
        if (sName.equals("SEXTANTE")) {
            String sFilename = alg.getCommandLineName() + ".xml";
            String sPath = HelpIO.getHelpPath(alg, false);
            return HelpIO.getHelpAsHTMLCode(alg, sPath + File.separator + sFilename);
        }
        return "";
    }

    public static String getAlgorithmHelpFilename(GeoAlgorithm alg, boolean bForceCurrentLocale) {
        String sName = Sextante.getAlgorithmProviderName((GeoAlgorithm)alg);
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            if (!m_AlgorithmProviders.get(i).getName().equals(sName)) continue;
            return m_AlgorithmProviders.get(i).getAlgorithmHelpFilename(alg, bForceCurrentLocale);
        }
        if (sName.equals("SEXTANTE")) {
            String sFilename = alg.getCommandLineName() + ".xml";
            String sPath = HelpIO.getHelpPath(alg, false);
            return sPath + File.separator + sFilename;
        }
        return "";
    }

    public static HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        HashMap<NameAndIcon, ArrayList<ToolboxAction>> map = new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            IAlgorithmProvider provider = m_AlgorithmProviders.get(i);
            map.putAll(provider.getToolboxActions());
        }
        map.putAll(SextanteGUI.getGUIFactory().getToolboxActions());
        return map;
    }

    public static IToolboxRightButtonAction[] getToolboxRightButtonActions() {
        ArrayList<IToolboxRightButtonAction> list = new ArrayList<IToolboxRightButtonAction>();
        for (int i = 0; i < m_AlgorithmProviders.size(); ++i) {
            IAlgorithmProvider provider = m_AlgorithmProviders.get(i);
            IToolboxRightButtonAction[] actions = provider.getToolboxRightButtonActions();
            for (int j = 0; j < actions.length; ++j) {
                list.add(actions[j]);
            }
        }
        return list.toArray(new IToolboxRightButtonAction[0]);
    }

    public static IDataRenderer getDataRenderer() {
        return m_Renderer;
    }

    public static void setDataRenderer(IDataRenderer renderer) {
        m_Renderer = renderer;
    }

    static {
        m_GUIFactory = new DefaultGUIFactory();
        m_bShowOnlyActiveAlgorithms = false;
        m_Settings = new HashMap();
        m_DefaultSettings = new HashMap();
        foldersWithResources = new ArrayList();
        initialized = false;
        m_ParametersPanel = new HashMap();
        m_ModelerParametersPanel = new HashMap();
        m_AlgorithmProviders = new ArrayList();
        SEXTANTE_ICON = new ImageIcon(SextanteGUI.class.getClassLoader().getResource("images/module2.png"));
        COLOR_WHITE = new Color(255, 255, 255, 255);
        COLOR_GREY = new Color(128, 128, 128, 255);
        COLOR_BLACK = new Color(0, 0, 0, 255);
        COLOR_RED = new Color(255, 51, 51, 255);
        COLOR_ORANGE = new Color(255, 103, 51, 255);
        COLOR_YELLOW = new Color(255, 255, 51, 255);
        COLOR_GREEN_LIGHT = new Color(51, 255, 51, 255);
        COLOR_GREEN_DARK = new Color(0, 184, 0, 255);
        COLOR_BLUE_LIGHT = new Color(102, 179, 255, 255);
        COLOR_BLUE_DARK = new Color(0, 102, 204, 255);
        COLOR_PINK = new Color(255, 153, 255, 255);
        COLOR_PURPLE = new Color(163, 71, 255, 255);
        COLOR_BROWN_LIGHT = new Color(255, 168, 82, 255);
        COLOR_BROWN_DARK = new Color(204, 102, 0, 255);
        m_AlgorithmProviders.add(new ScriptAlgorithmProvider());
        m_AlgorithmProviders.add(new ModelerAlgorithmProvider());
    }
}

