/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.grass;

import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.ParameterContainer;
import es.unex.sextante.gui.modeler.DefaultModelerParametersPanel;
import es.unex.sextante.gui.modeler.OutputLayerSettingsPanel;
import es.unex.sextante.gui.modeler.OutputParameterContainer;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.Parameter;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GrassModelerParametersPanel
extends DefaultModelerParametersPanel {
    private JComboBox jComboRestrictGeometryType;

    @Override
    protected void addOutputObjects(JPanel pane) {
        super.addOutputObjects(pane);
        this.addTitleLabel(pane, Sextante.getText((String)"grass_restrict_geometry_ouput"), this.m_iCurrentRow, false);
        String[] options2 = new String[]{Sextante.getText((String)"Points"), Sextante.getText((String)"Lines"), Sextante.getText((String)"Polygons")};
        this.jComboRestrictGeometryType = new JComboBox<String>(options2);
        pane.add((Component)this.jComboRestrictGeometryType, this.getStringTableCoords(2, this.m_iCurrentRow));
        ++this.m_iCurrentRow;
    }

    private boolean makeNumericalValueAssignment(HashMap map, ParameterContainer parameterContainer) {
        Parameter parameter = null;
        String sKey = null;
        JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
        JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
        String sValue = textField.getText();
        try {
            parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            AdditionalInfoNumericalValue ai = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
            double dMin = ai.getMinValue();
            double dMax = ai.getMaxValue();
            sKey = parameter.getParameterName();
            Object ob = comboBox.getSelectedItem();
            if (ob instanceof ObjectAndDescription) {
                ObjectAndDescription oad = (ObjectAndDescription)ob;
                String sAssignment = (String)oad.getObject();
                map.put(sKey, sAssignment);
                return true;
            }
            try {
                double dValue = Double.parseDouble(sValue);
                if (dValue < dMin || dValue > dMax) {
                    return false;
                }
                String sInnerKey = this.getInnerParameterKey();
                map.put(sKey, sInnerKey);
                Double value = new Double(dValue);
                this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Numerical Value", (Object)value));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean assignParameters(HashMap map) {
        int i;
        boolean bAssigningOK = true;
        for (i = 0; i < this.m_InputParameterContainer.size(); ++i) {
            ParameterContainer parameterContainer = (ParameterContainer)this.m_InputParameterContainer.get(i);
            if (parameterContainer.getType().equals("Table") || parameterContainer.getType().equals("Vector Layer") || parameterContainer.getType().equals("Raster Layer") || parameterContainer.getType().equals("Point")) {
                this.makeDataObjectAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Multiple Input")) {
                this.makeMultipleInputAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Numerical Value")) {
                this.makeNumericalValueAssignment(map, parameterContainer);
                bAssigningOK = true;
            } else if (parameterContainer.getType().equals("String")) {
                this.makeStringAssignment(map, parameterContainer);
                bAssigningOK = true;
            } else if (parameterContainer.getType().equals("Boolean")) {
                bAssigningOK = this.makeBooleanAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Fixed Table")) {
                bAssigningOK = this.makeFixedTableAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Filepath")) {
                bAssigningOK = this.makeFilepathAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Band")) {
                bAssigningOK = this.makeRasterBandAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Table Field")) {
                this.makeTableFieldAssignment(map, parameterContainer);
                bAssigningOK = true;
            } else if (parameterContainer.getType().equals("Selection")) {
                bAssigningOK = this.makeSelectionAssignment(map, parameterContainer);
            }
            if (bAssigningOK) continue;
            return false;
        }
        this.m_GlobalAlgorithm.setGeometryTypeRestriction(this.jComboRestrictGeometryType.getSelectedIndex());
        OutputObjectsSet oosetGlobal = this.m_GlobalAlgorithm.getOutputObjects();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (i = 0; i < this.m_OutputParameterDefinitionContainer.size(); ++i) {
            OutputParameterContainer opc = (OutputParameterContainer)this.m_OutputParameterDefinitionContainer.get(i);
            OutputLayerSettingsPanel olsp = (OutputLayerSettingsPanel)opc.getContainer();
            String sName = opc.getName() + this.m_sAlgorithmName;
            if (olsp.getKeepAsFinalResult()) {
                try {
                    Output out = ooset.getOutput(opc.getName());
                    Output outToAdd = (Output)out.getClass().newInstance();
                    outToAdd.setName(sName);
                    outToAdd.setDescription(olsp.getName());
                    oosetGlobal.add(outToAdd);
                }
                catch (Exception exception) {}
                continue;
            }
            oosetGlobal.remove(sName);
        }
        return true;
    }

    @Override
    protected double[][] getTableLayoutMatrix() {
        int i;
        int iRows = 0;
        double[] iSizeColumns = new double[]{10.0, -1.0, 360.0, 10.0};
        iRows += this.m_Algorithm.getNumberOfParameters();
        if (this.m_Algorithm.requiresRasterLayers() || this.m_Algorithm.requiresMultipleRasterLayers() || this.m_Algorithm.requiresMultipleRasterBands()) {
            ++iRows;
        }
        if (this.m_Algorithm.requiresVectorLayers() || this.m_Algorithm.requiresMultipleVectorLayers()) {
            ++iRows;
        }
        if (this.m_Algorithm.requiresTables() || this.m_Algorithm.requiresMultipleTables()) {
            ++iRows;
        }
        if (this.m_Algorithm.requires3DRasterLayers()) {
            ++iRows;
        }
        if (this.m_Algorithm.requiresNonDataObjects()) {
            ++iRows;
        }
        OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
        int iOutput = ooSet.getOutputObjectsCount();
        int iVectorLayers = ooSet.getVectorLayersCount();
        if (iVectorLayers != 0) {
            iRows += 2;
            iOutput += 2;
        }
        if (iOutput != 0) {
            iRows += iOutput + 1;
        }
        double[] iSizeRows = new double[iRows];
        for (i = 0; i < iRows - iOutput; ++i) {
            iSizeRows[i] = CELL_HEIGHT;
        }
        for (i = iRows - iOutput; i < iRows; ++i) {
            iSizeRows[i] = (double)CELL_HEIGHT * 2.5;
        }
        double[][] iSize = new double[][]{iSizeColumns, iSizeRows};
        return iSize;
    }
}

