/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.help;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.help.HelpElement;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.help.ImageAndDescription;
import es.unex.sextante.gui.help.ImageSelectionDialog;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ElementEditionPanel
extends JPanel {
    private HelpElement m_Element;
    private JPanel jPanelImages;
    private JTextArea jTextAreaDescription;
    private JScrollPane jScrollPaneTextArea;
    private JButton jButtonRemoveImage;
    private JButton jButtonAddImage;
    private JList jListImages;
    private JPanel jPanelText;
    private final GeoAlgorithm m_Alg;

    public ElementEditionPanel(GeoAlgorithm ext) {
        this.m_Alg = ext;
        this.initGUI();
    }

    private void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0}, {5.0, -1.0, 5.0, -1.0, 5.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        this.setPreferredSize(new Dimension(565, 252));
        this.jPanelText = new JPanel();
        BorderLayout jPanelTextLayout = new BorderLayout();
        this.jPanelText.setLayout(jPanelTextLayout);
        this.add((Component)this.jPanelText, "1, 1");
        this.jPanelText.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Description")));
        this.jTextAreaDescription = new JTextArea();
        this.jTextAreaDescription.setLineWrap(true);
        this.jTextAreaDescription.setWrapStyleWord(true);
        this.jScrollPaneTextArea = new JScrollPane(this.jTextAreaDescription, 20, 30);
        this.jPanelText.add((Component)this.jScrollPaneTextArea, "Center");
        this.jTextAreaDescription.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelImages = new JPanel();
        TableLayout jPanelImagesLayout = new TableLayout((double[][])new double[][]{{-1.0, 5.0, 100.0, 5.0}, {-1.0, 30.0, 5.0, 30.0, -1.0}});
        jPanelImagesLayout.setHGap(5);
        jPanelImagesLayout.setVGap(5);
        this.jPanelImages.setLayout((LayoutManager)jPanelImagesLayout);
        this.add((Component)this.jPanelImages, "1, 3");
        this.jPanelImages.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Images")));
        DefaultListModel jListImagesModel = new DefaultListModel();
        this.jListImages = new JList();
        this.jListImages.setSelectionMode(0);
        this.jPanelImages.add((Component)this.jListImages, "0, 0, 0, 4");
        this.jListImages.setModel(jListImagesModel);
        this.jListImages.setBorder(BorderFactory.createBevelBorder(1));
        this.jButtonAddImage = new JButton();
        this.jButtonAddImage.setText(Sextante.getText((String)"Add_image"));
        this.jButtonAddImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementEditionPanel.this.addImage();
            }
        });
        this.jPanelImages.add((Component)this.jButtonAddImage, "2, 1");
        this.jButtonRemoveImage = new JButton();
        this.jButtonRemoveImage.setText(Sextante.getText((String)"Remove_image"));
        this.jButtonRemoveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementEditionPanel.this.removeImage();
            }
        });
        this.jPanelImages.add((Component)this.jButtonRemoveImage, "2, 3");
    }

    protected void removeImage() {
        DefaultListModel model = (DefaultListModel)this.jListImages.getModel();
        int selection = this.jListImages.getSelectedIndex();
        model.remove(selection);
    }

    private void addImage() {
        Frame window = new Frame();
        ImageAndDescription iad = new ImageAndDescription();
        ImageSelectionDialog dialog = new ImageSelectionDialog(window, iad, HelpIO.getHelpPath(this.m_Alg, true));
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getOK()) {
            DefaultListModel model = (DefaultListModel)this.jListImages.getModel();
            model.addElement(iad);
        }
    }

    public void setElement(HelpElement element) {
        this.m_Element = element;
        this.jTextAreaDescription.setText(element.getText());
        ArrayList images = element.getImages();
        DefaultListModel model = (DefaultListModel)this.jListImages.getModel();
        model.clear();
        for (int i = 0; i < images.size(); ++i) {
            model.addElement(images.get(i));
        }
    }

    public void saveElement() {
        if (this.m_Element != null) {
            this.m_Element.setText(this.jTextAreaDescription.getText());
            ArrayList list = new ArrayList();
            this.m_Element.setImages(list);
            DefaultListModel model = (DefaultListModel)this.jListImages.getModel();
            for (int i = 0; i < model.size(); ++i) {
                list.add(model.get(i));
            }
        }
    }
}

