/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.help;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.help.FileUtilities;
import es.unex.sextante.gui.help.ImageAndDescription;
import es.unex.sextante.gui.help.ImageSelectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ImageSelectionDialog
extends JDialog {
    private JPanel jPanelMain;
    private JSeparator jSeparator;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private boolean m_bOK = false;
    private ImageSelectionPanel m_ImageSelectionPanel;
    private final ImageAndDescription m_ImageAndDescription;
    private final String m_sHomeDir;

    public ImageSelectionDialog(Frame window, ImageAndDescription iad, String sHomeDir) {
        super(window, "", true);
        this.setResizable(false);
        this.m_sHomeDir = sHomeDir;
        this.m_ImageAndDescription = iad;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(Sextante.getText((String)"Image"));
            this.jPanelMain = new JPanel();
            this.getContentPane().add((Component)this.jPanelMain, "Center");
            this.jPanelMain.setPreferredSize(new Dimension(400, 150));
            this.m_ImageSelectionPanel = new ImageSelectionPanel(this.m_sHomeDir);
            this.jPanelMain.add(this.m_ImageSelectionPanel);
            this.jSeparator = new JSeparator();
            this.jPanelMain.add(this.jSeparator);
            this.jSeparator.setPreferredSize(new Dimension(350, 20));
            this.jButtonOK = new JButton();
            this.jPanelMain.add(this.jButtonOK);
            this.jButtonOK.setText(Sextante.getText((String)"OK"));
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImageSelectionDialog.this.btnOKActionPerformed(evt);
                }
            });
            this.jButtonCancel = new JButton();
            this.jPanelMain.add(this.jButtonCancel);
            this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImageSelectionDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(350, 100);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        File f = new File(this.m_ImageSelectionPanel.getFilename());
        File home = new File(this.m_sHomeDir);
        String sFilename = FileUtilities.getRelativePath(home, f);
        sFilename = sFilename.replaceAll("\\\\", "/");
        this.m_ImageAndDescription.setFilename(sFilename);
        this.m_ImageAndDescription.setDescription(this.m_ImageSelectionPanel.getDescription());
        this.m_bOK = true;
        this.dispose();
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.m_bOK = false;
        this.dispose();
        this.setVisible(false);
    }

    public boolean getOK() {
        return this.m_bOK;
    }
}

