/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.history;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.history.DateAndCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;

public class History {
    private static long m_SessionStartingTime;

    public static void addToHistory(String[] sExp) {
        for (int i = 0; i < sExp.length; ++i) {
            History.addToHistory(sExp[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToHistory(String sExp) {
        Writer output = null;
        String s = Long.toString(System.currentTimeMillis()) + "@" + sExp.replace("\\", "\\\\") + "\n";
        try {
            output = new BufferedWriter(new FileWriter(History.getHistoryFile(), true));
            output.write(s);
            output.flush();
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
        }
    }

    public static GeoAlgorithm[] getRecentlyUsedAlgs() {
        ArrayList<String> algs2 = new ArrayList<String>();
        ArrayList<DateAndCommand> history = History.getHistory();
        for (int i = history.size() - 1; i > -1; --i) {
            GeoAlgorithm alg;
            String sAlg;
            DateAndCommand dac = history.get(i);
            String command = dac.getCommand();
            if (!command.startsWith("runalg") || algs2.contains(sAlg = command.split("\"")[1]) || (alg = Sextante.getAlgorithmFromCommandLineName((String)sAlg)) == null) continue;
            algs2.add(sAlg);
            if (algs2.size() == 10) break;
        }
        GeoAlgorithm[] recentAlgs = new GeoAlgorithm[algs2.size()];
        for (int i = 0; i < recentAlgs.length; ++i) {
            recentAlgs[i] = Sextante.getAlgorithmFromCommandLineName((String)((String)algs2.get(i)));
        }
        return recentAlgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<DateAndCommand> getHistory() {
        ArrayList<DateAndCommand> list = new ArrayList<DateAndCommand>();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(History.getHistoryFile()));
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                String[] sTokens = sLine.split("@");
                DateAndCommand dac = new DateAndCommand();
                dac.setDate(new Date(Long.parseLong(sTokens[0])));
                dac.setCommand(sTokens[1]);
                list.add(dac);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    private static String getHistoryFile() {
        String sPath = SextanteGUI.getSextanteHomePath();
        File sextanteFolder = new File(sPath);
        if (!sextanteFolder.exists()) {
            sextanteFolder.mkdir();
        }
        sPath = sPath + File.separator + "toolbox.history";
        return sPath;
    }

    public static void startSession() {
        m_SessionStartingTime = System.currentTimeMillis();
    }

    public static long getSessionStartingTime() {
        return m_SessionStartingTime;
    }

    public static void clear() {
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(History.getHistoryFile(), false));
            output.flush();
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
        }
    }
}

