/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.history;

import bsh.EvalError;
import bsh.Interpreter;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.LogElement;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.core.SextanteLogHandler;
import es.unex.sextante.gui.core.NamedPoint;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.history.DateAndCommand;
import es.unex.sextante.gui.history.History;
import es.unex.sextante.gui.history.NonWordWrapPane;
import es.unex.sextante.gui.toolbox.TransparentScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HistoryPanel
extends JPanel {
    private JTree jTree;
    private JScrollPane jScrollPane;
    private JMenuItem menuItemExecute;
    private JMenuItem menuItemShowExecuteDialog;
    private JPopupMenu popupMenu;
    private TreePath m_Path;
    private DateAndCommand m_Command;
    private ArrayList<DateAndCommand> m_Commands;
    private final HashMap<String, DefaultMutableTreeNode> m_NodesMap = new HashMap();
    private final HashMap<DefaultMutableTreeNode, Boolean> m_NodeStatus = new HashMap();
    private JSplitPane jSplitPane;
    private NonWordWrapPane jNonWordWrapPane;
    private TransparentScrollPane jScrollPaneText;

    public HistoryPanel() {
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(650, 380));
        this.setSize(new Dimension(650, 380));
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.jSplitPane = new JSplitPane();
        this.jTree = new JTree();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HistoryPanel.this.m_Command = null;
                HistoryPanel.this.menuItemExecute.setVisible(false);
                HistoryPanel.this.menuItemShowExecuteDialog.setVisible(false);
                HistoryPanel.this.m_Path = HistoryPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (HistoryPanel.this.m_Path != null) {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)HistoryPanel.this.m_Path.getLastPathComponent();
                        Object obj = node.getUserObject();
                        if (obj instanceof DateAndCommand) {
                            HistoryPanel.this.m_Command = (DateAndCommand)obj;
                            HistoryPanel.this.menuItemExecute.setVisible(true);
                            String sAlg = HistoryPanel.this.m_Command.getCommand();
                            if (sAlg.startsWith("runalg")) {
                                Object[] objs;
                                sAlg = sAlg.substring("runalg(\"".length());
                                GeoAlgorithm alg = Sextante.getAlgorithmFromCommandLineName((String)(sAlg = sAlg.substring(0, sAlg.indexOf("\""))));
                                if (alg.meetsDataRequirements(objs = SextanteGUI.getInputFactory().getDataObjects())) {
                                    HistoryPanel.this.menuItemShowExecuteDialog.setVisible(true);
                                }
                            }
                            HistoryPanel.this.jNonWordWrapPane.setText(HistoryPanel.this.m_Command.getAsFullText());
                        } else if (obj instanceof LogElement) {
                            HistoryPanel.this.jNonWordWrapPane.setText(((LogElement)obj).getAsText());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (e.getButton() == 1) {
                    if (e.getClickCount() == 2 && HistoryPanel.this.m_Command != null) {
                        HistoryPanel.this.executeSelectedCommand();
                    }
                } else if (e.getButton() == 3 && HistoryPanel.this.m_Command != null) {
                    HistoryPanel.this.showPopupMenu(e);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setViewportView(this.jTree);
        this.jScrollPane.setSize(new Dimension(650, 380));
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setLeftComponent(this.jScrollPane);
        this.jNonWordWrapPane = new NonWordWrapPane();
        this.jNonWordWrapPane.setStyledDocument(new DefaultStyledDocument());
        this.jNonWordWrapPane.setFont(new Font("Monospaced", 0, 12));
        this.jNonWordWrapPane.setContentType("text/plain");
        this.jNonWordWrapPane.setEditable(false);
        this.jScrollPaneText = new TransparentScrollPane();
        this.jScrollPaneText.setBackground(Color.white);
        this.jScrollPaneText.setSize(new Dimension(650, 380));
        this.jScrollPaneText.setViewportView(this.jNonWordWrapPane);
        this.jSplitPane.setRightComponent(this.jScrollPaneText);
        this.add(this.jSplitPane);
        this.jSplitPane.setDividerLocation(150);
        this.updateContent();
        this.popupMenu = new JPopupMenu("Menu");
        this.menuItemExecute = new JMenuItem(Sextante.getText((String)"Run"));
        this.menuItemExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.executeSelectedCommand();
            }
        });
        this.popupMenu.add(this.menuItemExecute);
        this.menuItemShowExecuteDialog = new JMenuItem(Sextante.getText((String)"Show_algorithm_dialog"));
        this.menuItemShowExecuteDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.showExecuteDialog();
            }
        });
        this.popupMenu.add(this.menuItemShowExecuteDialog);
        this.popupMenu.addSeparator();
        JMenuItem menuItemExpand = new JMenuItem(Sextante.getText((String)"Expand_all"));
        menuItemExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.expandAll();
            }
        });
        this.popupMenu.add(menuItemExpand);
        JMenuItem menuItemCollapse = new JMenuItem(Sextante.getText((String)"Collapse_all"));
        menuItemCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.collapseAll();
            }
        });
        this.popupMenu.add(menuItemCollapse);
    }

    protected void showExecuteDialog() {
        if (this.m_Command == null) {
            return;
        }
        String sAlg = this.m_Command.getCommand();
        if (!sAlg.startsWith("runalg")) {
            return;
        }
        sAlg = sAlg.substring("runalg(\"".length());
        sAlg = sAlg.substring(0, sAlg.indexOf("\""));
        GeoAlgorithm alg = Sextante.getAlgorithmFromCommandLineName((String)sAlg);
        ArrayList<DateAndCommand> list = new ArrayList<DateAndCommand>();
        list.add(this.m_Command);
        SextanteGUI.getGUIFactory().showAlgorithmDialog(alg, null, list);
    }

    protected void showPopupMenu(MouseEvent e) {
        this.jTree.setSelectionPath(this.m_Path);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void collapseAll() {
        try {
            TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
            TreePath path = new TreePath(root);
            this.expandAll(this.jTree, path, false);
            this.jTree.expandPath(path);
            TreeNode node = root.getChildAt(0);
            TreePath subpath = path.pathByAddingChild(node);
            this.jTree.expandPath(subpath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void expandAll() {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        this.expandAll(this.jTree, new TreePath(root), true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        try {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void executeSelectedCommand() {
        if (this.m_Command == null) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    Interpreter interpreter = new Interpreter();
                    interpreter.getNameSpace().importCommands("es.unex.sextante.gui.cmd.bshcommands");
                    interpreter.eval(HistoryPanel.this.m_Command.getCommand());
                }
                catch (EvalError e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 0);
                }
            }
        };
        Thread th = new Thread(run);
        th.start();
    }

    public void updateContent() {
        DefaultMutableTreeNode node;
        this.jNonWordWrapPane.setText("");
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"History"));
        DefaultMutableTreeNode commandsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Commands"));
        this.m_Commands = History.getHistory();
        Set<String> set = this.m_NodesMap.keySet();
        for (String key : set) {
            node = this.m_NodesMap.get(key);
            if (node == null) continue;
            boolean bExpanded = this.jTree.isExpanded(this.getPath(node));
            this.m_NodeStatus.put(node, new Boolean(bExpanded));
            node.removeAllChildren();
        }
        for (int j = 0; j < this.m_Commands.size(); ++j) {
            DateAndCommand dac = this.m_Commands.get(j);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(dac);
            String sDay = dac.getDay();
            if (this.m_NodesMap.containsKey(sDay)) {
                node = this.m_NodesMap.get(sDay);
            } else {
                node = new DefaultMutableTreeNode(sDay);
                this.m_NodesMap.put(sDay, node);
            }
            node.insert(child, 0);
        }
        node = this.m_NodesMap.get(Sextante.getText((String)"This_session"));
        if (node != null && node.getChildCount() != 0) {
            commandsNode.add(node);
        }
        if ((node = this.m_NodesMap.get(Sextante.getText((String)"Today"))) != null && node.getChildCount() != 0) {
            commandsNode.add(node);
        }
        if ((node = this.m_NodesMap.get(Sextante.getText((String)"Yesterday"))) != null && node.getChildCount() != 0) {
            commandsNode.add(node);
        }
        for (int i = 0; i < 30; ++i) {
            String s = Sextante.getText((String)"XXX_days_ago");
            node = this.m_NodesMap.get(s = s.replace("XXX", Integer.toString(i)));
            if (node == null || node.getChildCount() == 0) continue;
            commandsNode.add(node);
        }
        node = this.m_NodesMap.get(Sextante.getText((String)"More_than_one_month_ago"));
        if (node != null && node.getChildCount() != 0) {
            commandsNode.add(node);
        }
        mainNode.add(commandsNode);
        DefaultMutableTreeNode logElementsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Log_messages"));
        mainNode.add(logElementsNode);
        HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
        ArrayList elements = Sextante.getLogger().getLogElements();
        for (int i = 0; i < elements.size(); ++i) {
            LogElement element = (LogElement)elements.get(elements.size() - 1 - i);
            if (map.containsKey(element.getType())) {
                node = (DefaultMutableTreeNode)map.get(element.getType());
            } else {
                node = new DefaultMutableTreeNode(element.getType());
                map.put(element.getType(), node);
            }
            node.add(new DefaultMutableTreeNode(element));
        }
        set = map.keySet();
        for (String key : set) {
            logElementsNode.add((MutableTreeNode)map.get(key));
        }
        DefaultMutableTreeNode pointsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Points"));
        mainNode.add(pointsNode);
        List<NamedPoint> coords = SextanteGUI.getGUIFactory().getCoordinatesList();
        for (int i = 0; i < coords.size(); ++i) {
            pointsNode.add(new DefaultMutableTreeNode(coords.get(i).toStringFull()));
        }
        this.jTree.setModel(new DefaultTreeModel(mainNode));
        set = this.m_NodesMap.keySet();
        for (String key : set) {
            Boolean expanded;
            node = this.m_NodesMap.get(key);
            if (node == null || (expanded = this.m_NodeStatus.get(node)) == null || !expanded.booleanValue()) continue;
            this.jTree.expandPath(this.getPath(node));
        }
    }

    private TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public void clearHistory() {
        History.clear();
        this.updateContent();
    }

    public void clearLog() {
        SextanteLogHandler handler = Sextante.getLogger();
        handler.clear();
        this.updateContent();
    }
}

