/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.modeler.ColorComboBox;
import es.unex.sextante.gui.modeler.GeoAlgorithmModelerParametersPanel;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.modeler.elements.IModelElement;
import es.unex.sextante.modeler.elements.ModelElement3DRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementTable;
import es.unex.sextante.modeler.elements.ModelElementVectorLayer;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputNumericalValue;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class AlgorithmDialog
extends JDialog {
    private final ModelAlgorithm m_ModelAlgorithm;
    private final GeoAlgorithm m_Algorithm;
    private final String m_sAlgorithmName;
    private final String m_sAlgorithmDescription;
    private final HashMap m_DataObjects;
    private JTextField jTextFieldDescription;
    private JLabel jLabelDescription;
    private JPanel jPanelName;
    private JPanel jPanelButtons;
    private ColorComboBox jComboColor;
    private JButton jButtonInfo;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    protected GeoAlgorithmModelerParametersPanel jPanelParametersMain = null;
    private int m_iDialogReturn;

    public AlgorithmDialog(GeoAlgorithm algorithm, String sName, String sDescription, ModelAlgorithm modelAlgorithm, GeoAlgorithmModelerParametersPanel panel, HashMap dataObjects, JDialog parent) {
        super(parent, sDescription, true);
        this.m_Algorithm = algorithm;
        this.m_ModelAlgorithm = modelAlgorithm;
        this.m_DataObjects = dataObjects;
        this.m_sAlgorithmName = sName;
        this.m_sAlgorithmDescription = sDescription;
        this.jPanelParametersMain = panel;
        this.jPanelParametersMain.init(this);
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    public AlgorithmDialog(GeoAlgorithm algorithm, String sName, String sDescription, ModelAlgorithm modelAlgorithm, GeoAlgorithmModelerParametersPanel panel, HashMap dataObjects) {
        super(SextanteGUI.getMainFrame(), "", true);
        this.setLocationRelativeTo(null);
        this.m_Algorithm = algorithm;
        this.m_ModelAlgorithm = modelAlgorithm;
        this.m_DataObjects = dataObjects;
        this.m_sAlgorithmName = sName;
        this.m_sAlgorithmDescription = sDescription;
        this.jPanelParametersMain = panel;
        this.jPanelParametersMain.init(this);
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    private void initGUI() {
        this.setTitle(Sextante.getText((String)"modeler_add_algorithm") + " (" + this.m_Algorithm.getName() + ")");
        this.setPreferredSize(new Dimension(700, 450));
        this.setResizable(false);
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0}, {3.0, -3.0, 1.0, -1.0, 1.0, 40.0, 4.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.getContentPane().setLayout((LayoutManager)thisLayout);
        this.getContentPane().add((Component)this.getJPanelParameters(), "0, 3");
        this.jPanelName = new JPanel();
        TableLayout jPanelNameLayout = new TableLayout((double[][])new double[][]{{5.0, -3.0, 5.0, -1.0, 5.0}, {20.0, 3.0, -3.0}});
        jPanelNameLayout.setHGap(5);
        jPanelNameLayout.setVGap(5);
        this.jPanelName.setLayout((LayoutManager)jPanelNameLayout);
        this.jLabelDescription = new JLabel();
        this.jLabelDescription.setText(Sextante.getText((String)"Description"));
        this.jPanelName.add((Component)this.jLabelDescription, "1, 0");
        this.jTextFieldDescription = new JTextField();
        this.jTextFieldDescription.setText(this.getDefaultName());
        this.jPanelName.add((Component)this.jTextFieldDescription, "3, 0");
        this.jPanelName.add((Component)new JSeparator(0), "1, 2, 3, 2");
        this.getContentPane().add((Component)this.jPanelName, "0, 1");
        TableLayout panelLayout = new TableLayout((double[][])new double[][]{{5.0, -3.0, 5.0, 90.0, -1.0, 90.0, 5.0, 90.0, 5.0}, {1.0, 30.0, 5.0}});
        panelLayout.setHGap(5);
        panelLayout.setVGap(5);
        this.jPanelButtons = new JPanel();
        this.jPanelButtons.setLayout((LayoutManager)panelLayout);
        this.jButtonInfo = new JButton();
        this.jPanelButtons.add((Component)this.jButtonInfo, "1, 1");
        this.jButtonInfo.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/info.gif")));
        this.jButtonInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SextanteGUI.getGUIFactory().showHelpDialog(AlgorithmDialog.this.m_Algorithm);
            }
        });
        this.jComboColor = new ColorComboBox();
        Color curColor = new Color(this.m_Algorithm.getColorR(), this.m_Algorithm.getColorG(), this.m_Algorithm.getColorB(), this.m_Algorithm.getColorAlpha());
        this.jComboColor.getComboBox().setBackground(curColor);
        this.jPanelButtons.add((Component)this.jComboColor.getComboBox(), "3, 1");
        this.jComboColor.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color curColor = (Color)AlgorithmDialog.this.jComboColor.getComboBox().getSelectedItem();
                AlgorithmDialog.this.jComboColor.getComboBox().setBackground(curColor);
                AlgorithmDialog.this.m_Algorithm.setColorR(curColor.getRed());
                AlgorithmDialog.this.m_Algorithm.setColorG(curColor.getGreen());
                AlgorithmDialog.this.m_Algorithm.setColorB(curColor.getBlue());
                AlgorithmDialog.this.m_Algorithm.setColorAlpha(curColor.getAlpha());
            }
        });
        this.jButtonCancel = new JButton();
        this.jPanelButtons.add((Component)this.jButtonCancel, "5, 1");
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmDialog.this.m_iDialogReturn = 0;
                AlgorithmDialog.this.cancel();
            }
        });
        this.jButtonOK = new JButton();
        this.jPanelButtons.add((Component)this.jButtonOK, "7, 1");
        this.jButtonOK.setText(Sextante.getText((String)"OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlgorithmDialog.this.addAlgorithm()) {
                    AlgorithmDialog.this.m_iDialogReturn = 1;
                    AlgorithmDialog.this.cancel();
                }
            }
        });
        this.getContentPane().add((Component)this.jPanelButtons, "0, 5");
    }

    private String getDefaultName() {
        if (this.m_Algorithm.getDescription() != null && this.m_Algorithm.getDescription().length() > 1) {
            return this.m_Algorithm.getDescription();
        }
        return this.m_Algorithm.getName();
    }

    protected boolean addAlgorithm() {
        HashMap map = new HashMap();
        if (this.assignParameters(map)) {
            String sDescription;
            this.m_ModelAlgorithm.addAlgorithm(this.m_Algorithm, this.m_sAlgorithmName);
            if (this.jTextFieldDescription.getText() != null && this.jTextFieldDescription.getText().length() > 0) {
                sDescription = this.jTextFieldDescription.getText();
                this.m_Algorithm.setDescription(this.jTextFieldDescription.getText());
            } else {
                this.m_Algorithm.setDescription(this.m_Algorithm.getName());
            }
            Set set = map.keySet();
            for (String sKey : set) {
                String sAssignment = (String)map.get(sKey);
                this.m_ModelAlgorithm.addInputAsignment(sKey, sAssignment, this.m_sAlgorithmName);
            }
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            for (int i = 0; i < ooSet.getOutputObjectsCount(); ++i) {
                String sKey;
                Output out = ooSet.getOutput(i);
                if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable) && !(out instanceof Output3DRasterLayer) && !(out instanceof OutputNumericalValue)) continue;
                sKey = out.getName();
                sDescription = out.getDescription();
                sKey = sKey + this.m_sAlgorithmName;
                sDescription = "\"" + sDescription + "\" " + Sextante.getText((String)"from") + " " + this.m_sAlgorithmDescription;
                this.m_DataObjects.put(sKey, new ObjectAndDescription(sDescription, (Object)this.getOutputAsModelElement(out)));
            }
            return true;
        }
        JOptionPane.showMessageDialog(null, Sextante.getText((String)"Invalid_parameters"), Sextante.getText((String)"Warning"), 2);
        return false;
    }

    private IModelElement getOutputAsModelElement(Output out) {
        ModelElementRasterLayer element = null;
        if (out instanceof OutputRasterLayer) {
            element = new ModelElementRasterLayer();
            int iBands = ((OutputRasterLayer)out).getNumberOfBands();
            element.setNumberOfBands(iBands);
        } else if (out instanceof OutputVectorLayer) {
            element = new ModelElementVectorLayer();
            int iShapeType = ((OutputVectorLayer)out).getShapeType();
            ((ModelElementVectorLayer)element).setShapeType(iShapeType);
        } else if (out instanceof OutputTable) {
            element = new ModelElementTable();
        } else if (out instanceof Output3DRasterLayer) {
            element = new ModelElement3DRasterLayer();
        } else if (out instanceof OutputNumericalValue) {
            element = new ModelElementNumericalValue();
        }
        return element;
    }

    protected boolean assignParameters(HashMap map) {
        return this.getJPanelParameters().assignParameters(map);
    }

    public void cancel() {
        this.dispose();
        this.setVisible(false);
    }

    private GeoAlgorithmModelerParametersPanel getJPanelParameters() {
        return this.jPanelParametersMain;
    }

    public int getDialogReturn() {
        return this.m_iDialogReturn;
    }

    public GeoAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public ModelAlgorithm getModelAlgorithm() {
        return this.m_ModelAlgorithm;
    }

    public HashMap getDataObjects() {
        return this.m_DataObjects;
    }

    public String getAlgorithmName() {
        return this.m_sAlgorithmName;
    }

    public String getAlgorithmDescription() {
        return this.m_sAlgorithmDescription;
    }
}

