/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.modeler.AlgorithmDialog;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementTable;
import es.unex.sextante.modeler.elements.ModelElementVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterDataObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;

public abstract class GeoAlgorithmModelerParametersPanel
extends JPanel {
    protected HashMap m_DataObjects;
    protected GeoAlgorithm m_Algorithm;
    protected String m_sAlgorithmName;
    protected String m_sAlgorithmDescription;
    protected ModelAlgorithm m_GlobalAlgorithm;
    protected int m_iInnerParameter;

    public void init(AlgorithmDialog panel) {
        this.m_Algorithm = panel.getAlgorithm();
        this.m_GlobalAlgorithm = panel.getModelAlgorithm();
        this.m_DataObjects = panel.getDataObjects();
        this.m_sAlgorithmName = panel.getAlgorithmName();
        this.m_sAlgorithmDescription = panel.getAlgorithmDescription();
        this.m_iInnerParameter = 0;
        this.initGUI();
    }

    protected abstract void initGUI();

    public abstract boolean assignParameters(HashMap var1);

    protected Object getParameterValue(Parameter param) {
        String sKey = this.m_GlobalAlgorithm.getInputAsignment(param.getParameterName(), this.m_Algorithm);
        return this.m_DataObjects.get(sKey);
    }

    protected ObjectAndDescription[] getElementsOfClass(Class classOfInput, boolean bIncludeOptionalInputs) {
        return this.getElementsOfClassAOrB(classOfInput, null, bIncludeOptionalInputs);
    }

    protected ObjectAndDescription[] getElementsOfClassAOrB(Class classOfInputA, Class classOfInputB, boolean bIncludeOptionalInputs) {
        ArrayList<ObjectAndDescription> objects = new ArrayList<ObjectAndDescription>();
        ParametersSet ps = this.m_GlobalAlgorithm.getParameters();
        Set set = this.m_DataObjects.keySet();
        Iterator iter = set.iterator();
        if (classOfInputB == null) {
            classOfInputB = classOfInputA;
        }
        while (iter.hasNext()) {
            String sKey = (String)iter.next();
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            if (oad.getObject() == null) {
                System.out.println("SEXTANTE: GeoAlgorithmsModeler.java: getElementsOfClass(): Got NULL object.");
                continue;
            }
            if (!oad.getObject().getClass().equals(classOfInputA) && !oad.getObject().getClass().equals(classOfInputB)) continue;
            try {
                Parameter param = ps.getParameter(sKey);
                if (param instanceof ParameterDataObject) {
                    AdditionalInfoDataObject additionalInfo = (AdditionalInfoDataObject)((ParameterDataObject)param).getParameterAdditionalInfo();
                    if (!bIncludeOptionalInputs && !additionalInfo.getIsMandatory() || this.isParameterProducedByThisProcess(sKey) || this.dependsOnThisProcess(sKey)) continue;
                    objects.add(new ObjectAndDescription(oad.getDescription(), (Object)sKey));
                    continue;
                }
                if (this.isParameterProducedByThisProcess(sKey) || this.dependsOnThisProcess(sKey)) continue;
                objects.add(new ObjectAndDescription(oad.getDescription(), (Object)sKey));
            }
            catch (WrongParameterIDException e) {
                if (this.isParameterProducedByThisProcess(sKey) || this.dependsOnThisProcess(sKey)) continue;
                objects.add(new ObjectAndDescription(oad.getDescription(), (Object)sKey));
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        Object[] ret = new ObjectAndDescription[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            ret[i] = (ObjectAndDescription)objects.get(i);
        }
        Arrays.sort(ret);
        return ret;
    }

    private boolean dependsOnThisProcess(String sKey) {
        block5: {
            Class<?> clazz;
            Object obj;
            ArrayList algorithmKeys;
            block4: {
                algorithmKeys = this.m_GlobalAlgorithm.getAlgorithmKeys();
                obj = this.getObjectFromKey(sKey);
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof GeoAlgorithm)) break block4;
                HashMap assignments = this.m_GlobalAlgorithm.getInputAssignments(sKey);
                Set set = assignments.keySet();
                for (String sAssignmentKey : set) {
                    String sAssignment = (String)assignments.get(sAssignmentKey);
                    if (!this.dependsOnThisProcess(sAssignment)) continue;
                    return true;
                }
                break block5;
            }
            if (!(obj instanceof ObjectAndDescription) || !(clazz = ((ObjectAndDescription)obj).getObject().getClass()).equals(ModelElementRasterLayer.class) && !clazz.equals(ModelElementVectorLayer.class) && !clazz.equals(ModelElementTable.class)) break block5;
            if (this.isProducedBy(sKey, this.m_sAlgorithmName)) {
                return true;
            }
            for (int i = 0; i < algorithmKeys.size(); ++i) {
                String sAlgKey = (String)algorithmKeys.get(i);
                if (!this.isProducedBy(sKey, sAlgKey) || !this.dependsOnThisProcess(sAlgKey)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getObjectFromKey(String sObjectKey) {
        Object obj = this.m_DataObjects.get(sObjectKey);
        if (obj != null) {
            return obj;
        }
        ArrayList algKeys = this.m_GlobalAlgorithm.getAlgorithmKeys();
        for (int i = 0; i < algKeys.size(); ++i) {
            String sKey = (String)algKeys.get(i);
            if (!sKey.equals(sObjectKey)) continue;
            return this.m_GlobalAlgorithm.getAlgorithm(sKey);
        }
        return null;
    }

    private boolean isParameterProducedByThisProcess(String sKey) {
        return sKey.endsWith(this.m_sAlgorithmName);
    }

    private boolean isProducedBy(String sParamKey, String sProccesKey) {
        return sParamKey.endsWith(sProccesKey);
    }

    protected String getInnerParameterKey() {
        return "INNERPARAM" + Integer.toString(this.m_iInnerParameter++) + this.m_sAlgorithmName;
    }
}

