/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.r;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.r.RAlgorithm;
import es.unex.sextante.gui.r.RExecutionException;
import es.unex.sextante.gui.r.StreamGobbler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class RUtils {
    private static ArrayList<String> m_ConsoleResults = new ArrayList();
    private static ArrayList<String> m_VerboseCommands;
    private static boolean m_AddConsoleOutput;

    private static void createBatchJob() {
        String sFilename = RUtils.getBatchJobFilename();
        String sRFolder = SextanteGUI.getSettingParameterValue("RFolder");
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(sFilename));
            if (Sextante.isWindows()) {
                output.write("\"" + sRFolder + File.separator + "bin" + File.separator + "R.exe\" CMD BATCH --vanilla \"" + RUtils.getRScriptFilename() + "\"");
            }
            output.close();
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private static String getBatchJobFilename() {
        String sFile = Sextante.isUnix() || Sextante.isMacOSX() ? "r_batch_job.sh" : "r_batch_job.bat";
        sFile = SextanteGUI.getUserFolder() + File.separator + sFile;
        return sFile;
    }

    public static void createRScriptFromRCommands(String[] sCommands) {
        String sFilename = RUtils.getRScriptFilename();
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(sFilename));
            for (int i = 0; i < sCommands.length; ++i) {
                output.write(sCommands[i] + "\n");
            }
            output.close();
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private static String getRScriptFilename() {
        String sFile = SextanteGUI.getUserFolder() + File.separator + "sextante_script.r";
        return sFile;
    }

    private static String getConsoleOutputFilename() {
        String sFile = SextanteGUI.getUserFolder() + File.separator + "sextante_script.r.Rout";
        return sFile;
    }

    public static int executeR(RAlgorithm alg) throws GeoAlgorithmExecutionException {
        m_ConsoleResults.clear();
        m_VerboseCommands = alg.getVerboseCommands();
        m_AddConsoleOutput = false;
        RUtils.createBatchJob();
        RUtils.createRScriptFromRCommands(alg.getFullSetOfRCommands());
        ArrayList<String> list = new ArrayList<String>();
        ProcessBuilder pb = new ProcessBuilder(list);
        if (!Sextante.isUnix() && !Sextante.isMacOSX()) {
            list.add("cmd.exe");
            list.add("/C");
            list.add(RUtils.getBatchJobFilename());
        }
        try {
            Process process = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
            errorGobbler.start();
            outputGobbler.start();
            int iReturn = process.waitFor();
            RUtils.createConsoleOutput();
            return iReturn;
        }
        catch (Exception e) {
            throw new RExecutionException();
        }
    }

    private static void createConsoleOutput() {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(RUtils.getConsoleOutputFilename()));
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                RUtils.processLine(sLine);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    public static void setExecutable(String sFilename) throws RExecutionException {
        String version = System.getProperty("java.version").substring(0, 3);
        Float f = Float.valueOf(version);
        if (f.floatValue() < 1.6f) {
            if (Sextante.isUnix() || Sextante.isMacOSX()) {
                try {
                    Runtime.getRuntime().exec("chmod +x " + sFilename);
                }
                catch (IOException e) {
                    throw new RExecutionException();
                }
            }
        } else if (Sextante.isUnix() || Sextante.isMacOSX()) {
            new File(sFilename).setExecutable(true);
        }
    }

    public static void processLine(String sLine) {
        if (sLine.startsWith(">")) {
            m_AddConsoleOutput = m_VerboseCommands.contains(sLine = sLine.substring(1).trim());
        } else if (m_AddConsoleOutput) {
            m_ConsoleResults.add("<p>" + sLine + "</p>\n");
        }
    }

    public static String getConsoleOutput() {
        StringBuffer out = new StringBuffer();
        out.append("<font face=\"courier\">\n");
        out.append("<h2> R Output</h2>\n");
        for (int i = 0; i < m_ConsoleResults.size(); ++i) {
            out.append(m_ConsoleResults.get(i));
        }
        out.append("</font>\n");
        return out.toString();
    }

    public static String getScriptsFolder() {
        return SextanteGUI.getSettingParameterValue("RScriptsFolder");
    }
}

