/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.saga;

import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.saga.SagaBlackList;
import es.unex.sextante.gui.saga.SagaExecutionException;
import es.unex.sextante.gui.saga.SagaLibraryNames;
import es.unex.sextante.gui.saga.SagaUtils;
import es.unex.sextante.gui.saga.UnwrappableSagaAlgorithmException;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.NullOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class SagaAlgorithm
extends GeoAlgorithm {
    private String m_sDescriptionFile;
    private int m_iExportedLayers;
    private HashMap<String, String> m_ExportedLayers;
    private String m_sLibraryName;

    public void initialize(String sDescriptionFile) throws UnwrappableSagaAlgorithmException {
        this.m_sDescriptionFile = sDescriptionFile;
        this.setIsDeterminatedProcess(true);
        this.setUserCanDefineAnalysisExtent(false);
        this.defineCharacteristicsFromDescriptionFile();
    }

    private void defineCharacteristicsFromDescriptionFile() throws UnwrappableSagaAlgorithmException {
        try {
            String sLastParentParameterName = null;
            BufferedReader input = new BufferedReader(new FileReader(this.m_sDescriptionFile));
            String sLine = input.readLine().trim();
            while (sLine != null) {
                sLine = sLine.trim();
                boolean bReadLine = true;
                if (sLine.startsWith("library name")) {
                    this.m_sLibraryName = sLine.split("\t")[1];
                    this.setGroup(SagaLibraryNames.getDecoratedLibraryName(this.m_sLibraryName));
                }
                if (sLine.startsWith("module name")) {
                    this.setName(sLine.split("\t")[1]);
                }
                if (sLine.contains("Olaya")) {
                    throw new UnwrappableSagaAlgorithmException();
                }
                if (sLine.startsWith("-")) {
                    String sDescription;
                    String sName;
                    try {
                        sName = sLine.substring(1, sLine.indexOf(":"));
                        sDescription = sLine.substring(sLine.indexOf(">") + 1).trim();
                    }
                    catch (Exception e) {
                        sName = sLine.substring(1, sLine.indexOf("\t"));
                        sDescription = sLine.substring(sLine.indexOf("\t") + 1).trim();
                    }
                    if (SagaBlackList.isInBlackList(sName, this.getGroup())) {
                        throw new UnwrappableSagaAlgorithmException();
                    }
                    sLine = input.readLine();
                    if (sLine.contains("Data object") && sLine.contains("File")) {
                        throw new UnwrappableSagaAlgorithmException();
                    }
                    if (sLine.contains("Table")) {
                        if (sLine.contains("input")) {
                            this.m_Parameters.addInputTable(sName, sDescription, !sLine.contains("optional"));
                            sLastParentParameterName = sName;
                        } else if (sLine.contains("Static")) {
                            sLine = input.readLine().trim();
                            String sNumber = sLine.split(" ")[0];
                            int iNumber = Integer.parseInt(sNumber);
                            String[] sColNames = new String[iNumber];
                            for (int i = 0; i < sColNames.length; ++i) {
                                sLine = input.readLine();
                                sColNames[i] = sLine.split("]")[1];
                            }
                            this.m_Parameters.addFixedTable(sName, sDescription, sColNames, 3, false);
                        } else if (sLine.contains("field")) {
                            if (sLastParentParameterName == null) {
                                throw new UnwrappableSagaAlgorithmException();
                            }
                            this.m_Parameters.addTableField(sName, sDescription, sLastParentParameterName);
                        } else {
                            this.addOutputTable(sName, sDescription);
                        }
                    }
                    if (sLine.contains("Grid")) {
                        if (sLine.contains("input")) {
                            if (sLine.contains("list")) {
                                this.m_Parameters.addMultipleInput(sName, sDescription, 1, !sLine.contains("optional"));
                            } else {
                                this.m_Parameters.addInputRasterLayer(sName, sDescription, !sLine.contains("optional"));
                            }
                        } else {
                            this.addOutputRasterLayer(sName, sDescription);
                        }
                    } else if (sLine.contains("Shapes")) {
                        if (sLine.contains("input")) {
                            if (sLine.contains("list")) {
                                this.m_Parameters.addMultipleInput(sName, sDescription, 5, !sLine.contains("optional"));
                            } else {
                                this.m_Parameters.addInputVectorLayer(sName, sDescription, -1, !sLine.contains("optional"));
                                sLastParentParameterName = sName;
                            }
                        } else {
                            this.addOutputVectorLayer(sName, sDescription, -1);
                        }
                    } else if (sLine.contains("Floating")) {
                        this.m_Parameters.addNumericalValue(sName, sDescription, 0.0, 2);
                    } else if (sLine.contains("Integer")) {
                        this.m_Parameters.addNumericalValue(sName, sDescription, 0.0, 1);
                    } else if (sLine.contains("Boolean")) {
                        this.m_Parameters.addBoolean(sName, sDescription, true);
                    } else if (sLine.contains("Text")) {
                        this.m_Parameters.addString(sName, sDescription);
                    } else if (sLine.contains("Choice")) {
                        input.readLine();
                        ArrayList<String> options2 = new ArrayList<String>();
                        sLine = input.readLine().trim();
                        while (sLine != null && !sLine.trim().startsWith("-")) {
                            options2.add(sLine);
                            sLine = input.readLine();
                        }
                        this.m_Parameters.addSelection(sName, sDescription, options2.toArray(new String[0]));
                        if (sLine == null) break;
                        bReadLine = false;
                    }
                }
                if (!bReadLine) continue;
                sLine = input.readLine();
            }
            input.close();
        }
        catch (Exception e) {
            throw new UnwrappableSagaAlgorithmException();
        }
    }

    public void defineCharacteristics() {
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IOutputChannel channel;
        Output out;
        int i;
        String sFilename;
        int i2;
        ArrayList<String> commands = new ArrayList<String>();
        this.m_ExportedLayers = new HashMap();
        for (i2 = 0; i2 < this.m_OutputObjects.getOutputDataObjectsCount(); ++i2) {
            Output out2 = this.m_OutputObjects.getOutput(i2);
            out2.setOutputChannel(this.getOutputChannel(out2.getName()));
        }
        for (i2 = 0; i2 < this.m_Parameters.getNumberOfParameters(); ++i2) {
            ArrayList list;
            IOutputChannel channel2;
            IRasterLayer layer;
            Parameter param = this.m_Parameters.getParameter(i2);
            if (param instanceof ParameterRasterLayer) {
                ParameterRasterLayer raster = (ParameterRasterLayer)param;
                layer = raster.getParameterValueAsRasterLayer();
                if (layer == null) continue;
                commands.add(this.exportRasterLayer(layer));
            }
            if (param instanceof ParameterVectorLayer) {
                ParameterVectorLayer vector = (ParameterVectorLayer)param;
                layer = vector.getParameterValueAsVectorLayer();
                if (layer == null) continue;
                channel2 = layer.getOutputChannel();
                if (channel2 instanceof FileOutputChannel) {
                    sFilename = ((FileOutputChannel)channel2).getFilename();
                    if (!sFilename.toLowerCase().endsWith("shp")) {
                        throw new SagaExecutionException(Sextante.getText((String)"unsupported_file_format"));
                    }
                } else {
                    throw new SagaExecutionException(Sextante.getText((String)"error_non_file_based_input"));
                }
            }
            if (param instanceof ParameterTable) {
                ParameterTable paramTable = (ParameterTable)param;
                ITable table = paramTable.getParameterValueAsTable();
                channel2 = table.getOutputChannel();
                if (channel2 instanceof FileOutputChannel) {
                    sFilename = ((FileOutputChannel)channel2).getFilename();
                    if (!sFilename.toLowerCase().endsWith("dbf")) {
                        throw new SagaExecutionException(Sextante.getText((String)"unsupported_file_format"));
                    }
                } else {
                    throw new SagaExecutionException(Sextante.getText((String)"error_non_file_based_input"));
                }
            }
            if (!(param instanceof ParameterMultipleInput) || (list = (ArrayList)param.getParameterValueAsObject()) == null || list.size() == 0) continue;
            AdditionalInfoMultipleInput aimi = (AdditionalInfoMultipleInput)((ParameterMultipleInput)param).getParameterAdditionalInfo();
            if (aimi.getDataType() == 1) {
                for (int j = 0; j < list.size(); ++j) {
                    commands.add(this.exportRasterLayer((IRasterLayer)list.get(j)));
                }
                continue;
            }
            if (aimi.getDataType() != 5) continue;
            for (int j = 0; j < list.size(); ++j) {
                IVectorLayer layer2 = (IVectorLayer)list.get(j);
                if (layer2 == null) continue;
                IOutputChannel channel3 = layer2.getOutputChannel();
                if (channel3 instanceof FileOutputChannel) {
                    String sFilename2 = ((FileOutputChannel)channel3).getFilename();
                    if (sFilename2.toLowerCase().endsWith("shp")) continue;
                    throw new SagaExecutionException(Sextante.getText((String)"unsupported_file_format"));
                }
                throw new SagaExecutionException(Sextante.getText((String)"error_non_file_based_input"));
            }
        }
        StringBuffer sCommand = new StringBuffer(this.m_sLibraryName + " \"" + this.getName() + "\"");
        for (i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            String sFilename3;
            Parameter param = this.m_Parameters.getParameter(i);
            Object paramObj = param.getParameterValueAsObject();
            if (param instanceof ParameterRasterLayer) {
                if (paramObj == null) continue;
                sFilename3 = ((FileOutputChannel)((IRasterLayer)paramObj).getOutputChannel()).getFilename();
                sCommand.append(" -" + param.getParameterName() + " " + this.m_ExportedLayers.get(sFilename3));
                continue;
            }
            if (param instanceof ParameterVectorLayer || param instanceof ParameterTable) {
                if (paramObj == null) continue;
                sFilename3 = ((FileOutputChannel)((IDataObject)paramObj).getOutputChannel()).getFilename();
                sCommand.append(" -" + param.getParameterName() + " " + sFilename3);
                continue;
            }
            if (param instanceof ParameterMultipleInput) {
                IDataObject dataObject;
                int j;
                ArrayList list;
                if (paramObj == null || (list = (ArrayList)paramObj).size() == 0) continue;
                sCommand.append(" -" + param.getParameterName() + " ");
                AdditionalInfoMultipleInput aimi = (AdditionalInfoMultipleInput)((ParameterMultipleInput)param).getParameterAdditionalInfo();
                if (aimi.getDataType() == 1) {
                    for (j = 0; j < list.size(); ++j) {
                        dataObject = (IDataObject)list.get(j);
                        String sFilename4 = ((FileOutputChannel)dataObject.getOutputChannel()).getFilename();
                        sCommand.append(this.m_ExportedLayers.get(sFilename4));
                        if (j >= list.size() - 1) continue;
                        sCommand.append(";");
                    }
                    continue;
                }
                for (j = 0; j < list.size(); ++j) {
                    dataObject = (IDataObject)list.get(j);
                    sCommand.append(((FileOutputChannel)dataObject.getOutputChannel()).getFilename());
                    if (j >= list.size() - 1) continue;
                    sCommand.append(";");
                }
                continue;
            }
            if (param instanceof ParameterSelection) {
                sCommand.append(" -" + param.getParameterName() + " " + Integer.toString(param.getParameterValueAsInt()));
                continue;
            }
            if (param instanceof ParameterBoolean) {
                if (!param.getParameterValueAsBoolean()) continue;
                sCommand.append(" -" + param.getParameterName());
                continue;
            }
            sCommand.append(" -" + param.getParameterName() + " " + param.getParameterValueAsString());
        }
        for (i = 0; i < this.m_OutputObjects.getOutputObjectsCount(); ++i) {
            String sFilename5;
            FileOutputChannel foc;
            out = this.m_OutputObjects.getOutput(i);
            if (out instanceof OutputRasterLayer) {
                channel = this.getOutputChannel(out.getName());
                if (channel instanceof FileOutputChannel) {
                    foc = (FileOutputChannel)channel;
                    sFilename = foc.getFilename();
                    if (!sFilename.endsWith("asc") && !sFilename.endsWith("tif")) {
                        sFilename = sFilename + ".tif";
                    }
                    foc.setFilename(sFilename);
                    out.setOutputChannel((IOutputChannel)foc);
                    sFilename = SextanteGUI.getOutputFactory().getTempFolder() + File.separator + new File(sFilename).getName() + ".sgrd";
                    sCommand.append(" -" + out.getName() + " " + sFilename);
                    continue;
                }
                if (channel instanceof NullOutputChannel) {
                    sFilename5 = SextanteGUI.getOutputFactory().getTempRasterLayerFilename();
                    sCommand.append(" -" + out.getName() + " " + sFilename5 + ".sgrd");
                    continue;
                }
                throw new UnsupportedOutputChannelException();
            }
            if (out instanceof OutputVectorLayer) {
                channel = this.getOutputChannel(out.getName());
                if (channel instanceof FileOutputChannel) {
                    foc = (FileOutputChannel)channel;
                    sFilename = foc.getFilename();
                    if (!sFilename.endsWith("shp")) {
                        sFilename = sFilename + ".shp";
                    }
                    foc.setFilename(sFilename);
                    out.setOutputChannel((IOutputChannel)foc);
                    sCommand.append(" -" + out.getName() + " " + sFilename);
                    continue;
                }
                if (channel instanceof NullOutputChannel) {
                    sFilename5 = SextanteGUI.getOutputFactory().getTempVectorLayerFilename();
                    sCommand.append(" -" + out.getName() + " " + sFilename5);
                    continue;
                }
                throw new UnsupportedOutputChannelException();
            }
            if (!(out instanceof OutputTable)) continue;
            channel = this.getOutputChannel(out.getName());
            if (channel instanceof FileOutputChannel) {
                foc = (FileOutputChannel)channel;
                sFilename = foc.getFilename();
                if (!sFilename.endsWith("dbf")) {
                    sFilename = sFilename + ".dbf";
                }
                foc.setFilename(sFilename);
                out.setOutputChannel((IOutputChannel)foc);
                sCommand.append(" -" + out.getName() + " " + sFilename);
                continue;
            }
            if (channel instanceof NullOutputChannel) {
                sFilename5 = SextanteGUI.getOutputFactory().getTempTableFilename();
                sCommand.append(" -" + out.getName() + " " + sFilename5);
                continue;
            }
            throw new UnsupportedOutputChannelException();
        }
        commands.add(sCommand.toString());
        for (i = 0; i < this.m_OutputObjects.getOutputObjectsCount(); ++i) {
            out = this.m_OutputObjects.getOutput(i);
            if (!(out instanceof OutputRasterLayer)) continue;
            channel = this.getOutputChannel(out.getName());
            if (!(channel instanceof FileOutputChannel)) {
                if (channel instanceof NullOutputChannel) continue;
                throw new UnsupportedOutputChannelException();
            }
            FileOutputChannel foc = (FileOutputChannel)channel;
            sFilename = foc.getFilename();
            if (!sFilename.endsWith("asc") && !sFilename.endsWith("tif")) {
                sFilename = sFilename + ".tif";
            }
            String sFilename2 = SextanteGUI.getOutputFactory().getTempFolder() + File.separator + new File(sFilename).getName() + ".sgrd";
            if (sFilename.endsWith("asc")) {
                commands.add("io_grid 0 -GRID " + sFilename2 + " -FORMAT 1 -FILE " + sFilename);
                continue;
            }
            commands.add("io_gdal 1 -GRIDS " + sFilename2 + " -FORMAT 1 -FILE " + sFilename);
        }
        SagaUtils.createSagaBatchJobFileFromSagaCommands(commands.toArray(new String[0]));
        SagaUtils.executeSaga(this);
        return !this.m_Task.isCanceled();
    }

    private String exportRasterLayer(IRasterLayer layer) throws SagaExecutionException {
        String sFilename;
        IOutputChannel channel = layer.getOutputChannel();
        if (channel instanceof FileOutputChannel) {
            sFilename = ((FileOutputChannel)channel).getFilename();
            if (!sFilename.toLowerCase().endsWith("tif") && !sFilename.toLowerCase().endsWith("asc")) {
                throw new SagaExecutionException(Sextante.getText((String)"unsupported_file_format"));
            }
        } else {
            throw new SagaExecutionException(Sextante.getText((String)"error_non_file_based_input"));
        }
        String sExt = sFilename.substring(sFilename.lastIndexOf(".") + 1);
        String sDestFilename = this.getTempFilename();
        this.m_ExportedLayers.put(((FileOutputChannel)channel).getFilename(), sDestFilename);
        if (sExt.toLowerCase().equals("tif")) {
            return "io_grid_image 1 -OUT_GRID " + sDestFilename + " -FILE " + sFilename + " -METHOD 0";
        }
        return "io_grid 1 -GRID " + sDestFilename + " -FILE " + sFilename;
    }

    private String getTempFilename() {
        ++this.m_iExportedLayers;
        String sPath = SextanteGUI.getOutputFactory().getTempFolder();
        String sFilename = sPath + File.separator + Long.toString(Calendar.getInstance().getTimeInMillis()) + Integer.toString(this.m_iExportedLayers) + ".sgrd";
        return sFilename;
    }

    public String getCommandLineName() {
        String sName = "saga:" + this.getName().toLowerCase().replace(" ", "");
        return sName;
    }

    public GeoAlgorithm getNewInstance() throws InstantiationException, IllegalAccessException {
        SagaAlgorithm alg = (SagaAlgorithm)((Object)((Object)((Object)this)).getClass().newInstance());
        alg.setOutputObjects(this.m_OutputObjects.getNewInstance());
        alg.setName(this.getName());
        alg.setGroup(this.getGroup());
        alg.setParameters(this.m_Parameters.getNewInstance());
        alg.setIsDeterminatedProcess(true);
        alg.setUserCanDefineAnalysisExtent(this.getUserCanDefineAnalysisExtent());
        alg.m_sDescriptionFile = this.m_sDescriptionFile;
        alg.m_sLibraryName = this.m_sLibraryName;
        return alg;
    }

    public void updateProgress(int iPartial, int iTotal) {
        this.setProgress(iPartial, iTotal);
    }
}

