/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.saga;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.grass.GrassAlgorithmProvider;
import es.unex.sextante.gui.saga.SagaAlgorithm;
import es.unex.sextante.gui.saga.SagaUtils;
import es.unex.sextante.gui.saga.UnwrappableSagaAlgorithmException;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.gui.settings.SextanteSagaSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class SagaAlgorithmProvider
implements IAlgorithmProvider {
    private static final ImageIcon SAGA_ICON = new ImageIcon(GrassAlgorithmProvider.class.getClassLoader().getResource("images/saga.png"));
    private final HashMap<String, GeoAlgorithm> m_Algs = new HashMap();

    @Override
    public boolean canEditHelp() {
        return false;
    }

    @Override
    public String getAlgorithmHelp(GeoAlgorithm alg) {
        return "";
    }

    @Override
    public String getAlgorithmHelpFilename(GeoAlgorithm alg, boolean forceCurrentLocale) {
        return null;
    }

    @Override
    public HashMap<String, GeoAlgorithm> getAlgorithms() {
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("SagaActivate"))) {
            return this.m_Algs;
        }
        return new HashMap<String, GeoAlgorithm>();
    }

    @Override
    public HashMap<String, Class> getCustomModelerParameterPanels() {
        return new HashMap<String, Class>();
    }

    @Override
    public HashMap<String, Class> getCustomParameterPanels() {
        return new HashMap<String, Class>();
    }

    @Override
    public ImageIcon getIcon() {
        return SAGA_ICON;
    }

    @Override
    public String getName() {
        return "SAGA";
    }

    @Override
    public Setting getSettings() {
        return new SextanteSagaSettings();
    }

    @Override
    public void initialize() {
        this.loadSagaAlgorithmsFromDescriptions();
    }

    private void loadSagaAlgorithmsFromDescriptions() {
        this.m_Algs.clear();
        if (SagaUtils.getSagaDescriptionFolder() == null) {
            SextanteGUI.setSettingParameterValue("SagaActivate", new Boolean(false).toString());
            return;
        }
        if (SagaUtils.getSagaDescriptionFolder().length() < 1) {
            SextanteGUI.setSettingParameterValue("SagaActivate", new Boolean(false).toString());
            return;
        }
        try {
            File file = new File(SagaUtils.getSagaDescriptionFolder());
            String[] files = file.list();
            if (files != null) {
                for (String element : files) {
                    SagaAlgorithm alg;
                    if (!element.startsWith("alg") || (alg = this.createAlgorithm(SagaUtils.getSagaDescriptionFolder() + File.separator + element)) == null) continue;
                    this.m_Algs.put(alg.getCommandLineName(), alg);
                }
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private SagaAlgorithm createAlgorithm(String sFile) {
        SagaAlgorithm alg = new SagaAlgorithm();
        try {
            alg.initialize(sFile);
            if (alg.getName() != null) {
                return alg;
            }
            return null;
        }
        catch (UnwrappableSagaAlgorithmException e) {
            return null;
        }
    }

    @Override
    public void update() {
        this.initialize();
    }

    @Override
    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        return new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
    }

    @Override
    public IToolboxRightButtonAction[] getToolboxRightButtonActions() {
        return new IToolboxRightButtonAction[0];
    }

    public static void addMessage(String sMessage, String sDescription) {
        Sextante.getLogger().addToLog(sMessage, "SAGA", sDescription);
    }
}

