/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.settings;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.FileSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.saga.SagaAlgorithmProvider;
import es.unex.sextante.gui.saga.SagaExecutionException;
import es.unex.sextante.gui.saga.SagaUtils;
import es.unex.sextante.gui.settings.SettingPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class SextanteSagaSettingsPanel
extends SettingPanel {
    private JCheckBox jActivateCheckBox;
    private JCheckBox jPortableCheckBox;
    private JLabel jLabelSagaFolder;
    private FileSelectionPanel jSagaFolder;
    private JLabel jLabelUpdate;
    private JButton jButtonUpdate;

    @Override
    protected void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, -1.0, 3.0}, {3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -1.0, -3.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        this.jActivateCheckBox = new JCheckBox(Sextante.getText((String)"ActivateProvider") + " SAGA GIS");
        String sActivate = SextanteGUI.getSettingParameterValue("SagaActivate");
        boolean bActivate = Boolean.parseBoolean(sActivate);
        this.jActivateCheckBox.setSelected(bActivate);
        this.add((Component)this.jActivateCheckBox, "1, 1");
        this.add((Component)new JSeparator(0), "1, 2, 2, 2");
        this.jPortableCheckBox = new JCheckBox(Sextante.getText((String)"Portable"));
        String sActivatePortable = SextanteGUI.getSettingParameterValue("SagaPortable");
        boolean bActivatePortable = Boolean.parseBoolean(sActivatePortable);
        this.jPortableCheckBox.setEnabled(bActivate);
        this.jPortableCheckBox.setSelected(bActivatePortable);
        this.add((Component)this.jPortableCheckBox, "1, 3");
        this.jLabelSagaFolder = new JLabel();
        this.jLabelSagaFolder.setEnabled(bActivate);
        if (bActivatePortable) {
            this.jLabelSagaFolder.setEnabled(false);
        }
        this.add((Component)this.jLabelSagaFolder, "1, 4");
        this.jLabelSagaFolder.setText(Sextante.getText((String)"Saga_folder"));
        this.jSagaFolder = new FileSelectionPanel(true, true, (String[])null, Sextante.getText((String)"selector_choose_folder"));
        this.jSagaFolder.getTextField().setEnabled(bActivate);
        this.jSagaFolder.getButton().setEnabled(bActivate);
        if (bActivatePortable) {
            this.jSagaFolder.getTextField().setEnabled(false);
            this.jSagaFolder.getButton().setEnabled(false);
        }
        String sFolder = SextanteGUI.getSettingParameterValue("SagaFolder");
        this.jSagaFolder.setFilepath(sFolder);
        this.add((Component)this.jSagaFolder, "2, 4");
        this.add((Component)new JSeparator(0), "1, 5, 2, 5");
        this.jLabelUpdate = new JLabel();
        this.jLabelUpdate.setText(Sextante.getText((String)"update_library"));
        this.jLabelUpdate.setEnabled(bActivate);
        this.add((Component)this.jLabelUpdate, "1, 6");
        this.jButtonUpdate = new JButton(Sextante.getText((String)"load_SAGA_modules"));
        this.jButtonUpdate.setEnabled(bActivate);
        this.add((Component)this.jButtonUpdate, "2, 6");
        URL res = this.getClass().getClassLoader().getResource("images/logo_saga.png");
        if (res != null) {
            ImageIcon logo = new ImageIcon(res);
            JLabel logoLabel = new JLabel(logo);
            logoLabel.setIconTextGap(4);
            logoLabel.setVerticalTextPosition(3);
            logoLabel.setText("<html><i><a href=http://www.saga-gis.org/>http://www.saga-gis.org/</a></i></html>");
            this.add((Component)logoLabel, "1, 8, 2, 8");
        }
        this.jActivateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SextanteSagaSettingsPanel.this.setCursor(new Cursor(3));
                SextanteGUI.setSettingParameterValue("SagaActivate", new Boolean(SextanteSagaSettingsPanel.this.jActivateCheckBox.isSelected()).toString());
                SextanteGUI.updateAlgorithmProvider(SagaAlgorithmProvider.class);
                boolean active = SextanteSagaSettingsPanel.this.jActivateCheckBox.isSelected();
                SextanteSagaSettingsPanel.this.jPortableCheckBox.setEnabled(active);
                SextanteSagaSettingsPanel.this.jLabelSagaFolder.setEnabled(active);
                SextanteSagaSettingsPanel.this.jSagaFolder.getTextField().setEnabled(active);
                SextanteSagaSettingsPanel.this.jSagaFolder.getButton().setEnabled(active);
                SextanteSagaSettingsPanel.this.jLabelUpdate.setEnabled(active);
                SextanteSagaSettingsPanel.this.jButtonUpdate.setEnabled(active);
                SextanteSagaSettingsPanel.this.jActivateCheckBox.getParent().repaint();
                active = SextanteSagaSettingsPanel.this.jPortableCheckBox.isSelected();
                if (active) {
                    SextanteSagaSettingsPanel.this.jLabelSagaFolder.setEnabled(false);
                    SextanteSagaSettingsPanel.this.jSagaFolder.getTextField().setEnabled(false);
                    SextanteSagaSettingsPanel.this.jSagaFolder.getButton().setEnabled(false);
                }
                SextanteSagaSettingsPanel.this.setCursor(new Cursor(0));
            }
        });
        this.jPortableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SextanteSagaSettingsPanel.this.setCursor(new Cursor(3));
                SextanteGUI.setSettingParameterValue("SagaPortable", new Boolean(SextanteSagaSettingsPanel.this.jPortableCheckBox.isSelected()).toString());
                SextanteGUI.checkDir(Sextante.PORTABLE_SAGA_FOLDER, true, "SAGA GIS");
                String sPath = new String(SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_SAGA_FOLDER);
                SextanteGUI.setSettingParameterValue("SagaFolder", sPath);
                SextanteSagaSettingsPanel.this.jSagaFolder.setFilepath(sPath);
                boolean active = SextanteSagaSettingsPanel.this.jPortableCheckBox.isSelected();
                if (active) {
                    SextanteSagaSettingsPanel.this.jLabelSagaFolder.setEnabled(false);
                    SextanteSagaSettingsPanel.this.jSagaFolder.getTextField().setEnabled(false);
                    SextanteSagaSettingsPanel.this.jSagaFolder.getButton().setEnabled(false);
                } else {
                    SextanteSagaSettingsPanel.this.jLabelSagaFolder.setEnabled(true);
                    SextanteSagaSettingsPanel.this.jSagaFolder.getTextField().setEnabled(true);
                    SextanteSagaSettingsPanel.this.jSagaFolder.getButton().setEnabled(true);
                }
                SextanteSagaSettingsPanel.this.setCursor(new Cursor(0));
            }
        });
        this.jButtonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SextanteGUI.setSettingParameterValue("SagaFolder", SextanteSagaSettingsPanel.this.jSagaFolder.getFilepath());
                SextanteSagaSettingsPanel.this.setupSaga();
            }
        });
    }

    protected void setupSaga() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            SagaUtils.installSaga();
            SextanteGUI.updateAlgorithmProvider(SagaAlgorithmProvider.class);
            HashMap algs2 = (HashMap)Sextante.getAlgorithms().get("SAGA");
            int iNumAlgs = 0;
            if (algs2 != null) {
                iNumAlgs = algs2.size();
            }
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"SagaAlgorithmsLoaded") + " " + iNumAlgs + ".", Sextante.getText((String)"SAGA"), 1);
        }
        catch (SagaExecutionException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"ErrorInstallingSaga"), Sextante.getText((String)"SAGA"), 0);
        }
    }

    @Override
    public HashMap<String, String> getValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SagaActivate", new Boolean(this.jActivateCheckBox.isSelected()).toString());
        map.put("SagaPortable", new Boolean(this.jPortableCheckBox.isSelected()).toString());
        String path = this.jSagaFolder.getFilepath();
        if (path != null) {
            map.put("SagaFolder", path);
        }
        return map;
    }
}

