/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.toolbox;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.gui.core.HasIcon;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class AlgorithmTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    public AlgorithmTreeCellRenderer() {
        this.setOpaque(false);
        this.setBackground(null);
    }

    protected Icon getCustomIcon(Object value) {
        ArrayList<IAlgorithmProvider> providers = SextanteGUI.getAlgorithmProviders();
        HashMap<NameAndIcon, ArrayList<ToolboxAction>> allActions = SextanteGUI.getToolboxActions();
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (obj instanceof HasIcon) {
            return ((HasIcon)obj).getIcon();
        }
        if (obj instanceof GeoAlgorithm) {
            return SextanteGUI.getAlgorithmIcon((GeoAlgorithm)obj);
        }
        if (obj instanceof ToolboxAction) {
            Set<NameAndIcon> set = allActions.keySet();
            for (NameAndIcon nai : set) {
                ArrayList<ToolboxAction> actions = allActions.get(nai);
                for (int i = 0; i < actions.size(); ++i) {
                    if (!obj.getClass().equals(actions.get(i).getClass())) continue;
                    return nai.getIcon();
                }
            }
            return null;
        }
        for (int i = 0; i < providers.size(); ++i) {
            if (!value.toString().equals(providers.get(i).getName())) continue;
            return providers.get(i).getIcon();
        }
        if (value.toString().equals("SEXTANTE")) {
            return SextanteGUI.SEXTANTE_ICON;
        }
        return null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setIcon(this.getCustomIcon(value));
        String sName = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        try {
            boolean activeAlg = false;
            if (!leaf) {
                Object[] objs = SextanteGUI.getInputFactory().getDataObjects();
                for (int i = 0; !activeAlg && i < tree.getModel().getChildCount(value); ++i) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)tree.getModel().getChild(value, i);
                    Object childValue = childNode.getUserObject();
                    if (childValue instanceof GeoAlgorithm) {
                        GeoAlgorithm alg = (GeoAlgorithm)childValue;
                        if (!alg.meetsDataRequirements(objs)) continue;
                        activeAlg = true;
                        continue;
                    }
                    if (childValue instanceof ToolboxAction) {
                        ToolboxAction ita = (ToolboxAction)childValue;
                        activeAlg = ita.isActive();
                        continue;
                    }
                    activeAlg = true;
                }
                this.setText("<html><b><font size=\"-1\">" + sName + "</font></b></html>");
            } else {
                Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                if (obj instanceof ToolboxAction) {
                    ToolboxAction ita = (ToolboxAction)obj;
                    activeAlg = ita.isActive();
                } else {
                    GeoAlgorithm alg = (GeoAlgorithm)obj;
                    Object[] objs = SextanteGUI.getInputFactory().getDataObjects();
                    activeAlg = alg.meetsDataRequirements(objs);
                }
                this.setText("<html><font size=\"-1\">" + sName + "</font></html>");
            }
            if (sel) {
                if (!activeAlg) {
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                } else {
                    this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                }
            } else if (!activeAlg) {
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            } else {
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
        }
        catch (Throwable e) {
            this.setForeground(UIManager.getColor("Label.disabledForeground"));
        }
        return this;
    }
}

