/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.toolbox;

import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.IGeoAlgorithmFilter;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.core.GeoAlgorithmExecutors;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.history.History;
import es.unex.sextante.gui.toolbox.AlgorithmGroupConfiguration;
import es.unex.sextante.gui.toolbox.AlgorithmGroupsOrganizer;
import es.unex.sextante.gui.toolbox.AlgorithmTreeCellRenderer;
import es.unex.sextante.gui.toolbox.IToolboxDialog;
import es.unex.sextante.gui.toolbox.OutputRenderingSettingsDialog;
import es.unex.sextante.gui.toolbox.TransparentScrollPane;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;

public class AlgorithmsPanel
extends JPanel {
    private static final int EXECUTE_ITERATIVE_MENU_COUNT = 20;
    public static final String ACCESS_GEOPROCESS_AUTHORIZATION = "access-geoprocess";
    public static Font TREE_FONT = new Font("Tahoma", 1, 11);
    protected JTree jTree;
    private TransparentScrollPane jScrollPane;
    private JMenuItem menuItemExecute;
    private JMenuItem menuItemExecuteAsBatch;
    private JMenuItem menuItemExecuteAsBatchFromGIS;
    private JMenuItem[] menuItemExecuteIterative;
    private JMenuItem menuItemShowHelp;
    private JCheckBoxMenuItem menuItemShowOnlyActive;
    private JPopupMenu popupMenu;
    private TreePath m_Path;
    private GeoAlgorithm m_Alg;
    protected final IToolboxDialog m_ParentDialog;
    protected IGeoAlgorithmFilter m_Filter;
    private final ImageIcon m_BackgroundImg;
    protected String m_sLastSearchString = "";
    private int m_iExecuteIterativeMenuCount;
    protected boolean m_bLastSearchIncludedHelpFiles;
    private ToolboxAction m_Action;
    private JMenuItem[] menuItemToolboxAction;
    private JMenuItem menuItemSetOutputRendering;

    public AlgorithmsPanel(IToolboxDialog parentDialog, IGeoAlgorithmFilter filter, ImageIcon img) {
        this.m_BackgroundImg = img;
        this.m_ParentDialog = parentDialog;
        this.m_Filter = filter;
        if (this.m_Filter == null) {
            this.m_Filter = new IGeoAlgorithmFilter(){

                public boolean accept(GeoAlgorithm alg) {
                    if (SextanteGUI.getShowOnlyActiveAlgorithms()) {
                        Object[] objs = SextanteGUI.getInputFactory().getDataObjects();
                        return alg.meetsDataRequirements(objs);
                    }
                    return true;
                }
            };
        }
        this.init();
    }

    private void updateSelectedAlgorithm() {
        this.m_Alg = null;
        this.m_Action = null;
        if (this.m_Path != null) {
            this.menuItemExecuteAsBatch.setVisible(false);
            this.menuItemExecuteAsBatchFromGIS.setVisible(false);
            this.menuItemExecute.setVisible(false);
            this.menuItemShowHelp.setVisible(false);
            for (int i = 0; i < this.menuItemExecuteIterative.length; ++i) {
                this.menuItemExecuteIterative[i].setVisible(false);
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
            if (!(node.getUserObject() instanceof GeoAlgorithm)) {
                if (node.getUserObject() instanceof ToolboxAction) {
                    this.m_Action = (ToolboxAction)node.getUserObject();
                }
                return;
            }
            this.m_Alg = (GeoAlgorithm)node.getUserObject();
            this.menuItemExecuteAsBatch.setVisible(true);
            this.menuItemShowHelp.setVisible(true);
            this.menuItemExecute.setVisible(true);
            Object[] objs = SextanteGUI.getInputFactory().getDataObjects();
            this.menuItemExecuteAsBatchFromGIS.setVisible(true);
            boolean bMeets = this.m_Alg.meetsDataRequirements(objs);
            this.menuItemExecuteAsBatchFromGIS.setEnabled(bMeets);
            this.menuItemExecute.setEnabled(bMeets);
            IToolboxRightButtonAction[] actions = SextanteGUI.getToolboxRightButtonActions();
            for (int i = 0; i < this.menuItemToolboxAction.length; ++i) {
                this.menuItemToolboxAction[i].setVisible(actions[i].canBeExecutedOnAlgorithm(this.m_Alg));
            }
            if (bMeets && this.m_Alg.requiresIndividualVectorLayers()) {
                this.m_iExecuteIterativeMenuCount = 0;
                int iParams = this.m_Alg.getParameters().getNumberOfParameters();
                for (int i = 0; i < iParams; ++i) {
                    Parameter param = this.m_Alg.getParameters().getParameter(i);
                    if (!(param instanceof ParameterVectorLayer)) continue;
                    ParameterVectorLayer pvl = (ParameterVectorLayer)param;
                    try {
                        boolean bMandatory = ((AdditionalInfoVectorLayer)pvl.getParameterAdditionalInfo()).getIsMandatory();
                        if (!bMandatory) continue;
                        this.menuItemExecuteIterative[this.m_iExecuteIterativeMenuCount].setText(Sextante.getText((String)"Run_iterative") + " (" + param.getParameterDescription() + ")");
                        this.menuItemExecuteIterative[this.m_iExecuteIterativeMenuCount].setVisible(true);
                        ++this.m_iExecuteIterativeMenuCount;
                        continue;
                    }
                    catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void init() {
        this.m_iExecuteIterativeMenuCount = 0;
        this.setPreferredSize(new Dimension(350, 380));
        this.setSize(new Dimension(350, 380));
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.jTree = new JTree();
        this.jTree.setOpaque(false);
        this.jTree.setCellRenderer(new AlgorithmTreeCellRenderer());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AlgorithmsPanel.this.m_Alg = null;
                AlgorithmsPanel.this.m_Action = null;
                AlgorithmsPanel.this.menuItemExecute.setVisible(false);
                AlgorithmsPanel.this.menuItemExecuteAsBatch.setVisible(false);
                for (int i = 0; i < 20; ++i) {
                    AlgorithmsPanel.this.menuItemExecuteIterative[i].setVisible(false);
                }
                for (int j = 0; j < AlgorithmsPanel.this.menuItemToolboxAction.length; ++j) {
                    AlgorithmsPanel.this.menuItemToolboxAction[j].setVisible(false);
                }
                AlgorithmsPanel.this.menuItemExecuteAsBatchFromGIS.setVisible(false);
                AlgorithmsPanel.this.menuItemShowHelp.setVisible(false);
                AlgorithmsPanel.this.m_Path = AlgorithmsPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                AlgorithmsPanel.this.updateSelectedAlgorithm();
                SextanteGUI.getInputFactory().createDataObjects();
                if (e.getButton() == 1) {
                    if (e.getClickCount() == 2) {
                        AlgorithmsPanel.this.executeSelectedAlgorithm();
                    }
                } else if (e.getButton() == 3) {
                    AlgorithmsPanel.this.showPopupMenu(e);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        this.jTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    AlgorithmsPanel.this.executeSelectedAlgorithm();
                }
                if (e.getKeyChar() == ' ') {
                    AlgorithmsPanel.this.showPopupMenu(e);
                }
            }
        });
        this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AlgorithmsPanel.this.m_Path = e.getPath();
                AlgorithmsPanel.this.updateSelectedAlgorithm();
            }
        });
        this.jScrollPane = new TransparentScrollPane(this.jTree);
        this.jScrollPane.setSize(new Dimension(350, 380));
        if (this.m_BackgroundImg != null) {
            this.jScrollPane.setBackgroundImage(this.m_BackgroundImg);
        }
        this.add((Component)this.jScrollPane, "Center");
        this.popupMenu = new JPopupMenu("Menu");
        this.menuItemExecute = new JMenuItem(Sextante.getText((String)"Run"));
        this.menuItemExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.executeSelectedAlgorithm();
            }
        });
        this.popupMenu.add(this.menuItemExecute);
        this.menuItemExecuteIterative = new JMenuItem[20];
        for (int i = 0; i < this.menuItemExecuteIterative.length; ++i) {
            final int iParameter = i;
            this.menuItemExecuteIterative[i] = new JMenuItem();
            this.menuItemExecuteIterative[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AlgorithmsPanel.this.executeSelectedAlgorithmIteratively(iParameter);
                }
            });
            this.popupMenu.add(this.menuItemExecuteIterative[i]);
        }
        IToolboxRightButtonAction[] actions = SextanteGUI.getToolboxRightButtonActions();
        this.menuItemToolboxAction = new JMenuItem[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            final IToolboxRightButtonAction action = actions[i];
            this.menuItemToolboxAction[i] = new JMenuItem();
            this.menuItemToolboxAction[i].setText(action.getDescription());
            this.menuItemToolboxAction[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    action.execute(AlgorithmsPanel.this.m_Alg);
                }
            });
            this.popupMenu.add(this.menuItemToolboxAction[i]);
        }
        this.menuItemExecuteAsBatch = new JMenuItem(Sextante.getText((String)"Execute_as_batch_process"));
        this.menuItemExecuteAsBatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.executeAsBatch();
            }
        });
        this.popupMenu.add(this.menuItemExecuteAsBatch);
        this.menuItemExecuteAsBatchFromGIS = new JMenuItem(Sextante.getText((String)"Execute_as_batch_process__using_layers_from_GIS_app"));
        this.menuItemExecuteAsBatchFromGIS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.executeAsBatchInGIS();
            }
        });
        this.popupMenu.add(this.menuItemExecuteAsBatchFromGIS);
        this.popupMenu.addSeparator();
        this.menuItemSetOutputRendering = new JMenuItem(Sextante.getText((String)"set_output_rendering"));
        this.menuItemSetOutputRendering.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.setOutputRendering();
            }
        });
        this.popupMenu.add(this.menuItemSetOutputRendering);
        this.popupMenu.addSeparator();
        JMenuItem menuItemExpand = new JMenuItem(Sextante.getText((String)"Expand_all"));
        menuItemExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.expandAll();
            }
        });
        this.popupMenu.add(menuItemExpand);
        JMenuItem menuItemCollapse = new JMenuItem(Sextante.getText((String)"Collapse_all"));
        menuItemCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.collapseAll();
            }
        });
        this.popupMenu.add(menuItemCollapse);
        this.menuItemShowOnlyActive = new JCheckBoxMenuItem(Sextante.getText((String)"Show_active_only"));
        this.menuItemShowOnlyActive.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SextanteGUI.setShowOnlyActiveAlgorithms(e.getStateChange() == 1);
                AlgorithmsPanel.this.fillTree(AlgorithmsPanel.this.m_sLastSearchString, AlgorithmsPanel.this.m_bLastSearchIncludedHelpFiles);
                AlgorithmsPanel.this.collapseAll();
            }
        });
        this.menuItemShowOnlyActive.setSelected(SextanteGUI.getShowOnlyActiveAlgorithms());
        this.popupMenu.add(this.menuItemShowOnlyActive);
        this.popupMenu.addSeparator();
        this.menuItemShowHelp = new JMenuItem(Sextante.getText((String)"Show_help"));
        this.menuItemShowHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmsPanel.this.showHelp();
            }
        });
        this.popupMenu.add(this.menuItemShowHelp);
    }

    protected void setOutputRendering() {
        if (this.m_Alg != null) {
            OutputRenderingSettingsDialog dialog = new OutputRenderingSettingsDialog(this.m_Alg);
            dialog.setVisible(true);
            HashMap<String, Object> set = dialog.getSettings();
            if (set != null) {
                SextanteGUI.getDataRenderer().setRenderingForAlgorithm(this.m_Alg.getCommandLineName(), set);
                SextanteGUI.getDataRenderer().save();
            }
        }
    }

    protected void showHelp() {
        if (this.m_Alg != null) {
            SextanteGUI.getGUIFactory().showHelpDialog(this.m_Alg);
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        this.jTree.setSelectionPath(this.m_Path);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void showPopupMenu(KeyEvent e) {
        this.jTree.setSelectionPath(this.m_Path);
        Rectangle pathBounds = this.jTree.getPathBounds(this.m_Path);
        this.popupMenu.show(e.getComponent(), pathBounds.x, pathBounds.y);
    }

    public void collapseAll() {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        TreePath path = new TreePath(root);
        this.expandAll(this.jTree, path, false);
        this.jTree.expandPath(path);
        int iChildCount = root.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeNode node = root.getChildAt(i);
            TreePath subpath = path.pathByAddingChild(node);
            this.jTree.expandPath(subpath);
        }
    }

    public void expandAll() {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        this.expandAll(this.jTree, new TreePath(root), true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void executeAsBatch() {
        if (this.m_Alg != null) {
            SextanteGUI.getGUIFactory().showBatchProcessingDialog(this.m_Alg, this.m_ParentDialog.getDialog());
        }
    }

    protected void executeAsBatchInGIS() {
        if (this.m_Alg != null) {
            SextanteGUI.getGUIFactory().showBatchProcessingFromGISDialog(this.m_Alg, this.m_ParentDialog.getDialog());
        }
    }

    protected void executeSelectedAlgorithm() {
        try {
            if (this.m_Alg != null) {
                GeoAlgorithm alg = this.m_Alg.getNewInstance();
                int iRet = SextanteGUI.getGUIFactory().showAlgorithmDialog(alg, this.m_ParentDialog.getDialog(), null);
                if (iRet == 1) {
                    String[] cmd = alg.getAlgorithmAsCommandLineSentences();
                    if (cmd != null) {
                        History.addToHistory(cmd);
                    }
                    GeoAlgorithmExecutors.execute(alg, this.m_ParentDialog.getDialog());
                    this.updateListOfMostRecentAlgorithms();
                }
            } else if (this.m_Action != null) {
                this.m_Action.execute();
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void updateListOfMostRecentAlgorithms() {
        boolean bShowMostRecent = new Boolean(SextanteGUI.getSettingParameterValue("ShowMostRecent"));
        if (bShowMostRecent) {
            GeoAlgorithm[] recent = History.getRecentlyUsedAlgs();
            DefaultMutableTreeNode recentNode = new DefaultMutableTreeNode(Sextante.getText((String)"RecentAlgorithms"));
            for (int i = 0; i < recent.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(recent[i]);
                recentNode.add(node);
            }
            DefaultMutableTreeNode mainNode = (DefaultMutableTreeNode)new TreePath(this.jTree.getModel().getRoot()).getLastPathComponent();
            mainNode.remove(0);
            mainNode.insert(recentNode, 0);
        }
    }

    protected void executeSelectedAlgorithmIteratively(int iParameterToIterateOver) {
        block4: {
            try {
                if (this.m_Alg == null) break block4;
                GeoAlgorithm alg = this.m_Alg.getNewInstance();
                int iRet = SextanteGUI.getGUIFactory().showAlgorithmDialog(alg, this.m_ParentDialog.getDialog(), null);
                if (iRet != 1) break block4;
                ParametersSet params = this.m_Alg.getParameters();
                int iParamCount = params.getNumberOfParameters();
                int iVectorLayers = 0;
                for (int i = 0; i < iParamCount; ++i) {
                    Parameter param = this.m_Alg.getParameters().getParameter(i);
                    if (!(param instanceof ParameterVectorLayer)) continue;
                    if (iVectorLayers == iParameterToIterateOver) {
                        GeoAlgorithmExecutors.executeIterative(alg, this.m_ParentDialog.getDialog(), param.getParameterName());
                        break;
                    }
                    ++iVectorLayers;
                }
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    public GeoAlgorithm getSelectedAlgorithm() {
        return this.m_Alg;
    }

    public int fillTree(String sSearchString, boolean bSearchInHelpFiles) {
        String sSubgroup;
        this.m_sLastSearchString = sSearchString;
        this.m_bLastSearchIncludedHelpFiles = bSearchInHelpFiles;
        SimpleIdentity user = ToolsLocator.getIdentityManager().getCurrentIdentity();
        int iCount = 0;
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Algorithms"));
        HashMap groups = new HashMap();
        this.setCursor(new Cursor(3));
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        HashMap algs2 = Sextante.getAlgorithms();
        Set groupKeys = algs2.keySet();
        for (String groupKey : groupKeys) {
            HashMap groupAlgs = (HashMap)algs2.get(groupKey);
            Set keys = groupAlgs.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                HashMap<String, DefaultMutableTreeNode> subgroup;
                String sGroup;
                GeoAlgorithm alg = (GeoAlgorithm)groupAlgs.get(iter.next());
                if (!identityManager.getCurrentIdentity().isAuthorized(ACCESS_GEOPROCESS_AUTHORIZATION, (Object)alg, alg.getCommandLineName()) || !this.m_Filter.accept(alg) || (bSearchInHelpFiles ? !HelpIO.containsStringInHelpFile(alg, sSearchString) : sSearchString != null && !alg.getName().toLowerCase().contains(sSearchString))) continue;
                ++iCount;
                AlgorithmGroupConfiguration conf = AlgorithmGroupsOrganizer.getGroupConfiguration(alg);
                if (conf != null) {
                    if (!conf.isShow()) continue;
                    sGroup = conf.getGroup();
                    sSubgroup = conf.getSubgroup();
                } else {
                    sGroup = groupKey;
                    sSubgroup = alg.getGroup();
                }
                HashMap<String, HashMap<String, DefaultMutableTreeNode>> group = (HashMap<String, HashMap<String, DefaultMutableTreeNode>>)groups.get(sGroup);
                if (group == null) {
                    group = new HashMap<String, HashMap<String, DefaultMutableTreeNode>>();
                    groups.put(sGroup, group);
                }
                if ((subgroup = (HashMap<String, DefaultMutableTreeNode>)group.get(sSubgroup)) == null) {
                    subgroup = new HashMap<String, DefaultMutableTreeNode>();
                    group.put(sSubgroup, subgroup);
                }
                subgroup.put(alg.getName(), new DefaultMutableTreeNode(alg));
            }
        }
        HashMap<NameAndIcon, ArrayList<ToolboxAction>> allActions = SextanteGUI.getToolboxActions();
        Set<NameAndIcon> actionsKeys = allActions.keySet();
        for (NameAndIcon nai : actionsKeys) {
            ArrayList<ToolboxAction> actions = allActions.get(nai);
            for (int i = 0; i < actions.size(); ++i) {
                HashMap<String, DefaultMutableTreeNode> subgroup;
                ToolboxAction ita = actions.get(i);
                if (!user.isAuthorized(ACCESS_GEOPROCESS_AUTHORIZATION, (Object)ita, ita.getName()) || sSearchString != null && !ita.getName().toLowerCase().contains(sSearchString)) continue;
                ++iCount;
                sSubgroup = ita.getGroup();
                HashMap<String, HashMap<String, DefaultMutableTreeNode>> group = (HashMap<String, HashMap<String, DefaultMutableTreeNode>>)groups.get(nai.getName());
                if (group == null) {
                    group = (HashMap)groups.get(nai);
                }
                if (group == null) {
                    group = new HashMap<String, HashMap<String, DefaultMutableTreeNode>>();
                    groups.put(nai, group);
                }
                if ((subgroup = (HashMap<String, DefaultMutableTreeNode>)group.get(sSubgroup)) == null) {
                    subgroup = new HashMap<String, DefaultMutableTreeNode>();
                    group.put(sSubgroup, subgroup);
                }
                subgroup.put(ita.getName(), new DefaultMutableTreeNode(ita));
            }
        }
        Set set = groups.keySet();
        for (Object key : set) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key);
            this.addNodeInSortedOrder(mainNode, node);
            HashMap g = (HashMap)groups.get(key);
            Set set2 = g.keySet();
            for (String sKey2 : set2) {
                DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(sKey2);
                this.addNodeInSortedOrder(node, node2);
                HashMap g2 = (HashMap)g.get(sKey2);
                Set set3 = g2.keySet();
                for (String sKey3 : set3) {
                    DefaultMutableTreeNode node3 = (DefaultMutableTreeNode)g2.get(sKey3);
                    this.addNodeInSortedOrder(node2, node3);
                }
            }
        }
        boolean bShowMostRecent = new Boolean(SextanteGUI.getSettingParameterValue("ShowMostRecent"));
        if (bShowMostRecent) {
            GeoAlgorithm[] recent = History.getRecentlyUsedAlgs();
            DefaultMutableTreeNode recentNode = new DefaultMutableTreeNode(Sextante.getText((String)"RecentAlgorithms"));
            for (int i = 0; i < recent.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(recent[i]);
                recentNode.add(node);
            }
            mainNode.insert(recentNode, 0);
        }
        this.setCursor(new Cursor(0));
        this.jTree.setModel(new DefaultTreeModel(mainNode));
        if (sSearchString != null) {
            this.expandAll();
        }
        this.m_ParentDialog.setAlgorithmsCount(iCount);
        return iCount;
    }

    private void addNodeInSortedOrder(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int n = parent.getChildCount();
        if (n == 0) {
            parent.add(child);
            return;
        }
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < n; ++i) {
            node = (DefaultMutableTreeNode)parent.getChildAt(i);
            try {
                if (collator.compare(node.toString(), child.toString()) <= 0) continue;
                parent.insert(child, i);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        parent.add(child);
    }
}

