/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.toolbox;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.toolbox.ToolboxPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextSearchPanel
extends JPanel {
    private final ToolboxPanel m_Panel;
    private JButton jButtonSearch;
    private JTextField jTextField;
    private JButton jButtonHelp;
    private JButton jButtonSettings;
    private final JDialog m_Parent;

    public TextSearchPanel(ToolboxPanel panel, JDialog parent) {
        this.m_Panel = panel;
        this.m_Parent = parent;
        this.initGUI();
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{7.0, -3.0, -1.0, 10.0, -3.0, -3.0, 7.0}, {-1.0, -3.0, -1.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.setLayout((LayoutManager)thisLayout);
            this.jButtonHelp = new JButton();
            this.add((Component)this.jButtonHelp, "4, 1");
            this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/info.gif")));
            this.jButtonHelp.setPreferredSize(new Dimension(20, 20));
            this.jButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TextSearchPanel.this.showHelp();
                }
            });
            this.jButtonSettings = new JButton();
            this.add((Component)this.jButtonSettings, "5, 1");
            this.jButtonSettings.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/config.png")));
            this.jButtonSettings.setPreferredSize(new Dimension(20, 20));
            this.jButtonSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TextSearchPanel.this.showSettings(evt);
                }
            });
            this.jTextField = new JTextField();
            this.add((Component)this.jTextField, "2, 1");
            this.jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent event) {
                    TextSearchPanel.this.processKeyPresssed(event);
                }
            });
            this.jButtonSearch = new JButton();
            this.add((Component)this.jButtonSearch, "1, 1");
            this.jButtonSearch.setText(Sextante.getText((String)"Search"));
            this.jButtonSearch.setPreferredSize(new Dimension(66, 20));
            this.jButtonSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String sString = TextSearchPanel.this.escape(TextSearchPanel.this.jTextField.getText().trim().toLowerCase());
                    TextSearchPanel.this.searchString(sString, true);
                }
            });
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void processKeyPresssed(KeyEvent event) {
        switch (event.getKeyChar()) {
            case '\n': {
                String sString = this.escape(this.jTextField.getText().trim().toLowerCase());
                this.searchString(sString, true);
                break;
            }
            default: {
                String sString = this.jTextField.getText() + event.getKeyChar();
                sString = this.escape(sString.trim().toLowerCase());
                this.searchString(sString, false);
            }
        }
    }

    protected void showSettings(ActionEvent evt) {
        SextanteGUI.getGUIFactory().showSettingsDialog(this.m_Panel, this.m_Parent);
    }

    protected void showHelp() {
        SextanteGUI.getGUIFactory().showHelpDialog("toolbox");
    }

    protected void searchString(String sString, boolean bSearchInHelpFiles) {
        if (sString.equals("")) {
            this.m_Panel.fillTreesWithAllAlgorithms();
        } else {
            this.m_Panel.fillTreesWithSelectedAlgorithms(sString, bSearchInHelpFiles);
        }
    }

    private StringWriter createStringWriter(String str) {
        return new StringWriter((int)((double)str.length() + (double)str.length() * 0.1));
    }

    private String escape(String str) {
        StringWriter stringWriter = this.createStringWriter(str);
        try {
            this.escape(stringWriter, str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void escape(Writer writer, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c > '\u007f') {
                writer.write("&#");
                writer.write(Integer.toString(c, 10));
                writer.write(59);
                continue;
            }
            writer.write(c);
        }
    }
}

