/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.swipe.app.mainplugin;

import java.awt.Dimension;
import java.util.Collections;
import javax.swing.JComponent;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.swipe.app.mainplugin.SwipeSwingServicesImpl;
import org.gvsig.swipe.swing.SwipePanel;
import org.gvsig.swipe.swing.SwipeSwingLocator;
import org.gvsig.swipe.swing.SwipeSwingManager;
import org.gvsig.swipe.swing.SwipeSwingServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class SwipeExtension
extends Extension {
    public void initialize() {
    }

    public void postInitialize() {
        SwipeSwingManager swingManager = SwipeSwingLocator.getSwipeSwingManager();
        swingManager.setDefaultServices((SwipeSwingServices)new SwipeSwingServicesImpl());
    }

    public void execute(String action) {
        if (action == null) {
            return;
        }
        switch (action) {
            case "tools-swipe-horizontalswipe": {
                this.horizontalSwipe();
                return;
            }
            case "tools-swipe-verticalswipe": {
                this.verticalSwipe();
                return;
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void horizontalSwipe() {
        SwipeSwingManager swipeSwingManager = SwipeSwingLocator.getSwipeSwingManager();
        SwipePanel panel = swipeSwingManager.createHorizontalSwipePanel();
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)panel.asJComponent(), (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        this.showSwipePanel(panel, "_Swipe_Horizontal_swipe");
    }

    private void verticalSwipe() {
        SwipeSwingManager swipeSwingManager = SwipeSwingLocator.getSwipeSwingManager();
        SwipePanel panel = swipeSwingManager.createVerticalSwipePanel();
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)panel.asJComponent(), (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        this.showSwipePanel(panel, "_Swipe_Vertical_swipe");
    }

    private void showSwipePanel(SwipePanel panel, String title) {
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        windowManager.showWindow(panel.asJComponent(), i18n.getTranslation(title), WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }
}

