/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.geom.AffineTransform;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.georeferencing.app.georeferencingclient.Georeferencing;
import org.gvsig.raster.georeferencing.swing.GeoreferencingLauncher;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLocator;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingManager;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.basepanel.ButtonsPanelEvent;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;

public class LauncherDialogListener
implements ButtonsPanelListener {
    private GeoreferencingLauncher launcherDialog = null;
    private Georeferencing app = null;

    public LauncherDialogListener(Georeferencing app, GeoreferencingLauncher launcher) {
        this.launcherDialog = launcher;
        this.app = app;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 1 && this.launcherDialog != null) {
            RasterDataStore storeToGeoref;
            this.launcherDialog.buildDataModel();
            GeoreferencingOptionsDataModel dataModel = GeoreferencingSwingLocator.getSwingManager().getDataModel();
            if (dataModel.getType() == 0) {
                boolean findView = false;
                IWindow[] windowList = PluginServices.getMDIManager().getAllWindows();
                for (int i = 0; i < windowList.length; ++i) {
                    if (!(windowList[i] instanceof IView) || !windowList[i].getWindowInfo().getTitle().endsWith(": " + dataModel.getSelectedView())) continue;
                    findView = true;
                    break;
                }
                if (!findView) {
                    RasterSwingLibrary.messageBoxError((String)"no_view_found", (Object)this);
                    return;
                }
            }
            if ((storeToGeoref = dataModel.getDataStore()) == null) {
                RasterSwingLibrary.messageBoxError((String)"layer_not_loaded", (Object)this);
            } else {
                storeToGeoref.setAffineTransform(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, storeToGeoref.getHeight()));
                GeoreferencingSwingManager sManager = GeoreferencingSwingLocator.getSwingManager();
                sManager.closeWindow(this.launcherDialog.getComponent());
                this.app.endLauncherDialog(dataModel);
            }
        }
        if (e.getButton() == 2) {
            GeoreferencingSwingManager sManager = GeoreferencingSwingLocator.getSwingManager();
            sManager.closeWindow(this.launcherDialog.getComponent());
        }
    }
}

