/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.app;

import java.util.ArrayList;
import java.util.HashMap;
import org.gvsig.andami.PluginServices;
import org.gvsig.raster.fmap.layers.IConfiguration;
import org.gvsig.raster.tilecache.app.ConfigurationEvent;
import org.gvsig.raster.tilecache.app.ConfigurationListener;
import org.gvsig.utils.XMLEntity;

public class Configuration
implements IConfiguration {
    private static Configuration singleton = new Configuration();
    private ArrayList<ConfigurationListener> actionCommandListeners = new ArrayList();
    private XMLEntity xml = null;
    private HashMap<String, Object> hashMap = new HashMap();

    private Configuration() {
        try {
            PluginServices ps = PluginServices.getPluginServices((String)"org.gvsig.raster.tilecache.app");
            this.xml = ps.getPersistentXML();
        }
        catch (NullPointerException e) {
            this.xml = new XMLEntity();
        }
    }

    public static Boolean getValue(String key, Boolean defaultValue) {
        singleton.saveDefaultValue(key, defaultValue);
        try {
            return Boolean.valueOf(Configuration.getXMLEntity().getStringProperty(key));
        }
        catch (Exception exception) {
            try {
                Configuration.getXMLEntity().putProperty(key, defaultValue.booleanValue());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return defaultValue;
        }
    }

    public static Double getValue(String key, Double defaultValue) {
        singleton.saveDefaultValue(key, defaultValue);
        try {
            return Double.valueOf(Configuration.getXMLEntity().getStringProperty(key));
        }
        catch (Exception exception) {
            Configuration.getXMLEntity().putProperty(key, defaultValue.doubleValue());
            return defaultValue;
        }
    }

    public static Float getValue(String key, Float defaultValue) {
        singleton.saveDefaultValue(key, defaultValue);
        try {
            return Float.valueOf(Configuration.getXMLEntity().getStringProperty(key));
        }
        catch (Exception exception) {
            Configuration.getXMLEntity().putProperty(key, defaultValue.floatValue());
            return defaultValue;
        }
    }

    public static Integer getValue(String key, Integer defaultValue) {
        singleton.saveDefaultValue(key, defaultValue);
        try {
            return Integer.valueOf(Configuration.getXMLEntity().getStringProperty(key));
        }
        catch (Exception exception) {
            Configuration.getXMLEntity().putProperty(key, defaultValue.intValue());
            return defaultValue;
        }
    }

    public static Long getValue(String key, Long defaultValue) {
        singleton.saveDefaultValue(key, defaultValue);
        try {
            return Long.valueOf(Configuration.getXMLEntity().getStringProperty(key));
        }
        catch (Exception exception) {
            Configuration.getXMLEntity().putProperty(key, defaultValue.longValue());
            return defaultValue;
        }
    }

    public static String getValue(String key, String defaultValue) {
        singleton.saveDefaultValue(key, defaultValue);
        try {
            return Configuration.getXMLEntity().getStringProperty(key);
        }
        catch (Exception exception) {
            Configuration.getXMLEntity().putProperty(key, defaultValue);
            return defaultValue;
        }
    }

    private void saveDefaultValue(String key, Object defaultValue) {
        if (this.hashMap.get(key) == null) {
            this.hashMap.put(key, defaultValue);
        }
    }

    public static Object getDefaultValue(String key) {
        return Configuration.singleton.hashMap.get(key);
    }

    private void putProperty(String key, Object value) {
        if (Integer.class.isInstance(value)) {
            Configuration.getXMLEntity().putProperty(key, ((Integer)value).intValue());
            return;
        }
        if (Double.class.isInstance(value)) {
            Configuration.getXMLEntity().putProperty(key, ((Double)value).doubleValue());
            return;
        }
        if (Float.class.isInstance(value)) {
            Configuration.getXMLEntity().putProperty(key, ((Float)value).floatValue());
            return;
        }
        if (Boolean.class.isInstance(value)) {
            Configuration.getXMLEntity().putProperty(key, ((Boolean)value).booleanValue());
            return;
        }
        if (Long.class.isInstance(value)) {
            Configuration.getXMLEntity().putProperty(key, ((Long)value).longValue());
            return;
        }
        if (String.class.isInstance(value)) {
            Configuration.getXMLEntity().putProperty(key, (String)value);
            return;
        }
        Configuration.getXMLEntity().putProperty(key, value);
    }

    public static void setValue(String key, Object value) {
        if (value == null) {
            Configuration.getXMLEntity().remove(key);
            singleton.callConfigurationChanged(key, value);
            return;
        }
        String oldValue = Configuration.getValue(key, value.toString());
        singleton.putProperty(key, value);
        if (!oldValue.equals(value.toString())) {
            singleton.callConfigurationChanged(key, value);
        }
    }

    public static void addValueChangedListener(ConfigurationListener listener) {
        if (!Configuration.singleton.actionCommandListeners.contains(listener)) {
            Configuration.singleton.actionCommandListeners.add(listener);
        }
    }

    public static void removeValueChangedListener(ConfigurationListener listener) {
        Configuration.singleton.actionCommandListeners.remove(listener);
    }

    private void callConfigurationChanged(String key, Object value) {
        for (ConfigurationListener listener : this.actionCommandListeners) {
            listener.actionConfigurationChanged(new ConfigurationEvent(this, key, value));
        }
    }

    private static XMLEntity getXMLEntity() {
        return Configuration.singleton.xml;
    }

    public static Configuration getSingleton() {
        return singleton;
    }

    public Boolean getValueBoolean(String name, Boolean defaultValue) {
        return Configuration.getValue(name, defaultValue);
    }

    public String getValueString(String name, String defaultValue) {
        return Configuration.getValue(name, defaultValue);
    }

    public Double getValueDouble(String name, Double defaultValue) {
        return Configuration.getValue(name, defaultValue);
    }

    public Float getValueFloat(String name, Float defaultValue) {
        return Configuration.getValue(name, defaultValue);
    }

    public Integer getValueInteger(String name, Integer defaultValue) {
        return Configuration.getValue(name, defaultValue);
    }

    public Long getValueLong(String name, Long defaultValue) {
        return Configuration.getValue(name, defaultValue);
    }
}

