/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.app;

import java.awt.Component;
import java.util.Map;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.app.prepareAction.PrepareContextView;
import org.gvsig.app.prepareAction.PrepareDataStoreParameters;
import org.gvsig.app.prepareAction.PrepareLayer;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.tools.exception.BaseException;

public class PrepareLayerAskUsingTiles
implements PrepareDataStoreParameters,
PrepareLayer {
    private boolean askMe = true;
    private boolean answer = false;

    public DataStoreParameters prepare(DataStoreParameters storeParameters, PrepareContext context) throws BaseException {
        if (!(storeParameters instanceof RasterDataParameters)) {
            return storeParameters;
        }
        if (this.askMe) {
            String file = null;
            if (storeParameters instanceof AbstractRasterFileDataParameters) {
                file = ((AbstractRasterFileDataParameters)storeParameters).getFile().getName();
            }
            this.messageBoxYesOrNot("tiled_layer2", file);
        }
        if (this.answer) {
            DataManager manager = DALLocator.getDataManager();
            TileDataParameters tileParams = null;
            tileParams = (TileDataParameters)manager.createStoreParameters("Tile Store");
            ((FilesystemStoreParameters)tileParams).setFile(((FilesystemStoreParameters)storeParameters).getFile());
            tileParams.setDataParameters((DataParameters)storeParameters);
            return tileParams;
        }
        return storeParameters;
    }

    public void post(DataStoreParameters storeParameters, PrepareContext context) {
        this.askMe = true;
    }

    public void pre(DataStoreParameters storeParameters, PrepareContext context) {
    }

    public boolean askMe() {
        return this.askMe;
    }

    public void setAskMe(boolean askMe) {
        this.askMe = askMe;
    }

    public FLayer prepare(FLayer layer, PrepareContextView context) {
        FLyrRaster lyrRaster;
        if (layer instanceof FLyrRaster && (lyrRaster = (FLyrRaster)layer).getDataStore().getParameters() instanceof TileDataParameters && lyrRaster.getFullEnvelope().getMinimum(0) == 0.0 && lyrRaster.getFullEnvelope().getMinimum(1) == 0.0 && lyrRaster.getFullEnvelope().getMaximum(0) == lyrRaster.getDataStore().getWidth() && lyrRaster.getFullEnvelope().getMaximum(1) == lyrRaster.getDataStore().getHeight()) {
            MapContextManager mcm = MapContextLocator.getMapContextManager();
            try {
                DefaultFLyrRaster newLayer = (DefaultFLyrRaster)mcm.createLayer(lyrRaster.getName(), (DataStoreParameters)((TileDataParameters)lyrRaster.getDataStore().getParameters()).getDataParameters());
                lyrRaster.getDataStore().close();
                return newLayer;
            }
            catch (LoadLayerException e) {
                return lyrRaster;
            }
            catch (CloseException closeException) {
                // empty catch block
            }
        }
        return layer;
    }

    public void end(Object param) {
    }

    public String getDescription() {
        return "Prepare Tiles for Raster Layer";
    }

    public String getName() {
        return "PrepareRasterLayerAskUsingTiles";
    }

    public Object create() {
        return this;
    }

    public Object create(Object[] args) {
        return this;
    }

    public Object create(Map args) {
        return this;
    }

    public void interrupted() {
    }

    public void messageBoxYesOrNot(String msg, String file) {
        String string1 = Messages.getText((String)"tiled");
        String string2 = Messages.getText((String)"normally");
        String string3 = Messages.getText((String)"all_tiled");
        String string4 = Messages.getText((String)"all_normally");
        Object[] options = new Object[]{string1, string2, string3, string4};
        int n = JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), "<html>" + Messages.getText((String)msg).replaceAll("\n", "<br>") + "<br><br>" + Messages.getText((String)"file") + ": " + file + "</html>", Messages.getText((String)"confirmacion"), 0, 3, null, options, string1);
        this.answer = false;
        if (n == 0) {
            this.answer = true;
        }
        if (n == 2) {
            this.askMe = false;
            this.answer = true;
        }
        if (n == 3) {
            this.askMe = false;
        }
    }
}

