/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.spi;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportParameters
implements ExportParameters {
    private FeatureStore sourceFeatureStore;
    private Expression filterExpression;
    private int featuresToUse;
    private Object context;
    protected ExportAttributes exportAttributes = null;
    private Date date = new Date();
    public ExportServiceFactory factory;
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractExportParameters.class);
    private FeatureQuery featureQuery;

    public AbstractExportParameters(ExportServiceFactory factory) {
        this.factory = factory;
        this.exportAttributes = ExportLocator.getServiceManager().createExportAttributes();
    }

    @Override
    public boolean needsSelectTargetProjection() {
        return false;
    }

    @Override
    public FeatureType getSourceFeatureType() {
        if (this.exportAttributes != null) {
            return this.exportAttributes.getSourceFeatureType();
        }
        return null;
    }

    @Override
    public void setSourceFeatureType(FeatureType sourceFeatureType) {
        this.exportAttributes.setSourceFeatureType(sourceFeatureType, this.featureQuery);
    }

    @Override
    public void setSourceFeatureStore(FeatureStore sourceFeatureStore) {
        this.sourceFeatureStore = sourceFeatureStore;
        try {
            FeatureType sourceFeatureType = sourceFeatureStore.getDefaultFeatureType();
            this.exportAttributes.setSourceFeatureType(sourceFeatureType, this.featureQuery);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't set feature type", ex);
        }
    }

    @Override
    public FeatureStore getSourceFeatureStore() {
        return this.sourceFeatureStore;
    }

    @Override
    public Expression getFilterExpresion() {
        return this.filterExpression;
    }

    @Override
    public void setFilterExpresion(Expression expression) {
        this.filterExpression = expression;
    }

    @Override
    public FeatureQuery getFeatureQuery() {
        return this.featureQuery;
    }

    @Override
    public void setFeatureQuery(FeatureQuery query) {
        this.featureQuery = query;
    }

    @Override
    public int getFeaturesToUse() {
        return this.featuresToUse;
    }

    @Override
    public void setFeaturesToUse(int featuresToUse) {
        this.featuresToUse = featuresToUse;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public ExportAttributes getExportAttributes() {
        return this.exportAttributes;
    }

    @Override
    public void setExportAttributes(ExportAttributes export) {
        this.exportAttributes = export;
    }

    @Override
    public ExportParameters clone() throws CloneNotSupportedException {
        ExportParameters clone = (ExportParameters)super.clone();
        if (this.filterExpression != null) {
            clone.setFilterExpresion(this.filterExpression.clone());
        }
        if (this.featureQuery != null) {
            clone.setFeatureQuery(this.featureQuery.getCopy());
        }
        if (this.exportAttributes != null) {
            clone.setExportAttributes(this.exportAttributes.clone());
        }
        return clone;
    }

    @Override
    public Date getCreationDate() {
        return this.date;
    }

    @Override
    public void setCreationDate(Date date) {
        this.date = date;
    }

    public String getLabel() {
        StringBuilder builder = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        String dateName = df.format(this.getCreationDate());
        builder.append(dateName);
        builder.append(": ");
        String serviceName = this.getServiceName() != null ? this.getServiceName() : "Null service";
        builder.append(serviceName);
        if (this.getSourceFeatureStore() != null) {
            String storeName = this.getSourceFeatureStore().getName();
            builder.append(" - ");
            builder.append(storeName);
        }
        return builder.toString();
    }

    public Object getValue() {
        return this;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public ExportServiceFactory getFactory() {
        return this.factory;
    }

    @Override
    public FeatureType getTargetFeatureType() {
        if (this.getExportAttributes() == null) {
            LOGGER.warn("Not been able to get target feature type from export attributes because it's null");
            return null;
        }
        return this.getExportAttributes().getTargetFeatureType();
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("AbstractExportParameters") == null) {
            DynStruct definition = manager.addDefinition(AbstractExportParameters.class, "AbstractExportParameters", "AbstractExportParameters persistence definition", null, null);
            definition.addDynFieldInt("featuresToUse").setMandatory(false);
            definition.addDynFieldObject("filterExpression").setClassOfValue(Expression.class).setMandatory(false);
            definition.addDynFieldObject("exportAttributes").setClassOfValue(ExportAttributes.class).setMandatory(false);
            definition.addDynFieldDate("dateCreation").setMandatory(false);
            definition.addDynFieldString("factory");
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("featuresToUse", this.featuresToUse);
        state.set("filterExpression", (Persistent)this.filterExpression);
        state.set("exportAttributes", (Persistent)this.exportAttributes);
        state.set("dateCreation", this.date);
        state.set("factory", this.factory.getName());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        ExportServiceFactory statefactory;
        this.featuresToUse = state.getInt("featuresToUse");
        this.filterExpression = (Expression)state.get("filterExpression");
        this.exportAttributes = (ExportAttributes)state.get("exportAttributes");
        this.date = state.getDate("dateCreation");
        String nameFactory = state.getString("factory");
        this.factory = statefactory = ExportLocator.getServiceManager().getServiceFactory(nameFactory);
    }

    @Override
    public void resetVolatileValues() {
    }
}

