/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.spi;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportParametersFile;
import org.gvsig.export.spi.AbstractExportParameters;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.HasAFile;

public abstract class AbstractExportParametersFile
extends AbstractExportParameters
implements ExportParametersFile {
    protected ExportParametersFileHelper fileHelper = new ExportParametersFileHelper();

    public AbstractExportParametersFile(ExportServiceFactory factory) {
        super(factory);
    }

    @Override
    public File getFile() {
        return this.fileHelper.getFile();
    }

    @Override
    public void setFile(File file) {
        this.fileHelper.setFile(file);
    }

    @Override
    public File getEvaluatedFile() {
        return this.fileHelper.getEvaluatedFile();
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("fileHelper", (Persistent)this.fileHelper);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.fileHelper = (ExportParametersFileHelper)state.get("fileHelper");
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("AbstractExportParametersFile") == null) {
            DynStruct definition = manager.addDefinition(AbstractExportParametersFile.class, "AbstractExportParametersFile", "AbstractExportParametersFile persistence definition", null, null);
            definition.addDynFieldObject("fileHelper");
            definition.extend(manager.getDefinition("AbstractExportParameters"));
        }
    }

    @Override
    public final String getFileExtension() {
        return this.fileHelper.getFileExtension();
    }

    @Override
    public void resetVolatileValues() {
        this.fileHelper.resetVolatileValues();
    }

    public static class ExportParametersFileHelper
    implements HasAFile,
    Persistent {
        private File file = null;
        private File evaluatedFile = null;
        private String fileExtension = "";

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.evaluatedFile = null;
            if (file == null) {
                this.file = null;
                return;
            }
            if (ExpressionUtils.isDynamicFilename((File)file)) {
                this.file = file;
                return;
            }
            if (file.isAbsolute()) {
                this.file = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + this.fileExtension);
                return;
            }
            FoldersManager fm = ToolsLocator.getFoldersManager();
            this.file = new File(fm.getHome(), FilenameUtils.removeExtension((String)file.getPath()) + this.fileExtension);
        }

        public File getEvaluatedFile() {
            if (this.file == null) {
                return null;
            }
            if (this.evaluatedFile == null) {
                this.evaluatedFile = ExpressionUtils.evaluateFilename((File)this.file);
            }
            return this.evaluatedFile;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public void setFileExtension(String fileExtension) {
            if (StringUtils.isBlank((CharSequence)fileExtension)) {
                this.fileExtension = "";
                return;
            }
            if (fileExtension.startsWith(".")) {
                this.fileExtension = fileExtension;
                return;
            }
            this.fileExtension = "." + fileExtension;
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("file", this.file);
            state.set("fileExtension", this.fileExtension);
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            this.file = state.getFile("file");
            this.fileExtension = state.getString("fileExtension");
            this.evaluatedFile = null;
        }

        public static void registerPersistence() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition("ExportParametersFileHelper") == null) {
                DynStruct definition = manager.addDefinition(ExportParametersFileHelper.class, "ExportParametersFileHelper", "ExportParametersFileHelper persistence definition", null, null);
                definition.addDynFieldString("fileExtension");
                definition.addDynFieldFile("file");
            }
        }

        void resetVolatileValues() {
            this.evaluatedFile = null;
        }
    }
}

