/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.spi;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public abstract class AbstractExportServiceFactory
implements ExportServiceFactory {
    private final String name;
    private final String description;
    private static final Map<ExportServiceFactory, Boolean> serviceEnabled = new HashMap<ExportServiceFactory, Boolean>();
    private final String label;

    public AbstractExportServiceFactory(String name, String label, String description) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.name = name;
        this.label = i18n.getTranslation(label);
        this.description = i18n.getTranslation(description);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        Boolean enabled = serviceEnabled.getOrDefault(this, true);
        return enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        serviceEnabled.put(this, value);
    }
}

