/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.gvsig.gpe.lib.api.exceptions.ParserCreationException;
import org.gvsig.gpe.lib.api.exceptions.ParserFileNotSupportedException;
import org.gvsig.gpe.lib.api.exceptions.ParserMimetypeNotSupportedException;
import org.gvsig.gpe.lib.api.exceptions.ParserNotRegisteredException;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerCreationException;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerMimeTypeNotSupportedException;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerNotRegisteredException;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandlerImplementor;
import org.gvsig.gpe.lib.impl.parser.GPEErrorHandler;
import org.gvsig.gpe.lib.impl.parser.GPEParser;
import org.gvsig.gpe.lib.impl.writer.GPEWriterHandler;
import org.gvsig.gpe.lib.impl.writer.GPEWriterHandlerImplementor;
import org.gvsig.gpe.lib.spi.GPEProviderManager;
import org.gvsig.gpe.lib.spi.parser.IGPEParser;

public class DefaultGPEProviderManager
implements GPEProviderManager {
    private Hashtable parsers = new Hashtable();
    private Hashtable writers = new Hashtable();

    public boolean accept(URI uri) {
        Iterator keys = this.parsers.keySet().iterator();
        while (keys.hasNext()) {
            GPEParser parser = (GPEParser)this.parsers.get(keys.next());
            if (!parser.accept(uri)) continue;
            return true;
        }
        return false;
    }

    public void addGpeParser(String name, String description, Class clazz) throws ParserNotRegisteredException {
        try {
            if (clazz != null) {
                GPEParser parser = (GPEParser)clazz.getConstructor(null).newInstance(null);
                this.parsers.put(name, parser);
            }
        }
        catch (Exception e) {
            throw new ParserNotRegisteredException(clazz.getName());
        }
    }

    public void addGpeParser(Class clazz) throws ParserNotRegisteredException {
        try {
            if (clazz != null) {
                GPEParser parser = (GPEParser)clazz.getConstructor(null).newInstance(null);
                this.parsers.put(parser.getName(), parser);
            }
        }
        catch (Exception e) {
            throw new ParserNotRegisteredException(clazz.getName());
        }
    }

    public void addGpeWriterHandlerImplementor(String name, String description, Class clazz) throws WriterHandlerNotRegisteredException {
        try {
            if (clazz != null) {
                GPEWriterHandlerImplementor writerImplementor = (GPEWriterHandlerImplementor)clazz.getConstructor(null).newInstance(null);
                this.writers.put(name, writerImplementor);
            }
        }
        catch (Exception e) {
            throw new WriterHandlerNotRegisteredException(clazz.getName());
        }
    }

    public void addGpeWriterHandlerImplementor(Class clazz) throws WriterHandlerNotRegisteredException {
        try {
            if (clazz != null) {
                GPEWriterHandlerImplementor writerImplementor = (GPEWriterHandlerImplementor)clazz.getConstructor(null).newInstance(null);
                this.writers.put(writerImplementor.getName(), writerImplementor);
            }
        }
        catch (Exception e) {
            throw new WriterHandlerNotRegisteredException(clazz.getName());
        }
    }

    public void addParsersFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            return;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            try {
                Class<?> clazz = Class.forName(properties.getProperty(key).toString());
                this.addGpeParser(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ParserNotRegisteredException parserNotRegisteredException) {}
        }
    }

    public void addWritersFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            return;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            try {
                Class<?> clazz = Class.forName(properties.getProperty(key).toString());
                this.addGpeWriterHandlerImplementor(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (WriterHandlerNotRegisteredException writerHandlerNotRegisteredException) {}
        }
    }

    public IGPEParser createParser(String name) throws ParserCreationException {
        Object parser = this.parsers.get(name);
        if (parser != null) {
            return this.createNewParser((GPEParser)parser);
        }
        ParserNotRegisteredException e = new ParserNotRegisteredException(name);
        throw new ParserCreationException((Throwable)e);
    }

    public IGPEParser createParser(URI uri) throws ParserCreationException {
        for (String key : this.parsers.keySet()) {
            GPEParser parser = (GPEParser)this.parsers.get(key);
            if (!parser.accept(uri)) continue;
            return this.createNewParser(parser);
        }
        throw new ParserFileNotSupportedException(uri);
    }

    public IGPEParser createParserByClass(String prefferredImplClassName) throws ParserCreationException {
        Iterator it = this.parsers.keySet().iterator();
        boolean i = false;
        while (it.hasNext()) {
            String key = (String)it.next();
            GPEParser parser = (GPEParser)this.parsers.get(key);
            if (!parser.getClass().getName().equals(prefferredImplClassName)) continue;
            return this.createNewParser(parser);
        }
        throw new ParserNotRegisteredException(prefferredImplClassName);
    }

    public IGPEParser createParserByMimeType(String mimeType) throws ParserCreationException {
        Iterator it = this.parsers.keySet().iterator();
        boolean i = false;
        while (it.hasNext()) {
            String key = (String)it.next();
            GPEParser parser = (GPEParser)this.parsers.get(key);
            if (!parser.getFormat().equals(mimeType)) continue;
            return this.createNewParser(parser);
        }
        throw new ParserMimetypeNotSupportedException(mimeType);
    }

    public IGPEWriterHandlerImplementor createWriterHandlerImplementor(String name) throws WriterHandlerCreationException {
        Object writer = this.writers.get(name);
        if (writer != null) {
            return this.createNewWriterHandler((IGPEWriterHandlerImplementor)writer);
        }
        WriterHandlerNotRegisteredException e = new WriterHandlerNotRegisteredException(name);
        throw new WriterHandlerCreationException((Throwable)e);
    }

    public IGPEWriterHandlerImplementor createWriterHandlerImplementorByClass(String prefferredImplClassName) throws WriterHandlerCreationException {
        Iterator it = this.writers.keySet().iterator();
        ArrayList possibleWriters = new ArrayList();
        while (it.hasNext()) {
            String key = (String)it.next();
            IGPEWriterHandlerImplementor implementor = (IGPEWriterHandlerImplementor)this.writers.get(key);
            if (!implementor.getClass().getName().equals(prefferredImplClassName)) continue;
            return this.createNewWriterHandler(implementor);
        }
        throw new WriterHandlerNotRegisteredException(prefferredImplClassName);
    }

    public IGPEWriterHandlerImplementor createWriterHandlerImplementorByMimeType(String mimeType) throws WriterHandlerCreationException {
        Iterator it = this.writers.keySet().iterator();
        ArrayList possibleWriters = new ArrayList();
        while (it.hasNext()) {
            String key = (String)it.next();
            IGPEWriterHandlerImplementor implementor = (IGPEWriterHandlerImplementor)this.writers.get(key);
            if (!implementor.getFormat().equals(mimeType)) continue;
            return this.createNewWriterHandler(implementor);
        }
        throw new WriterHandlerMimeTypeNotSupportedException(mimeType);
    }

    private IGPEParser createNewParser(GPEParser parser) throws ParserCreationException {
        try {
            return (GPEParser)parser.getClass().getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            throw new ParserCreationException((Throwable)e);
        }
    }

    private IGPEWriterHandlerImplementor createNewWriterHandler(IGPEWriterHandlerImplementor gpeWriterHandlerImplementor) throws WriterHandlerCreationException {
        try {
            GPEWriterHandlerImplementor resp = null;
            resp = (GPEWriterHandlerImplementor)gpeWriterHandlerImplementor.getClass().getConstructor(null).newInstance(null);
            resp.setErrorHandler(new GPEErrorHandler());
            return resp;
        }
        catch (Exception e) {
            throw new WriterHandlerCreationException((Throwable)e);
        }
    }

    public IGPEParser[] getAllParsers() {
        IGPEParser[] auxParsers = new GPEParser[this.parsers.size()];
        Iterator it = this.parsers.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            auxParsers[i] = (GPEParser)this.parsers.get(key);
            ++i;
        }
        return auxParsers;
    }

    public ArrayList getWriterHandlerByFormat(String format) {
        Iterator it = this.writers.keySet().iterator();
        ArrayList<GPEWriterHandler> possibleWriters = new ArrayList<GPEWriterHandler>();
        while (it.hasNext()) {
            String key = (String)it.next();
            IGPEWriterHandlerImplementor implementor = (IGPEWriterHandlerImplementor)this.writers.get(key);
            String implShortFormat = this.getShortFormat(implementor.getFormat());
            if (implShortFormat.toLowerCase().compareTo(format.toLowerCase()) != 0) continue;
            possibleWriters.add(new GPEWriterHandler(implementor));
        }
        return possibleWriters;
    }

    public IGPEParser createParser(File file) throws ParserCreationException {
        for (String key : this.parsers.keySet()) {
            GPEParser parser = (GPEParser)this.parsers.get(key);
            if (!parser.accept(file)) continue;
            return this.createNewParser(parser);
        }
        throw new ParserFileNotSupportedException(file);
    }

    private String getShortFormat(String fmt) {
        if (fmt == null) {
            return "";
        }
        String[] parts = fmt.split(";");
        String aux = "";
        aux = parts.length > 1 ? parts[1].trim() : parts[0].trim();
        if ((parts = aux.split("=")).length > 1) {
            aux = parts[1].trim();
            parts = aux.split("/");
            return parts[0];
        }
        aux = parts[0].trim();
        if ((parts = aux.split("/")).length > 1) {
            return parts[1];
        }
        return aux;
    }
}

