/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.warnings;

import java.util.Hashtable;
import java.util.Map;
import org.gvsig.tools.exception.BaseException;

public class NotSupportedFeatureWarning
extends BaseException {
    private static final long serialVersionUID = -907568605199930636L;
    private String featureName = null;
    private String xsFeatureType = null;
    private String layerName = null;
    private String xsLayerType = null;
    private boolean hasParentSchema = false;

    public NotSupportedFeatureWarning(String featureName, String xsFeatureType, String layerName, String xsLayerType) {
        this.featureName = featureName;
        this.xsFeatureType = xsFeatureType;
        this.layerName = layerName;
        this.xsLayerType = xsLayerType;
        this.hasParentSchema = true;
        this.initialize();
    }

    public NotSupportedFeatureWarning(String featureName, String xsFeatureType) {
        this.featureName = featureName;
        this.xsFeatureType = xsFeatureType;
        this.hasParentSchema = false;
        this.initialize();
    }

    private void initialize() {
        this.messageKey = "gpe_not_supported_feature_warning";
        this.formatString = this.hasParentSchema ? "The feature '%(featureName)' with a XML schema type '%(xsFeatureType)' is not contained in the parent layer '%(layerName)' with a XML Schema type '%(xsLayerType)'" : "The feature '%(featureName)' with a XML schema type '%(xsFeatureType)' is not found on the XML schema ";
        this.code = -907568605199930636L;
    }

    protected Map values() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("featureName", this.featureName);
        hash.put("xsFeatureType", this.xsFeatureType);
        if (this.hasParentSchema) {
            hash.put("layerName", this.layerName);
            hash.put("xsLayerType", this.xsLayerType);
        }
        return hash;
    }
}

