/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.warnings;

import java.util.Hashtable;
import java.util.Map;
import org.gvsig.tools.exception.BaseException;

public class PolygonAutomaticallyClosedWarning
extends BaseException {
    private static final long serialVersionUID = -4652019336977819445L;
    private double[] x = null;
    private double[] y = null;
    private double[] z = null;

    public PolygonAutomaticallyClosedWarning(double[][] coordinates) {
        this.x = coordinates[0];
        this.y = coordinates[1];
        this.z = coordinates[2];
        this.initialize();
    }

    public PolygonAutomaticallyClosedWarning(double[] x, double[] y, double[] z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.initialize();
    }

    private void initialize() {
        this.messageKey = "gpe_polygon_automatically_closed_warning";
        this.formatString = "The polygon is not closed. The first coordinate is %(X0),%(Y0),%(Z0) and the last one is %(X1),%(Y1),%(Z1). The writting process will close it automatically";
        this.code = -4652019336977819445L;
    }

    protected Map values() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("X0", String.valueOf(this.x[0]));
        hash.put("Y0", String.valueOf(this.y[0]));
        hash.put("Z0", String.valueOf(this.z[0]));
        hash.put("X1", String.valueOf(this.x[this.x.length - 1]));
        hash.put("Y1", String.valueOf(this.y[this.y.length - 1]));
        hash.put("Z1", String.valueOf(this.z[this.z.length - 1]));
        return hash;
    }
}

