/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.writer;

import java.io.OutputStream;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandlerImplementor;
import org.gvsig.gpe.lib.impl.warnings.FeatureNotSupportedWarning;

public abstract class GPEWriterHandlerImplementor
implements IGPEWriterHandlerImplementor {
    private OutputStream os = null;
    private IGPEErrorHandler errorHandler = null;
    private GPEManager gpeManager = GPELocator.getGPEManager();

    public String toString() {
        return this.getName();
    }

    public IGPEErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(IGPEErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public void setFormat(String format) {
    }

    public void startPoint(String id, ICoordinateIterator coords, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a point", this.getName())));
    }

    public void endPoint() {
    }

    public void startLineString(String id, ICoordinateIterator coords, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a lineString", this.getName())));
    }

    public void endLineString() {
    }

    public void startLinearRing(String id, ICoordinateIterator coords, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a linearRing", this.getName())));
    }

    public void endLinearRing() {
    }

    public void startPolygon(String id, ICoordinateIterator coords, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a polygon", this.getName())));
    }

    public void endPolygon() {
    }

    public void startInnerBoundary(String id, ICoordinateIterator coords, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a polygon innerboundary", this.getName())));
    }

    public void endInnerBoundary() {
    }

    public void initialize() {
    }

    public void close() {
    }

    public void startBbox(String id, ICoordinateIterator coords, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a bbox", this.getName())));
    }

    public void endBbox() {
    }

    public void startElement(String name, Object value, String xsElementName) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create an element", this.getName())));
    }

    public void endElement() {
    }

    public void startLayer(String id, String name, String description, String srs, String xsElementName) {
    }

    public void endLayer() {
    }

    public void startFeature(String id, String name, String xsElementName) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Feature creation", this.getName())));
    }

    public void endFeature() {
    }

    public void startMultiPoint(String id, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a multiPoint", this.getName())));
    }

    public void endMultiPoint() {
    }

    public void startMultiLineString(String id, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a multiLineString", this.getName())));
    }

    public void endMultiLineString() {
    }

    public void startMultiPolygon(String id, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a multiPolygon", this.getName())));
    }

    public void endMultiPolygon() {
    }

    public void startMultiGeometry(String id, String srs) {
        this.getErrorHandler().addWarning((Throwable)((Object)new FeatureNotSupportedWarning("Create a multiGeometry", this.getName())));
    }

    public void endMultiGeometry() {
    }

    protected OutputStream getOutputStream() {
        return this.os;
    }

    public GPEManager getGpeManager() {
        return this.gpeManager;
    }
}

