/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.SLDConverterManager;
import org.gvsig.sldconverter.exception.UnsupportedLegendException;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.legend.LegendToSLDConverter;
import org.gvsig.sldconverter.legend.LegendToSLDConverterFactory;
import org.gvsig.sldconverter.legend.SLDToLegendConverter;
import org.gvsig.sldconverter.legend.SLDToLegendConverterFactory;
import org.gvsig.sldconverter.symbol.SLDToSymbolConverter;
import org.gvsig.sldconverter.symbol.SLDToSymbolConverterFactory;
import org.gvsig.sldconverter.symbol.SymbolToSLDConverter;
import org.gvsig.sldconverter.symbol.SymbolToSLDConverterFactory;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;

public class DefaultSLDConverterManager
implements SLDConverterManager {
    private Set<SLDToLegendConverterFactory> legendFromSLD = new HashSet<SLDToLegendConverterFactory>();
    private Set<LegendToSLDConverterFactory> legendToSLD = new HashSet<LegendToSLDConverterFactory>();
    private Set<SLDToSymbolConverterFactory> symbolFromSLD = new HashSet<SLDToSymbolConverterFactory>();
    private Set<SymbolToSLDConverterFactory> symbolToSLD = new HashSet<SymbolToSLDConverterFactory>();

    public SLDSymbol toSLDSymbol(ISymbol sym) throws UnsupportedSymbolException {
        if (sym == null) {
            throw new UnsupportedSymbolException("ISymbol", "Null");
        }
        int max = 0;
        SymbolToSLDConverterFactory factToUse = null;
        Iterator<SymbolToSLDConverterFactory> iter = this.symbolToSLD.iterator();
        SymbolToSLDConverterFactory fact = null;
        int aux = 0;
        while (iter.hasNext()) {
            fact = iter.next();
            aux = fact.canConvert(sym);
            if (aux <= max) continue;
            max = aux;
            factToUse = fact;
        }
        if (max == 0) {
            throw new UnsupportedSymbolException(sym.getClass().getName(), "No converter found.");
        }
        SymbolToSLDConverter conv = factToUse.createSymbolToSLDConverter();
        return conv.convert(sym);
    }

    public ISymbol toSymbol(SLDSymbol sldsym) throws UnsupportedSLDObjectException {
        if (sldsym == null) {
            throw new UnsupportedSLDObjectException("SLDSymbol", "Null");
        }
        int max = 0;
        SLDToSymbolConverterFactory factToUse = null;
        Iterator<SLDToSymbolConverterFactory> iter = this.symbolFromSLD.iterator();
        SLDToSymbolConverterFactory fact = null;
        int aux = 0;
        while (iter.hasNext()) {
            fact = iter.next();
            aux = fact.canConvert(sldsym);
            if (aux <= max) continue;
            max = aux;
            factToUse = fact;
        }
        if (max == 0) {
            throw new UnsupportedSLDObjectException(sldsym.getClass().getSimpleName(), "No converter found.");
        }
        SLDToSymbolConverter conv = factToUse.createSLDToSymbolConverter();
        return conv.convert(sldsym);
    }

    public SLDLayer toSLDLayer(ILegend legend) throws UnsupportedLegendException, UnsupportedSymbolException {
        if (legend == null) {
            throw new UnsupportedLegendException("ILegend", "Null");
        }
        int max = 0;
        LegendToSLDConverterFactory factToUse = null;
        Iterator<LegendToSLDConverterFactory> iter = this.legendToSLD.iterator();
        LegendToSLDConverterFactory fact = null;
        int aux = 0;
        while (iter.hasNext()) {
            fact = iter.next();
            aux = fact.canConvert(legend);
            if (aux <= max) continue;
            max = aux;
            factToUse = fact;
        }
        if (max == 0) {
            throw new UnsupportedLegendException(legend.getClass().getName(), "No converter found.");
        }
        LegendToSLDConverter conv = factToUse.createLegendToSLDConverter();
        return conv.convert(legend);
    }

    public ILegend toLegend(SLDLayer sldlayer) throws UnsupportedSLDObjectException {
        if (sldlayer == null) {
            throw new UnsupportedSLDObjectException("SLDLayer", "Null");
        }
        int max = 0;
        SLDToLegendConverterFactory factToUse = null;
        Iterator<SLDToLegendConverterFactory> iter = this.legendFromSLD.iterator();
        SLDToLegendConverterFactory fact = null;
        int aux = 0;
        while (iter.hasNext()) {
            fact = iter.next();
            aux = fact.canConvert(sldlayer);
            if (aux <= max) continue;
            max = aux;
            factToUse = fact;
        }
        if (max == 0) {
            throw new UnsupportedSLDObjectException(sldlayer.getClass().getSimpleName(), "No converter found.");
        }
        SLDToLegendConverter conv = factToUse.createSLDToLegendConverter();
        return conv.convert(sldlayer);
    }

    public void registerSLDToSymbolConverter(SLDToSymbolConverterFactory fact) {
        if (fact != null) {
            this.symbolFromSLD.add(fact);
        }
    }

    public void registerSymbolToSLDConverter(SymbolToSLDConverterFactory fact) {
        if (fact != null) {
            this.symbolToSLD.add(fact);
        }
    }

    public void registerSLDToLegendConverter(SLDToLegendConverterFactory fact) {
        if (fact != null) {
            this.legendFromSLD.add(fact);
        }
    }

    public void registerLegendToSLDConverter(LegendToSLDConverterFactory fact) {
        if (fact != null) {
            this.legendToSLD.add(fact);
        }
    }
}

