/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.legend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialIntervalLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.filter.SLDFilter;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDPropertyName;
import org.gvsig.sldsupport.sld.filter.operator.SLDComparisonOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDBinaryComparisonOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDIsBetweenOperator;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.rule.SLDRule;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;
import org.gvsig.tools.dataTypes.DataType;

public class IntervalsLegendUtils {
    public static IVectorialIntervalLegend toIntervalsLegend(List<SLDRule> rules) throws UnsupportedSLDObjectException {
        IVectorialIntervalLegend intleg = (IVectorialIntervalLegend)BasicUtils.mapMan().createLegend("VectorialInterval");
        String pname = BasicUtils.getFirstPropertyName(rules);
        if (pname == null || pname.length() == 0) {
            throw new UnsupportedSLDObjectException("SLDFeatureStyle", "Cannot interpret rules (no property name)");
        }
        List<SLDLiteral> lits = BasicUtils.getComparisonLiterals(rules);
        if (lits == null || lits.size() == 0) {
            throw new UnsupportedSLDObjectException("SLDFeatureStyle", "Cannot interpret rules (no literals)");
        }
        DataType dt = BasicUtils.guessDataType(lits);
        ISymbol sym = BasicUtils.getElseSymbol(rules);
        Map<IInterval, ISymbol> map = IntervalsLegendUtils.getIntervalToSymbol(rules, dt, pname);
        Iterator<IInterval> iter = map.keySet().iterator();
        IInterval k = null;
        while (iter.hasNext()) {
            k = iter.next();
            intleg.addSymbol((Object)k, map.get(k));
        }
        if (sym != null) {
            sym.setDescription("Default");
            intleg.setDefaultSymbol(sym);
            intleg.useDefaultSymbol(true);
            intleg.addSymbol((Object)sym.getDescription(), sym);
        } else {
            intleg.useDefaultSymbol(false);
        }
        String[] atts = new String[]{pname};
        intleg.setClassifyingFieldNames(atts);
        int[] typs = new int[]{dt.getType()};
        intleg.setClassifyingFieldTypes(typs);
        return intleg;
    }

    public static boolean areRulesOfIntervals(List<SLDRule> rules) {
        if (rules == null || rules.size() == 0) {
            return false;
        }
        SLDRule rule = null;
        String fieldName = null;
        for (int i = 0; i < rules.size() && (fieldName = IntervalsLegendUtils.getComparisonToNumericLiteralFieldName(rule = rules.get(i))) == null; ++i) {
        }
        if (fieldName == null) {
            return false;
        }
        int elsecount = 0;
        for (int i = 1; i < rules.size(); ++i) {
            rule = rules.get(i);
            if (!BasicUtils.isElse(rule)) {
                String fname = IntervalsLegendUtils.getComparisonToNumericLiteralFieldName(rule);
                if (fname != null && fname.compareTo(fieldName) == 0) continue;
                return false;
            }
            ++elsecount;
        }
        return elsecount < 2;
    }

    private static String getComparisonToNumericLiteralFieldName(SLDRule rule) {
        SLDIsBetweenOperator beop;
        SLDFilter filt = rule.getFilter();
        if (filt == null) {
            return null;
        }
        SLDFilterOperator oper = filt.getFilterOperator();
        if (!(oper instanceof SLDComparisonOperator)) {
            return null;
        }
        SLDComparisonOperator cop = (SLDComparisonOperator)oper;
        SLDPropertyName pname = null;
        if (cop instanceof SLDBinaryComparisonOperator) {
            SLDBinaryComparisonOperator bco = (SLDBinaryComparisonOperator)cop;
            String opname = bco.getComparisonOperator();
            if (opname.compareTo("PropertyIsGreaterThanOrEqualTo") == 0 || opname.compareTo("PropertyIsGreaterThan") == 0 || opname.compareTo("PropertyIsLessThanOrEqualTo") == 0 || opname.compareTo("PropertyIsLessThan") == 0) {
                if (bco.getFirstExpression() instanceof SLDLiteral && bco.getSecondExpression() instanceof SLDPropertyName) {
                    pname = (SLDPropertyName)bco.getSecondExpression();
                    if (BasicUtils.isNumeric((SLDLiteral)bco.getFirstExpression())) {
                        return pname.getPropertyName();
                    }
                    return null;
                }
                if (bco.getFirstExpression() instanceof SLDPropertyName && bco.getSecondExpression() instanceof SLDLiteral) {
                    pname = (SLDPropertyName)bco.getFirstExpression();
                    if (BasicUtils.isNumeric((SLDLiteral)bco.getSecondExpression())) {
                        return pname.getPropertyName();
                    }
                    return null;
                }
            }
        } else if (cop instanceof SLDIsBetweenOperator && (beop = (SLDIsBetweenOperator)cop).getExpression() instanceof SLDPropertyName && beop.getLowerBoundary() instanceof SLDLiteral && beop.getUpperBoundary() instanceof SLDLiteral) {
            pname = (SLDPropertyName)beop.getExpression();
            if (BasicUtils.isNumeric((SLDLiteral)beop.getLowerBoundary()) && BasicUtils.isNumeric((SLDLiteral)beop.getUpperBoundary())) {
                return pname.getPropertyName();
            }
            return null;
        }
        return null;
    }

    public static SLDLayer toSLDLayer(IVectorialIntervalLegend legend) throws UnsupportedSymbolException {
        String fname = legend.getClassifyingFieldNames()[0];
        SLDSymbol sldsym = null;
        SLDRule rule = null;
        SLDFeatureStyle fstyle = new SLDFeatureStyle();
        IInterval iival = null;
        Object valstr = null;
        Object[] vals = legend.getValues();
        ISymbol[] syms = legend.getSymbols();
        int n = Math.min(vals.length, syms.length);
        SLDFilter filt = null;
        SLDComparisonOperator oper = null;
        ISymbol elsesym = null;
        for (int i = 0; i < n; ++i) {
            rule = new SLDRule();
            sldsym = BasicUtils.sldMan().toSLDSymbol(syms[i]);
            rule.getSymbols().add(sldsym);
            if (vals[i] instanceof IInterval) {
                filt = BasicUtils.supMan().createFilter();
                filt.setIsElse(false);
                iival = (IInterval)vals[i];
                oper = IntervalsLegendUtils.intervalToComparisonOperator(iival, fname);
                filt.setFilterOperator((SLDFilterOperator)oper);
                rule.setFilter(filt);
                fstyle.getRules().add(rule);
                continue;
            }
            elsesym = syms[i];
        }
        if (elsesym == null && legend.isUseDefaultSymbol()) {
            elsesym = legend.getDefaultSymbol();
        }
        if (elsesym != null) {
            rule = new SLDRule();
            sldsym = BasicUtils.sldMan().toSLDSymbol(elsesym);
            rule.getSymbols().add(sldsym);
            filt = BasicUtils.supMan().createFilter();
            filt.setIsElse(true);
            rule.setFilter(filt);
            fstyle.getRules().add(rule);
        }
        SLDUserStyle usty = new SLDUserStyle();
        usty.getFeatureStyles().add(fstyle);
        SLDNamedLayer nlayer = new SLDNamedLayer();
        nlayer.setName("Name");
        nlayer.getStyles().add(usty);
        return nlayer;
    }

    private static SLDComparisonOperator intervalToComparisonOperator(IInterval iival, String fieldName) {
        double max = iival.getMax();
        double min = iival.getMin();
        if (max == Double.MAX_VALUE && min != -1.7976931348623157E308) {
            SLDBinaryComparisonOperator resp = new SLDBinaryComparisonOperator();
            resp.setComparisonOperator("PropertyIsGreaterThanOrEqualTo");
            resp.setFirstExpression((SLDExpression)new SLDPropertyName(fieldName));
            resp.setSecondExpression((SLDExpression)new SLDLiteral(BasicUtils.df.format(min)));
            return resp;
        }
        if (min == -1.7976931348623157E308 && max != Double.MAX_VALUE) {
            SLDBinaryComparisonOperator resp = new SLDBinaryComparisonOperator();
            resp.setComparisonOperator("PropertyIsLessThanOrEqualTo");
            resp.setFirstExpression((SLDExpression)new SLDPropertyName(fieldName));
            resp.setSecondExpression((SLDExpression)new SLDLiteral(BasicUtils.df.format(max)));
            return resp;
        }
        SLDIsBetweenOperator resp = new SLDIsBetweenOperator();
        resp.setExpression((SLDExpression)new SLDPropertyName(fieldName));
        resp.setLowerBoundary((SLDExpression)new SLDLiteral(BasicUtils.df.format(min)));
        resp.setUpperBoundary((SLDExpression)new SLDLiteral(BasicUtils.df.format(max)));
        return resp;
    }

    public static Map<IInterval, ISymbol> getIntervalToSymbol(List<SLDRule> rules, DataType dt, String pname) throws UnsupportedSLDObjectException {
        HashMap<IInterval, ISymbol> resp = new HashMap<IInterval, ISymbol>();
        if (rules == null || rules.size() == 0) {
            return resp;
        }
        SLDFilter filt = null;
        List symList = null;
        SLDFilterOperator oper = null;
        Object binoper = null;
        ISymbol sym = null;
        Object sldpname = null;
        Object sldlit = null;
        Object val = null;
        for (int i = 0; i < rules.size(); ++i) {
            IInterval ival;
            symList = rules.get(i).getSymbols();
            if (symList == null || symList.size() == 0 || (filt = rules.get(i).getFilter()) == null || filt.isElse() || !((oper = filt.getFilterOperator()) instanceof SLDComparisonOperator) || (sym = BasicUtils.sldMan().toSymbol((SLDSymbol)symList.get(0))) == null || (ival = IntervalsLegendUtils.getIntervalForSymbol((SLDComparisonOperator)oper, pname, sym)) == null) continue;
            resp.put(ival, sym);
        }
        return resp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IInterval getIntervalForSymbol(SLDComparisonOperator oper, String pname, ISymbol sym) {
        double min = 0.0;
        double max = 0.0;
        SLDBinaryComparisonOperator bc = null;
        SLDIsBetweenOperator bw = null;
        SLDLiteral lit = null;
        if (oper instanceof SLDBinaryComparisonOperator) {
            bc = (SLDBinaryComparisonOperator)oper;
            if (IntervalsLegendUtils.isGreaterComparison(bc)) {
                lit = BasicUtils.getLiteral(bc.getExpressions());
                try {
                    min = Double.parseDouble(lit.getValue());
                    max = Double.MAX_VALUE;
                    sym.setDescription("> " + lit.getValue());
                    return BasicUtils.symMan().createInterval(min, max);
                }
                catch (Exception exc) {
                    return null;
                }
            } else {
                if (!IntervalsLegendUtils.isLessThanComparison(bc)) return null;
                lit = BasicUtils.getLiteral(bc.getExpressions());
                try {
                    max = Double.parseDouble(lit.getValue());
                    min = -1.7976931348623157E308;
                    sym.setDescription("< " + lit.getValue());
                    return BasicUtils.symMan().createInterval(min, max);
                }
                catch (Exception exc) {
                    return null;
                }
            }
        }
        if (!(oper instanceof SLDIsBetweenOperator)) return null;
        bw = (SLDIsBetweenOperator)oper;
        SLDExpression lower = bw.getLowerBoundary();
        SLDExpression upper = bw.getUpperBoundary();
        if (!(lower instanceof SLDLiteral) || !(upper instanceof SLDLiteral)) return null;
        String lowerstr = ((SLDLiteral)lower).getValue();
        String upperstr = ((SLDLiteral)upper).getValue();
        try {
            min = Double.parseDouble(lowerstr);
            max = Double.parseDouble(upperstr);
            sym.setDescription(lowerstr + " - " + upperstr);
            return BasicUtils.symMan().createInterval(min, max);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static boolean isLessThanComparison(SLDBinaryComparisonOperator bc) {
        if (bc == null) {
            return false;
        }
        String comp = bc.getComparisonOperator();
        return comp != null && (comp.compareTo("PropertyIsLessThanOrEqualTo") == 0 || comp.compareTo("PropertyIsLessThan") == 0);
    }

    private static boolean isGreaterComparison(SLDBinaryComparisonOperator bc) {
        if (bc == null) {
            return false;
        }
        String comp = bc.getComparisonOperator();
        return comp != null && (comp.compareTo("PropertyIsGreaterThanOrEqualTo") == 0 || comp.compareTo("PropertyIsGreaterThan") == 0);
    }
}

