/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.symbol;

import java.awt.Color;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.symbol.SLDLineSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ISimpleLineSymbol;

public class LineSymbolUtils {
    public static ISymbol toLineSymbol(SLDLineSymbol sym) throws UnsupportedSLDObjectException {
        Double wi;
        ISimpleLineSymbol resp = BasicUtils.symMan().createSimpleLineSymbol();
        SLDStroke stro = sym.getStroke();
        Color col = BasicUtils.toColor(stro.getColor());
        if (col != null) {
            resp.setColor(col);
        }
        if ((wi = BasicUtils.toDouble(stro.getWidth())) != null) {
            resp.setLineWidth(wi.doubleValue());
        }
        return resp;
    }

    public static SLDLineSymbol toSLDLineSymbol(ILineSymbol sym) throws UnsupportedSymbolException {
        Color bcolor = sym.getColor();
        double bw = sym.getLineWidth();
        SLDStroke stro = new SLDStroke();
        stro.setColor(bcolor);
        stro.setWidth((SLDExpression)new SLDLiteral(BasicUtils.df.format(bw)));
        SLDLineSymbol resp = new SLDLineSymbol();
        resp.setStroke(stro);
        return resp;
    }
}

