/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.symbol;

import java.awt.Color;
import java.net.URL;
import java.util.List;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.graphic.SLDExternalGraphic;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;
import org.gvsig.sldsupport.sld.graphic.SLDGraphicStackElement;
import org.gvsig.sldsupport.sld.graphic.SLDMark;
import org.gvsig.sldsupport.sld.symbol.SLDPointSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDFill;
import org.gvsig.sldsupport.sld.symbol.misc.SLDParameterValue;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.ISimpleMarkerSymbol;

public class PointSymbolUtils {
    public static ISymbol toMarkerSymbol(SLDPointSymbol sym) throws UnsupportedSLDObjectException {
        SLDGraphic gra = sym.getGraphic();
        List list = gra.getElementStack();
        if (list.size() == 1) {
            Integer alpha = BasicUtils.getAlphaValue(gra.getOpacity());
            Double sz = BasicUtils.getDouble(gra.getSize());
            IMarkerSymbol msym = PointSymbolUtils.toMarkerSymbol((SLDGraphicStackElement)list.get(0));
            if (alpha != null) {
                msym.setAlpha(alpha.intValue());
            }
            if (sz != null) {
                msym.setSize(sz.doubleValue());
            }
            return msym;
        }
        IMultiLayerSymbol resp = BasicUtils.syMan().createMultiLayerSymbol(1);
        for (int i = 0; i < list.size(); ++i) {
            resp.addLayer((ISymbol)PointSymbolUtils.toMarkerSymbol((SLDGraphicStackElement)list.get(i)));
        }
        return resp;
    }

    private static IMarkerSymbol toMarkerSymbol(SLDExternalGraphic extgra) throws UnsupportedSLDObjectException {
        if (extgra.isOnlineResource()) {
            URL u = null;
            IPictureMarkerSymbol pms = null;
            try {
                u = new URL(extgra.getOnlineResource());
                pms = BasicUtils.symMan().createPictureMarkerSymbol(u, u);
            }
            catch (Exception exc) {
                throw new UnsupportedSLDObjectException((Throwable)exc, "SLDExternalGraphic", "Creating picture marker symbol from URL");
            }
            return pms;
        }
        throw new UnsupportedSLDObjectException("SLDExternalGraphic", "Inline content not supported.");
    }

    private static IMarkerSymbol toMarkerSymbol(SLDGraphicStackElement elem) throws UnsupportedSLDObjectException {
        if (elem == null) {
            throw new UnsupportedSLDObjectException("SLDGraphicStackElement", "Null");
        }
        if (elem instanceof SLDExternalGraphic) {
            return PointSymbolUtils.toMarkerSymbol((SLDExternalGraphic)elem);
        }
        if (elem instanceof SLDMark) {
            return PointSymbolUtils.toMarkerSymbol((SLDMark)elem);
        }
        throw new UnsupportedSLDObjectException("SLDGraphicStackElement", "Unexpected class: " + elem.getClass().getName());
    }

    private static IMarkerSymbol toMarkerSymbol(SLDMark mk) throws UnsupportedSLDObjectException {
        Double sz;
        switch (mk.getMarkType()) {
            case 3: {
                throw new UnsupportedSLDObjectException("SLDMark", "Inline content not supported.");
            }
            case 2: {
                URL u = null;
                IPictureMarkerSymbol pms = null;
                try {
                    u = new URL(mk.getOnlineResource());
                    pms = BasicUtils.symMan().createPictureMarkerSymbol(u, u);
                }
                catch (Exception exc) {
                    throw new UnsupportedSLDObjectException((Throwable)exc, "SLDMark", "Creating picture marker symbol from URL");
                }
                return pms;
            }
            case 1: {
                SLDStroke stro;
                String wkn = mk.getWellKnownName();
                int t = PointSymbolUtils.getMarkerSymbolType(wkn);
                ISimpleMarkerSymbol resp = BasicUtils.symMan().createSimpleMarkerSymbol();
                resp.setStyle(t);
                SLDFill fill = mk.getFill();
                Color co = null;
                Double dob = null;
                if (fill != null && (co = BasicUtils.toColor(fill.getFillColor())) != null) {
                    resp.setColor(co);
                }
                if ((stro = mk.getStroke()) != null) {
                    co = BasicUtils.toColor(stro.getColor());
                    if (co != null) {
                        resp.setOutlineColor(co);
                    }
                    if ((dob = BasicUtils.toDouble(stro.getWidth())) != null) {
                        resp.setOutlineSize(dob.doubleValue());
                    }
                }
                return resp;
            }
        }
        ISimpleMarkerSymbol ms = BasicUtils.symMan().createSimpleMarkerSymbol();
        SLDStroke str = mk.getStroke();
        Color col = BasicUtils.getColor(str.getColor());
        if (col != null) {
            ms.setColor(col);
        }
        if ((sz = BasicUtils.toDouble(str.getWidth())) != null) {
            ms.setSize(sz.doubleValue());
        }
        return ms;
    }

    private static int getMarkerSymbolType(String wkn) {
        if (wkn.compareToIgnoreCase("circle") == 0) {
            return 0;
        }
        if (wkn.compareToIgnoreCase("x") == 0) {
            return 4;
        }
        if (wkn.compareToIgnoreCase("cross") == 0) {
            return 2;
        }
        if (wkn.compareToIgnoreCase("triangle") == 0) {
            return 5;
        }
        if (wkn.compareToIgnoreCase("star") == 0) {
            return 6;
        }
        return 1;
    }

    public static ISymbol toMarkerSymbol(SLDGraphic gra) throws UnsupportedSLDObjectException {
        Object resp = null;
        List list = gra.getElementStack();
        Integer alpha = BasicUtils.getAlphaValue(gra.getOpacity());
        Double sz = BasicUtils.getDouble(gra.getSize());
        if (list.size() == 0) {
            ISimpleMarkerSymbol sms = BasicUtils.symMan().createSimpleMarkerSymbol();
            if (alpha != null) {
                sms.setAlpha(alpha.intValue());
            }
            if (sz != null) {
                sms.setSize(sz.doubleValue());
            }
            return sms;
        }
        if (list.size() == 1) {
            IMarkerSymbol msym = PointSymbolUtils.toMarkerSymbol((SLDGraphicStackElement)list.get(0));
            if (alpha != null) {
                msym.setAlpha(alpha.intValue());
            }
            if (sz != null) {
                msym.setSize(sz.doubleValue());
            }
            return msym;
        }
        IMultiLayerSymbol mls = BasicUtils.syMan().createMultiLayerSymbol(1);
        for (int i = 0; i < list.size(); ++i) {
            mls.addLayer((ISymbol)PointSymbolUtils.toMarkerSymbol((SLDGraphicStackElement)list.get(i)));
        }
        return mls;
    }

    private static String getMarkWellKnownName(int style) {
        if (style == 0) {
            return "circle";
        }
        if (style == 2) {
            return "cross";
        }
        if (style == 1) {
            return "square";
        }
        if (style == 5) {
            return "triangle";
        }
        if (style == 6) {
            return "star";
        }
        if (style == 4) {
            return "x";
        }
        return "square";
    }

    public static SLDPointSymbol toSLDPointSymbol(IMarkerSymbol sym) throws UnsupportedSymbolException {
        if (sym instanceof IPictureMarkerSymbol) {
            IPictureMarkerSymbol aux = (IPictureMarkerSymbol)sym;
            SLDExternalGraphic egra = new SLDExternalGraphic();
            egra.setIsOnline(true);
            egra.setOnlineResource(aux.getSource().toString());
            egra.setFormat(BasicUtils.getFormat(aux.getSource()));
            SLDGraphic gra = new SLDGraphic();
            gra.getElementStack().add(egra);
            SLDPointSymbol resp = new SLDPointSymbol();
            resp.setGraphic(gra);
            return resp;
        }
        if (sym instanceof ISimpleMarkerSymbol) {
            ISimpleMarkerSymbol aux = (ISimpleMarkerSymbol)sym;
            SLDMark mark = new SLDMark();
            mark.setMarkType(1);
            String wkn = PointSymbolUtils.getMarkWellKnownName(aux.getStyle());
            mark.setWellKnownName(wkn);
            Color fillColor = aux.getColor();
            Color borderColor = aux.getOutlineColor();
            double size = aux.getSize();
            double borderw = aux.getOutlineSize();
            double rot = aux.getRotation();
            rot = -rot * 180.0 / Math.PI;
            SLDFill fill = new SLDFill();
            if (fillColor == null) {
                fillColor = SLDFill.DEFAULT_FILL_COLOR;
            }
            fill.setFillColor(fillColor);
            mark.setFill(fill);
            SLDStroke stro = new SLDStroke();
            stro.setColor(borderColor);
            stro.setWidth((SLDExpression)new SLDLiteral(BasicUtils.df.format(borderw)));
            mark.setStroke(stro);
            SLDGraphic gra = new SLDGraphic();
            SLDParameterValue pv = new SLDParameterValue();
            pv.getExpressionList().add(new SLDLiteral(BasicUtils.df.format(size)));
            gra.setSize(pv);
            pv = new SLDParameterValue();
            pv.getExpressionList().add(new SLDLiteral(BasicUtils.df.format(rot)));
            gra.setRotation(pv);
            gra.getElementStack().add(mark);
            SLDPointSymbol resp = new SLDPointSymbol();
            resp.setGraphic(gra);
            return resp;
        }
        throw new UnsupportedSymbolException(sym.getClass().getName(), "Unsupported class for conversion to SLD");
    }
}

