/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.type.GeometryType;

public class STGeometryTypeFunction
extends AbstractGeometryFunction {
    public STGeometryTypeFunction() {
        super("OGC", "ST_GeometryType", Range.is((Comparable)Integer.valueOf(1)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Geometry geom = this.getGeom(args, 0);
        GeometryType type = geom.getGeometryType();
        String suffix = "";
        if (type.hasZ()) {
            suffix = type.hasM() ? "ZM" : "Z";
        } else if (type.hasM()) {
            suffix = "M";
        }
        if (type.isSubTypeOf(1)) {
            return "ST_Point" + suffix;
        }
        if (type.isSubTypeOf(2)) {
            return "ST_LineString" + suffix;
        }
        if (type.isSubTypeOf(3)) {
            return "ST_Polygon" + suffix;
        }
        if (type.isSubTypeOf(7)) {
            return "ST_MultiPoint" + suffix;
        }
        if (type.isSubTypeOf(8)) {
            return "ST_MultiLineString" + suffix;
        }
        if (type.isSubTypeOf(9)) {
            return "ST_MultiPolygon" + suffix;
        }
        return "unknown";
    }
}

