/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import org.apache.commons.lang3.Range;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;

public class STSetSRIDFunction
extends AbstractGeometryFunction {
    public STSetSRIDFunction() {
        super("OGC", "ST_SetSRID", Range.is((Comparable)Integer.valueOf(2)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Geometry geom = this.getGeom(args, 0);
        int srid = this.getInt(args, 1);
        IProjection proj = CRSFactory.getCRS((String)("EPSG:" + srid));
        if (proj == null) {
            throw new ExpressionRuntimeException("Invalid SRID '" + srid + "'.");
        }
        geom.setProjection(proj);
        return geom;
    }
}

