/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import org.apache.commons.lang3.Range;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class STTransformFunction
extends AbstractGeometryFunction {
    public STTransformFunction() {
        super("OGC", "ST_Transform", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        IProjection to_proj = null;
        IProjection from_proj = null;
        Integer to_srid = null;
        Geometry geom = this.getGeom(args, 0);
        switch (args.length) {
            case 2: {
                to_srid = (Integer)DataTypeUtils.coerce((int)4, (Object)this.getObject(args, 1), null);
                to_proj = to_srid == null ? CRSFactory.getCRS((String)this.getStr(args, 1)) : CRSFactory.getCRS((String)("EPSG:" + to_srid));
                from_proj = geom.getProjection();
                break;
            }
            case 3: {
                to_srid = (Integer)DataTypeUtils.coerce((int)4, (Object)this.getObject(args, 2), null);
                to_proj = to_srid == null ? CRSFactory.getCRS((String)this.getStr(args, 2)) : CRSFactory.getCRS((String)("EPSG:" + to_srid));
                from_proj = CRSFactory.getCRS((String)this.getStr(args, 1));
                break;
            }
            default: {
                throw new ExpressionRuntimeException("Incorrect number of arguments.");
            }
        }
        ICoordTrans ct = from_proj.getCT(to_proj);
        Geometry r = geom.cloneGeometry();
        r.reProject(ct);
        return r;
    }
}

