/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.repr;

import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ReprMethod;
import org.gvsig.fmap.geom.Geometry;

public class ReprGeometry
implements ReprMethod {
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isApplicable(Object value) {
        return value instanceof Geometry;
    }

    public String repr(Object value) {
        StringBuilder builder = new StringBuilder();
        try {
            if (value == null) {
                return "CAST(NULL AS geometry)";
            }
            Geometry geom = (Geometry)value;
            IProjection proj = geom.getProjection();
            if (proj == null) {
                builder.append("ST_GEOMFROMTEXT('");
                builder.append(geom.convertToWKT());
                builder.append("')");
            } else {
                String abrev = geom.getProjection().getAbrev();
                String srid = abrev.split(":")[1];
                builder.append("ST_SETSRID(ST_GEOMFROMTEXT('");
                builder.append(geom.convertToWKT());
                builder.append("'),");
                builder.append(srid);
                builder.append(")");
            }
        }
        catch (Exception ex) {
            builder.append("CAST('UNKNOW' AS geometry)");
        }
        return builder.toString();
    }

    public static void selfRegister() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        manager.addReprMethod((ReprMethod)new ReprGeometry());
    }
}

