/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.netcdf.app.netcdfclient;

import javax.swing.Icon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.netcdf.app.netcdfclient.gui.panel.NetCDFPanel;
import org.gvsig.raster.netcdf.io.NetCDFDataParameters;

public class NetCDFMenuEntry
extends AbstractTocContextMenuAction {
    private static NetCDFMenuEntry singleton = null;

    private NetCDFMenuEntry() {
    }

    public static NetCDFMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new NetCDFMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "Raster";
    }

    public int getGroupOrder() {
        return 50;
    }

    public int getOrder() {
        return 1;
    }

    public String getText() {
        return PluginServices.getText((Object)((Object)this), (String)"NetCDF_Variables");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof FLyrRaster)) {
            return false;
        }
        if (((FLyrRaster)selectedItems[0]).getDataStore() != null) {
            return ((FLyrRaster)selectedItems[0]).getDataStore().getInternalParameters() instanceof NetCDFDataParameters;
        }
        return false;
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer lyr = null;
        if (selectedItems.length != 1) {
            return;
        }
        lyr = selectedItems[0];
        if (!(lyr instanceof FLyrRaster)) {
            return;
        }
        FLyrRaster fLayer = (FLyrRaster)lyr;
        NetCDFPanel panel = new NetCDFPanel(fLayer);
        PluginServices.getMDIManager().addWindow((IWindow)panel);
        PluginServices.getMDIManager().getWindowInfo((IWindow)panel).setHeight(NetCDFPanel.HEIGHT);
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"save-icon");
    }
}

