/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.netcdf.app.netcdfclient.gui.panel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.netcdf.app.netcdfclient.gui.panel.VariableSelectionPanel;
import org.gvsig.raster.netcdf.io.NetCDFDataParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;

public class NetCDFPanel
extends DefaultButtonsPanel
implements IWindow,
ActionListener,
ButtonsPanelListener {
    private static final long serialVersionUID = 1L;
    private static String NOVALUE = "---";
    private VariableSelectionPanel panel = null;
    private FLyrRaster lyr = null;
    private static boolean blockRefreshEvent = false;
    private ArrayList<Variable> listVars = null;
    public static int HEIGHT = 360;
    public static int WIDTH = 340;
    private Logger logger = LoggerFactory.getLogger((String)NetCDFPanel.class.toString());

    public NetCDFPanel(FLyrRaster lyr) {
        super(9);
        this.addButtonPressedListener(this);
        this.lyr = lyr;
        this.initialize();
        try {
            this.loadVariablesFromParameters();
        }
        catch (IOException e) {
            this.panel.getGridVariableCombo().setSelectedIndex(0);
        }
        this.setStatus();
    }

    protected void initialize() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this.getVariableSelectionPanel(), gbc);
        this.panel.getLevelCombo().addActionListener(this);
        this.panel.getTimeCombo().addActionListener(this);
        this.panel.getGridVariableCombo().addActionListener(this);
        this.panel.getGridVarUpDownPanel().getUpButton().addActionListener(this);
        this.panel.getGridVarUpDownPanel().getDownButton().addActionListener(this);
        this.panel.getTimeUpDownPanel().getUpButton().addActionListener(this);
        this.panel.getTimeUpDownPanel().getDownButton().addActionListener(this);
        this.panel.getLevelUpDownPanel().getUpButton().addActionListener(this);
        this.panel.getLevelUpDownPanel().getDownButton().addActionListener(this);
        this.panel.getVarPropertiesButton().addActionListener(this);
        this.panel.getVariableCombo().addActionListener(this);
    }

    private void setStatus() {
        NetCDFDataParameters params = (NetCDFDataParameters)this.lyr.getDataStore().getInternalParameters();
        Integer time = params.getFieldTime();
        Integer level = params.getFieldLevel();
        String fieldVar = params.getStringVariable();
        blockRefreshEvent = true;
        for (int i = 0; i < this.panel.getGridVariableCombo().getItemCount(); ++i) {
            if (fieldVar.compareTo((String)this.panel.getGridVariableCombo().getItemAt(i)) != 0) continue;
            this.panel.getGridVariableCombo().setSelectedIndex(i);
            break;
        }
        this.panel.getTimeCombo().setSelectedIndex(time);
        this.panel.getLevelCombo().setSelectedIndex(level);
        blockRefreshEvent = false;
    }

    private void loadVariablesFromParameters() throws IOException {
        int i;
        NetCDFDataParameters params = (NetCDFDataParameters)this.lyr.getDataStore().getInternalParameters();
        this.panel.getXDimField().setText(params.getXDimVariable());
        this.panel.getYDimField().setText(params.getYDimVariable());
        blockRefreshEvent = true;
        ArrayList listGridVars = params.getGridVariables();
        this.panel.getGridVariableCombo().removeAllItems();
        for (i = 0; i < listGridVars.size(); ++i) {
            this.panel.getGridVariableCombo().addItem(((String[])listGridVars.get(i))[0]);
        }
        this.listVars = params.getVariables();
        this.panel.getVariableCombo().removeAllItems();
        if (this.listVars != null) {
            for (i = 0; i < this.listVars.size(); ++i) {
                this.panel.getVariableCombo().addItem(this.listVars.get(i).getName());
            }
        } else {
            this.panel.getLevelCombo().addItem(NOVALUE);
        }
        Date[] dateList = params.getTimeList(params.getStringVariable());
        this.panel.getTimeCombo().removeAllItems();
        if (dateList != null) {
            for (int i2 = 0; i2 < dateList.length; ++i2) {
                this.panel.getTimeCombo().addItem(dateList[i2]);
            }
        } else {
            this.panel.getTimeCombo().addItem(NOVALUE);
        }
        this.panel.getLevelCombo().removeAllItems();
        double[] levels = params.getLevelList(params.getStringVariable());
        if (levels != null) {
            for (int i3 = 0; i3 < levels.length; ++i3) {
                this.panel.getLevelCombo().addItem(levels[i3]);
            }
        } else {
            this.panel.getLevelCombo().addItem(NOVALUE);
        }
        blockRefreshEvent = false;
    }

    private void loadDescription(String selectedVariable) throws IOException {
        NetCDFDataParameters params = (NetCDFDataParameters)this.lyr.getDataStore().getInternalParameters();
        ArrayList list = params.getGridVariables();
        for (int i = 0; i < list.size(); ++i) {
            String[] values = (String[])list.get(i);
            if (values[0].compareTo(selectedVariable) != 0) continue;
            this.panel.getTxtDescription().setText(values[1]);
        }
    }

    private void loadLevel() {
        NetCDFDataParameters params = (NetCDFDataParameters)this.lyr.getDataStore().getInternalParameters();
        double[] levels = params.getLevelList((String)this.panel.getGridVariableCombo().getSelectedItem());
        blockRefreshEvent = true;
        this.panel.getLevelCombo().removeAllItems();
        if (levels != null) {
            for (int i = 0; i < levels.length; ++i) {
                this.panel.getLevelCombo().addItem(levels[i]);
            }
        } else {
            this.panel.getLevelCombo().addItem(NOVALUE);
        }
        blockRefreshEvent = false;
    }

    private void loadDates() {
        NetCDFDataParameters params = (NetCDFDataParameters)this.lyr.getDataStore().getInternalParameters();
        Date[] dateList = params.getTimeList((String)this.panel.getGridVariableCombo().getSelectedItem());
        blockRefreshEvent = true;
        this.panel.getTimeCombo().removeAllItems();
        if (dateList != null) {
            for (int i = 0; i < dateList.length; ++i) {
                this.panel.getTimeCombo().addItem(dateList[i]);
            }
        } else {
            this.panel.getTimeCombo().addItem(NOVALUE);
        }
        blockRefreshEvent = false;
    }

    private VariableSelectionPanel getVariableSelectionPanel() {
        if (this.panel == null) {
            this.panel = new VariableSelectionPanel();
            this.panel.getGridVariableCombo().addActionListener(this);
        }
        return this.panel;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(16);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"NetCDF_Variables"));
        m_viewinfo.setHeight(HEIGHT);
        m_viewinfo.setWidth(WIDTH);
        return m_viewinfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (blockRefreshEvent) {
            return;
        }
        if (e.getSource() == this.panel.getGridVariableCombo()) {
            try {
                this.loadDescription((String)this.panel.getGridVariableCombo().getSelectedItem());
                this.loadLevel();
                this.loadDates();
            }
            catch (IOException e1) {
                this.panel.getTxtDescription().setText("?");
            }
        }
        if (e.getSource() == this.panel.getGridVarUpDownPanel().getDownButton()) {
            this.panel.getGridVariableCombo().setSelectedIndex(Math.min(this.panel.getGridVariableCombo().getSelectedIndex() + 1, this.panel.getGridVariableCombo().getItemCount() - 1));
        }
        if (e.getSource() == this.panel.getGridVarUpDownPanel().getUpButton()) {
            this.panel.getGridVariableCombo().setSelectedIndex(Math.max(this.panel.getGridVariableCombo().getSelectedIndex() - 1, 0));
        }
        if (e.getSource() == this.panel.getTimeUpDownPanel().getDownButton()) {
            this.panel.getTimeCombo().setSelectedIndex(Math.min(this.panel.getTimeCombo().getSelectedIndex() + 1, this.panel.getTimeCombo().getItemCount() - 1));
        }
        if (e.getSource() == this.panel.getTimeUpDownPanel().getUpButton()) {
            this.panel.getTimeCombo().setSelectedIndex(Math.max(this.panel.getTimeCombo().getSelectedIndex() - 1, 0));
        }
        if (e.getSource() == this.panel.getLevelUpDownPanel().getDownButton()) {
            this.panel.getLevelCombo().setSelectedIndex(Math.min(this.panel.getLevelCombo().getSelectedIndex() + 1, this.panel.getLevelCombo().getItemCount() - 1));
        }
        if (e.getSource() == this.panel.getLevelUpDownPanel().getUpButton()) {
            this.panel.getLevelCombo().setSelectedIndex(Math.max(this.panel.getLevelCombo().getSelectedIndex() - 1, 0));
        }
        if (e.getSource() == this.panel.getVarPropertiesButton()) {
            this.showVariableProperties((String)this.panel.getVariableCombo().getSelectedItem());
            this.openVariableTable();
        }
        if (e.getSource() == this.panel.getVariableCombo()) {
            this.showVariableProperties((String)this.panel.getVariableCombo().getSelectedItem());
        }
        if (e.getSource() == this.panel.getGridVariableCombo() || e.getSource() == this.panel.getTimeCombo() || e.getSource() == this.panel.getLevelCombo()) {
            this.actionButtonPressed(null);
        }
    }

    private void showVariableProperties(String var) {
        if (this.listVars != null) {
            ArrayList<String[]> varValue = new ArrayList<String[]>();
            for (int i = 0; i < this.listVars.size(); ++i) {
                Variable v = this.listVars.get(i);
                String name = v.getName();
                if (name.compareTo(var) != 0) continue;
                varValue.add(new String[]{PluginServices.getText((Object)this, (String)"description"), v.getDescription()});
                varValue.add(new String[]{PluginServices.getText((Object)this, (String)"dimensions"), v.getDimensionsString()});
                int[] shape = v.getShape();
                String shapeString = "";
                for (int j = 0; j < shape.length; ++j) {
                    shapeString = shapeString + shape[j] + ", ";
                }
                varValue.add(new String[]{PluginServices.getText((Object)this, (String)"shape"), shapeString});
                varValue.add(new String[]{PluginServices.getText((Object)this, (String)"units"), v.getUnitsString()});
                varValue.add(new String[]{PluginServices.getText((Object)this, (String)"dataType"), v.getDataType().toString()});
            }
            try {
                this.panel.getTablePanel().getTable().removeAllRows();
            }
            catch (NotInitializeException e) {
                this.logger.debug(Messages.getText((String)"error_removing_rows"), (Throwable)e);
            }
            this.panel.getTablePanel().setRows(varValue);
        }
    }

    private void openVariableTable() {
        if (this.panel.getSouthPanel().isVisible()) {
            this.panel.showTable(false);
            PluginServices.getMDIManager().getWindowInfo((IWindow)this).setHeight(HEIGHT);
        } else {
            this.panel.showTable(true);
            PluginServices.getMDIManager().getWindowInfo((IWindow)this).setHeight(500);
        }
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (blockRefreshEvent) {
            return;
        }
        if (e == null || e.getButton() == 3) {
            NetCDFDataParameters newParams = (NetCDFDataParameters)this.lyr.getDataStore().getInternalParameters();
            newParams.setDynValue("GridVariable", this.panel.getGridVariableCombo().getSelectedItem());
            String value = this.panel.getTimeCombo().getSelectedItem().toString();
            newParams.setDynValue("Time", (Object)(value.compareTo(NOVALUE) == 0 ? 0 : this.panel.getTimeCombo().getSelectedIndex()));
            value = this.panel.getLevelCombo().getSelectedItem().toString();
            newParams.setDynValue("Level", (Object)(value.compareTo(NOVALUE) == 0 ? new Integer(0) : new Integer(this.panel.getLevelCombo().getSelectedIndex())));
            try {
                this.lyr.getDataStore().getStatistics().forceToRecalc();
                this.lyr.getDataStore().getStatistics().calculate(1.0);
            }
            catch (FileNotOpenException e1) {
                this.logger.debug(Messages.getText((String)"error_stats"), (Throwable)e1);
            }
            catch (RasterDriverException e1) {
                this.logger.debug(Messages.getText((String)"error_stats"), (Throwable)e1);
            }
            catch (ProcessInterruptedException processInterruptedException) {
                // empty catch block
            }
            if (this.lyr.getRender().getColorTable() != null) {
                this.lyr.getRender().getColorTable().createColorTableInRange(this.lyr.getDataStore().getStatistics().getMinimun(), this.lyr.getDataStore().getStatistics().getMaximun(), false);
            }
            this.lyr.getMapContext().invalidate();
        }
        if (e != null && e.getButton() == 6) {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }
}

