/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.util.LabeledValue;

public class DropDownButton
implements DropDown {
    private final AbstractButton component;
    private final Set<ItemListener> itemListeners;
    private ComboBoxModel model;
    private int selectedIndex;
    private JPopupMenu popup;
    private List<ImageIcon> icons;
    private boolean readonly = false;
    private Color disabledForeground = null;
    private Color enabledForeground = null;
    private boolean visibleDropdownArrow = true;
    private final Color warningBackgroundColor;
    private final Color backgroundColor;
    private final ActionListenerSupport dropdownListsnersHelper;

    public DropDownButton(AbstractButton button, Color warningBackgroundColor) {
        this.component = button;
        this.itemListeners = new HashSet<ItemListener>();
        this.dropdownListsnersHelper = new DefaultActionListenerSupport();
        this.component.setCursor(Cursor.getPredefinedCursor(12));
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DropDownButton.this.doShowPopup();
            }
        });
        this.icons = null;
        this.warningBackgroundColor = warningBackgroundColor;
        this.backgroundColor = button.getBackground();
        String s = this.component.getText();
        if (!s.endsWith(" \u25be")) {
            this.component.setText(s + " \u25be");
        }
        this.component.addActionListener(e -> this.doShowPopup());
    }

    public JComponent asJComponent() {
        return this.component;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.disabledForeground == null) {
            this.disabledForeground = UIManager.getColor("Button.disabledText");
            this.enabledForeground = UIManager.getColor("Button.foreground");
        }
        this.readonly = readOnly;
        if (readOnly) {
            this.component.setForeground(this.disabledForeground);
        } else {
            this.component.setForeground(this.enabledForeground);
        }
    }

    public void setVisibleDropdownArrow(boolean visible) {
        this.visibleDropdownArrow = visible;
        String s = this.component.getText();
        if (this.visibleDropdownArrow) {
            if (!s.endsWith(" \u25be")) {
                this.component.setText(s + " \u25be");
            }
        } else if (s.endsWith(" \u25be")) {
            this.component.setText(s.substring(0, s.length() - 1));
        }
    }

    public boolean isVisibleDropdownArrow() {
        return this.visibleDropdownArrow;
    }

    public void setEnabled(boolean enabled) {
        this.component.setEnabled(enabled);
    }

    private void doShowPopup() {
        ActionEvent ev = new ActionEvent(this, 0, null);
        this.dropdownListsnersHelper.fireActionEvent(ev);
        if (this.model == null) {
            return;
        }
        this.popup = new JPopupMenu();
        for (int i = 0; i < this.model.getSize(); ++i) {
            this.popup.add(this.createItem(i));
        }
        Point p = this.component.getLocationOnScreen();
        this.popup.show(this.component, 0, this.component.getHeight());
    }

    public void setIcons(List<ImageIcon> icons) {
        this.icons = icons;
    }

    public List<ImageIcon> getIcons() {
        return this.icons;
    }

    private ImageIcon getIcon(int index) {
        if (this.icons == null || index < 0 || index > this.icons.size()) {
            return null;
        }
        return this.icons.get(index);
    }

    private JMenuItem createItem(final int index) {
        JMenuItem item = new JMenuItem(Objects.toString(this.model.getElementAt(index), ""));
        item.setEnabled(!this.readonly);
        item.setIcon(this.getIcon(index));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DropDownButton.this.readonly) {
                    return;
                }
                DropDownButton.this.setSelectedIndex(index);
                ItemEvent ie = new ItemEvent((ItemSelectable)((Object)DropDownButton.this), 1, index, 1);
                for (ItemListener itemListener : DropDownButton.this.itemListeners) {
                    if (itemListener == null) continue;
                    itemListener.itemStateChanged(ie);
                }
            }
        });
        return item;
    }

    public void setModel(ComboBoxModel model) {
        this.model = model;
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public void setValue(Object value) {
        ComboBoxModel model = this.getModel();
        if (model == null) {
            throw new IllegalStateException("Can't set value when model is null");
        }
        for (int i = 0; i < model.getSize(); ++i) {
            Object item = model.getElementAt(i);
            if (item instanceof LabeledValue) {
                item = ((LabeledValue)item).getValue();
            }
            if (!Objects.equals(item, value)) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setText(Objects.toString(value), this.warningBackgroundColor);
    }

    public void setSelectedIndex(int i) {
        if (this.model == null) {
            return;
        }
        String value = null;
        if (i < 0) {
            this.component.setToolTipText(null);
        } else {
            value = Objects.toString(this.model.getElementAt(i), "");
            this.component.setToolTipText(value);
        }
        if (StringUtils.isBlank(value)) {
            value = "     ";
        }
        this.setText(value);
        this.selectedIndex = i;
    }

    private void setText(String s, Color backgroundColor) {
        if (this.visibleDropdownArrow) {
            if (!s.endsWith(" \u25be")) {
                this.component.setText(s + " \u25be");
            }
        } else if (s.endsWith(" \u25be")) {
            this.component.setText(s.substring(0, s.length() - 1));
        }
        this.component.setBackground(backgroundColor);
    }

    protected void setText(String s) {
        this.setText(s, this.backgroundColor);
    }

    public Object getSelectedItem() {
        if (this.model == null) {
            return null;
        }
        return this.model.getElementAt(this.selectedIndex);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object[] getSelectedObjects() {
        if (this.model == null) {
            return null;
        }
        return new Object[]{this.getSelectedItem()};
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.add(itemListener);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    public void addDropdownListener(ActionListener listener) {
        this.dropdownListsnersHelper.addActionListener(listener);
    }

    public void removeDropdownListener(ActionListener listener) {
        this.dropdownListsnersHelper.removeActionListener(listener);
    }
}

