/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.gvsig.tools.swing.api.TextComponentUndoRedoHelper;

public class TextComponentUndoRedoHelperImpl
implements TextComponentUndoRedoHelper {
    private UndoManager undoManager;
    private final UndoableEditListener undoableEditListener = new UndoableEditListener(){

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            TextComponentUndoRedoHelperImpl.this.createUndoMananger();
            TextComponentUndoRedoHelperImpl.this.undoManager.addEdit(e.getEdit());
        }
    };
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 90 && e.isControlDown()) {
                try {
                    TextComponentUndoRedoHelperImpl.this.createUndoMananger();
                    TextComponentUndoRedoHelperImpl.this.undoManager.undo();
                }
                catch (CannotUndoException cue) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            if (e.getKeyCode() == 89 && e.isControlDown()) {
                try {
                    TextComponentUndoRedoHelperImpl.this.createUndoMananger();
                    TextComponentUndoRedoHelperImpl.this.undoManager.redo();
                }
                catch (CannotRedoException cue) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    };
    private final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            TextComponentUndoRedoHelperImpl.this.createUndoMananger();
        }

        @Override
        public void focusLost(FocusEvent e) {
            TextComponentUndoRedoHelperImpl.this.removeUndoMananger();
        }
    };

    public void install(JTextComponent text) {
    }

    private void createUndoMananger() {
        if (this.undoManager == null) {
            this.undoManager = new UndoManager();
            this.undoManager.setLimit(10);
        }
    }

    private void removeUndoMananger() {
        this.undoManager.end();
    }
}

